/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.spark.sql.catalyst.analysis.GetViewColumnByNameAndOrdinal;
import org.apache.spark.sql.catalyst.analysis.MultiInstanceRelation;
import org.apache.spark.sql.catalyst.analysis.ResolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.resolver.AttributeScopeStack;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionIdAssigner$;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolutionValidator;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.CTERelationDef;
import org.apache.spark.sql.catalyst.plans.logical.CTERelationRef;
import org.apache.spark.sql.catalyst.plans.logical.Distinct;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Offset;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Range;
import org.apache.spark.sql.catalyst.plans.logical.Repartition;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.plans.logical.SetOperation;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.SupervisingCommand;
import org.apache.spark.sql.catalyst.plans.logical.Tail;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.plans.logical.WithCTE;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001\u0002\u0011\"\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004A\u0001\u0001\u0006I!\u0010\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0011\u00191\u0005\u0001)A\u0005\u0007\")q\t\u0001C\u0001y!)\u0001\n\u0001C\u0001\u0013\")q\u000b\u0001C\u00011\")1\f\u0001C\u00059\")!\r\u0001C\u0005G\")\u0011\u000e\u0001C\u0005U\")\u0001\u000f\u0001C\u0005c\")q\u000f\u0001C\u0005q\")a\u0010\u0001C\u0005\u007f\"9\u00111\u0002\u0001\u0005\n\u00055\u0001bBA\r\u0001\u0011%\u00111\u0004\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\t)\u0004\u0001C\u0005\u0003oAq!a\u0011\u0001\t\u0013\t)\u0005C\u0004\u0002R\u0001!I!a\u0015\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b!9\u0011Q\u000e\u0001\u0005\n\u0005=\u0004bBA?\u0001\u0011%\u0011q\u0010\u0005\b\u0003\u000b\u0003A\u0011BAD\u0011\u001d\tY\t\u0001C\u0005\u0003\u001bCq!!'\u0001\t\u0013\tY\nC\u0004\u0002(\u0002!I!!+\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0007bBAi\u0001\u0011%\u00111\u001b\u0005\b\u0003/\u0004A\u0011BAm\u0005M\u0011Vm]8mkRLwN\u001c,bY&$\u0017\r^8s\u0015\t\u00113%\u0001\u0005sKN|GN^3s\u0015\t!S%\u0001\u0005b]\u0006d\u0017p]5t\u0015\t1s%\u0001\u0005dCR\fG._:u\u0015\tA\u0013&A\u0002tc2T!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0002\"A\u000f\u0001\u000e\u0003\u0005\n1#\u0019;ue&\u0014W\u000f^3TG>\u0004Xm\u0015;bG.,\u0012!\u0010\t\u0003uyJ!aP\u0011\u0003'\u0005#HO]5ckR,7kY8qKN#\u0018mY6\u0002)\u0005$HO]5ckR,7kY8qKN#\u0018mY6!\u0003u)\u0007\u0010\u001d:fgNLwN\u001c*fg>dW\u000f^5p]Z\u000bG.\u001b3bi>\u0014X#A\"\u0011\u0005i\"\u0015BA#\"\u0005u)\u0005\u0010\u001d:fgNLwN\u001c*fg>dW\u000f^5p]Z\u000bG.\u001b3bi>\u0014\u0018AH3yaJ,7o]5p]J+7o\u001c7vi&|gNV1mS\u0012\fGo\u001c:!\u0003Y9W\r^!uiJL'-\u001e;f'\u000e|\u0007/Z*uC\u000e\\\u0017\u0001\u0004<bY&$\u0017\r^3QY\u0006tGC\u0001&N!\t\u00114*\u0003\u0002Mg\t!QK\\5u\u0011\u0015qu\u00011\u0001P\u0003\u0011\u0001H.\u00198\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003)\u0016\nQ\u0001\u001d7b]NL!AV)\u0003\u00171{w-[2bYBc\u0017M\\\u0001\tm\u0006d\u0017\u000eZ1uKR\u0011!*\u0017\u0005\u00065\"\u0001\raT\u0001\t_B,'/\u0019;pe\u0006aa/\u00197jI\u0006$XmV5uQR\u0011!*\u0018\u0005\u0006=&\u0001\raX\u0001\bo&$\bn\u0011;f!\t\u0001\u0006-\u0003\u0002b#\n9q+\u001b;i\u0007R+\u0015A\u0006<bY&$\u0017\r^3Di\u0016\u0014V\r\\1uS>tG)\u001a4\u0015\u0005)#\u0007\"B3\u000b\u0001\u00041\u0017AD2uKJ+G.\u0019;j_:$UM\u001a\t\u0003!\u001eL!\u0001[)\u0003\u001d\r#VIU3mCRLwN\u001c#fM\u00061b/\u00197jI\u0006$Xm\u0011;f%\u0016d\u0017\r^5p]J+g\r\u0006\u0002KW\")An\u0003a\u0001[\u0006q1\r^3SK2\fG/[8o%\u00164\u0007C\u0001)o\u0013\ty\u0017K\u0001\bD)\u0016\u0013V\r\\1uS>t'+\u001a4\u0002#Y\fG.\u001b3bi\u0016\fum\u001a:fO\u0006$X\r\u0006\u0002Ke\")1\u000f\u0004a\u0001i\u0006I\u0011mZ4sK\u001e\fG/\u001a\t\u0003!VL!A^)\u0003\u0013\u0005;wM]3hCR,\u0017a\u0004<bY&$\u0017\r^3Qe>TWm\u0019;\u0015\u0005)K\b\"\u0002>\u000e\u0001\u0004Y\u0018a\u00029s_*,7\r\u001e\t\u0003!rL!!`)\u0003\u000fA\u0013xN[3di\u0006qa/\u00197jI\u0006$XMR5mi\u0016\u0014Hc\u0001&\u0002\u0002!9\u00111\u0001\bA\u0002\u0005\u0015\u0011A\u00024jYR,'\u000fE\u0002Q\u0003\u000fI1!!\u0003R\u0005\u00191\u0015\u000e\u001c;fe\u0006)b/\u00197jI\u0006$XmU;ccV,'/_!mS\u0006\u001cHc\u0001&\u0002\u0010!9\u0011\u0011C\bA\u0002\u0005M\u0011!D:vEF,XM]=BY&\f7\u000fE\u0002Q\u0003+I1!a\u0006R\u00055\u0019VOY9vKJL\u0018\t\\5bg\u0006aa/\u00197jI\u0006$XMV5foR\u0019!*!\b\t\u000f\u0005}\u0001\u00031\u0001\u0002\"\u0005!a/[3x!\r\u0001\u00161E\u0005\u0004\u0003K\t&\u0001\u0002,jK^\f1C^1mS\u0012\fG/Z$m_\n\fG\u000eT5nSR$2ASA\u0016\u0011\u001d\ti#\u0005a\u0001\u0003_\t1b\u001a7pE\u0006dG*[7jiB\u0019\u0001+!\r\n\u0007\u0005M\u0012KA\u0006HY>\u0014\u0017\r\u001c'j[&$\u0018A\u0005<bY&$\u0017\r^3M_\u000e\fG\u000eT5nSR$2ASA\u001d\u0011\u001d\tYD\u0005a\u0001\u0003{\t!\u0002\\8dC2d\u0015.\\5u!\r\u0001\u0016qH\u0005\u0004\u0003\u0003\n&A\u0003'pG\u0006dG*[7ji\u0006qa/\u00197jI\u0006$Xm\u00144gg\u0016$Hc\u0001&\u0002H!9\u0011\u0011J\nA\u0002\u0005-\u0013AB8gMN,G\u000fE\u0002Q\u0003\u001bJ1!a\u0014R\u0005\u0019yeMZ:fi\u0006aa/\u00197jI\u0006$X\rV1jYR\u0019!*!\u0016\t\u000f\u0005]C\u00031\u0001\u0002Z\u0005!A/Y5m!\r\u0001\u00161L\u0005\u0004\u0003;\n&\u0001\u0002+bS2\f\u0001C^1mS\u0012\fG/\u001a#jgRLgn\u0019;\u0015\u0007)\u000b\u0019\u0007C\u0004\u0002fU\u0001\r!a\u001a\u0002\u0011\u0011L7\u000f^5oGR\u00042\u0001UA5\u0013\r\tY'\u0015\u0002\t\t&\u001cH/\u001b8di\u0006\u0019b/\u00197jI\u0006$X-\u00138mS:,G+\u00192mKR\u0019!*!\u001d\t\u000f\u0005Md\u00031\u0001\u0002v\u0005Y\u0011N\u001c7j]\u0016$\u0016M\u00197f!\u0011\t9(!\u001f\u000e\u0003\rJ1!a\u001f$\u0005M\u0011Vm]8mm\u0016$\u0017J\u001c7j]\u0016$\u0016M\u00197f\u0003A1\u0018\r\\5eCR,'+\u001a7bi&|g\u000eF\u0002K\u0003\u0003Ca!a!\u0018\u0001\u0004y\u0015\u0001\u0003:fY\u0006$\u0018n\u001c8\u00021Y\fG.\u001b3bi\u0016\u001cV\r^(qKJ\fG/[8o\u0019&\\W\rF\u0002K\u0003\u0013CQA\u0014\rA\u0002=\u000bAB^1mS\u0012\fG/Z*peR$2ASAH\u0011\u001d\t\t*\u0007a\u0001\u0003'\u000bAa]8siB\u0019\u0001+!&\n\u0007\u0005]\u0015K\u0001\u0003T_J$\u0018a\u0005<bY&$\u0017\r^3SKB\f'\u000f^5uS>tGc\u0001&\u0002\u001e\"9\u0011q\u0014\u000eA\u0002\u0005\u0005\u0016a\u0003:fa\u0006\u0014H/\u001b;j_:\u00042\u0001UAR\u0013\r\t)+\u0015\u0002\f%\u0016\u0004\u0018M\u001d;ji&|g.\u0001\bwC2LG-\u0019;f'\u0006l\u0007\u000f\\3\u0015\u0007)\u000bY\u000bC\u0004\u0002.n\u0001\r!a,\u0002\rM\fW\u000e\u001d7f!\r\u0001\u0016\u0011W\u0005\u0004\u0003g\u000b&AB*b[BdW-\u0001\u0007wC2LG-\u0019;f\u0015>Lg\u000eF\u0002K\u0003sCq!a/\u001d\u0001\u0004\ti,\u0001\u0003k_&t\u0007c\u0001)\u0002@&\u0019\u0011\u0011Y)\u0003\t){\u0017N\\\u0001\u001bm\u0006d\u0017\u000eZ1uKN+\b/\u001a:wSNLgnZ\"p[6\fg\u000e\u001a\u000b\u0004\u0015\u0006\u001d\u0007bBAe;\u0001\u0007\u00111Z\u0001\u0013gV\u0004XM\u001d<jg&twmQ8n[\u0006tG\rE\u0002Q\u0003\u001bL1!a4R\u0005I\u0019V\u000f]3sm&\u001c\u0018N\\4D_6l\u0017M\u001c3\u0002)!\fg\u000e\u001a7f\u001fB,'/\u0019;pe>+H\u000f];u)\rQ\u0015Q\u001b\u0005\u00065z\u0001\raT\u0001\u000boJ\f\u0007/\u0012:s_J\u001cX\u0003BAn\u0003[$B!!8\u0002\u0000R\u0019!*a8\t\u0011\u0005\u0005x\u0004\"a\u0001\u0003G\fAAY8esB)!'!:\u0002j&\u0019\u0011q]\u001a\u0003\u0011q\u0012\u0017P\\1nKz\u0002B!a;\u0002n2\u0001AaBAx?\t\u0007\u0011\u0011\u001f\u0002\u0002%F!\u00111_A}!\r\u0011\u0014Q_\u0005\u0004\u0003o\u001c$a\u0002(pi\"Lgn\u001a\t\u0004e\u0005m\u0018bAA\u007fg\t\u0019\u0011I\\=\t\u000b9{\u0002\u0019A(")
public class ResolutionValidator {
    private final AttributeScopeStack attributeScopeStack = new AttributeScopeStack();
    private final ExpressionResolutionValidator expressionResolutionValidator = new ExpressionResolutionValidator(this);

    private AttributeScopeStack attributeScopeStack() {
        return this.attributeScopeStack;
    }

    private ExpressionResolutionValidator expressionResolutionValidator() {
        return this.expressionResolutionValidator;
    }

    public AttributeScopeStack getAttributeScopeStack() {
        return this.attributeScopeStack();
    }

    public void validatePlan(LogicalPlan plan2) {
        this.wrapErrors(plan2, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.validate(plan2));
    }

    public void validate(LogicalPlan operator) {
        LogicalPlan logicalPlan = operator;
        if (logicalPlan instanceof WithCTE) {
            WithCTE withCTE = (WithCTE)logicalPlan;
            this.validateWith(withCTE);
        } else if (logicalPlan instanceof CTERelationDef) {
            CTERelationDef cTERelationDef = (CTERelationDef)logicalPlan;
            this.validateCteRelationDef(cTERelationDef);
        } else if (logicalPlan instanceof CTERelationRef) {
            CTERelationRef cTERelationRef = (CTERelationRef)logicalPlan;
            this.validateCteRelationRef(cTERelationRef);
        } else if (logicalPlan instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)logicalPlan;
            this.validateAggregate(aggregate);
        } else if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            this.validateProject(project);
        } else if (logicalPlan instanceof Filter) {
            Filter filter = (Filter)logicalPlan;
            this.validateFilter(filter);
        } else if (logicalPlan instanceof SubqueryAlias) {
            SubqueryAlias subqueryAlias = (SubqueryAlias)logicalPlan;
            this.validateSubqueryAlias(subqueryAlias);
        } else if (logicalPlan instanceof View) {
            View view = (View)logicalPlan;
            this.validateView(view);
        } else if (logicalPlan instanceof GlobalLimit) {
            GlobalLimit globalLimit = (GlobalLimit)logicalPlan;
            this.validateGlobalLimit(globalLimit);
        } else if (logicalPlan instanceof LocalLimit) {
            LocalLimit localLimit = (LocalLimit)logicalPlan;
            this.validateLocalLimit(localLimit);
        } else if (logicalPlan instanceof Offset) {
            Offset offset = (Offset)logicalPlan;
            this.validateOffset(offset);
        } else if (logicalPlan instanceof Tail) {
            Tail tail = (Tail)logicalPlan;
            this.validateTail(tail);
        } else if (logicalPlan instanceof Distinct) {
            Distinct distinct = (Distinct)logicalPlan;
            this.validateDistinct(distinct);
        } else if (logicalPlan instanceof ResolvedInlineTable) {
            ResolvedInlineTable resolvedInlineTable = (ResolvedInlineTable)logicalPlan;
            this.validateInlineTable(resolvedInlineTable);
        } else if (logicalPlan instanceof LocalRelation) {
            LocalRelation localRelation = (LocalRelation)logicalPlan;
            this.validateRelation(localRelation);
        } else if (logicalPlan instanceof OneRowRelation) {
            OneRowRelation oneRowRelation = (OneRowRelation)logicalPlan;
            this.validateRelation(oneRowRelation);
        } else if (logicalPlan instanceof Range) {
            Range range = (Range)logicalPlan;
            this.validateRelation(range);
        } else if (logicalPlan instanceof Union ? true : logicalPlan instanceof SetOperation) {
            this.validateSetOperationLike(logicalPlan);
        } else if (logicalPlan instanceof Sort) {
            Sort sort = (Sort)logicalPlan;
            this.validateSort(sort);
        } else if (logicalPlan instanceof Join) {
            Join join = (Join)logicalPlan;
            this.validateJoin(join);
        } else if (logicalPlan instanceof Repartition) {
            Repartition repartition = (Repartition)logicalPlan;
            this.validateRepartition(repartition);
        } else if (logicalPlan instanceof Sample) {
            Sample sample = (Sample)logicalPlan;
            this.validateSample(sample);
        } else if (logicalPlan instanceof MultiInstanceRelation) {
            LogicalPlan logicalPlan2 = logicalPlan;
            this.validateRelation(logicalPlan2);
        } else if (logicalPlan instanceof SupervisingCommand) {
            SupervisingCommand supervisingCommand = (SupervisingCommand)((Object)logicalPlan);
            this.validateSupervisingCommand(supervisingCommand);
        } else {
            throw new MatchError((Object)logicalPlan);
        }
        LogicalPlan logicalPlan3 = operator;
        if (logicalPlan3 instanceof WithCTE) {
            return;
        }
        ExpressionIdAssigner$.MODULE$.assertOutputsHaveNoConflictingExpressionIds((Seq<Seq<Attribute>>)((Seq)operator.children().map((Function1 & Serializable)x$1 -> x$1.output())));
    }

    private void validateWith(WithCTE withCte) {
        HashSet knownCteDefIds = new HashSet(withCte.cteDefs().length());
        withCte.cteDefs().foreach((Function1 & Serializable)cteDef -> BoxesRunTime.boxToBoolean((boolean)ResolutionValidator.$anonfun$validateWith$1(this, knownCteDefIds, cteDef)));
        this.validate(withCte.plan());
    }

    private void validateCteRelationDef(CTERelationDef cteRelationDef) {
        this.validate(cteRelationDef.child());
    }

    private void validateCteRelationRef(CTERelationRef cteRelationRef) {
        this.handleOperatorOutput(cteRelationRef);
    }

    private void validateAggregate(Aggregate aggregate) {
        this.attributeScopeStack().pushScope(this.attributeScopeStack().pushScope$default$1());
        try {
            this.validate(aggregate.child());
            this.expressionResolutionValidator().validateProjectList(aggregate.aggregateExpressions());
            aggregate.groupingExpressions().foreach((Function1 & Serializable)expression -> {
                ResolutionValidator.$anonfun$validateAggregate$1(this, expression);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.attributeScopeStack().popScope();
        }
        this.handleOperatorOutput(aggregate);
    }

    private void validateProject(Project project) {
        this.attributeScopeStack().pushScope(this.attributeScopeStack().pushScope$default$1());
        try {
            this.validate(project.child());
            this.expressionResolutionValidator().validateProjectList(project.projectList());
        }
        finally {
            this.attributeScopeStack().popScope();
        }
        this.handleOperatorOutput(project);
    }

    private void validateFilter(Filter filter) {
        this.validate(filter.child());
        DataType dataType = filter.condition().dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        Predef$.MODULE$.assert(!(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null), (Function0 & Serializable)() -> "Output type of a filter must be a boolean, but got: " + filter.condition().dataType().typeName());
        this.expressionResolutionValidator().validate(filter.condition());
    }

    private void validateSubqueryAlias(SubqueryAlias subqueryAlias) {
        this.validate(subqueryAlias.child());
        this.handleOperatorOutput(subqueryAlias);
    }

    private void validateView(View view) {
        this.validate(view.child());
        LogicalPlan logicalPlan = view.child();
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            Predef$.MODULE$.assert(!project.projectList().exists((Function1 & Serializable)expression -> BoxesRunTime.boxToBoolean((boolean)ResolutionValidator.$anonfun$validateView$1(expression))), (Function0 & Serializable)() -> "Resolved Project operator under a view cannot contain GetViewColumnByNameAndOrdinal");
        }
        this.handleOperatorOutput(view);
    }

    private void validateGlobalLimit(GlobalLimit globalLimit) {
        this.validate(globalLimit.child());
        this.expressionResolutionValidator().validate(globalLimit.limitExpr());
    }

    private void validateLocalLimit(LocalLimit localLimit) {
        this.validate(localLimit.child());
        this.expressionResolutionValidator().validate(localLimit.limitExpr());
    }

    private void validateOffset(Offset offset) {
        this.validate(offset.child());
        this.expressionResolutionValidator().validate(offset.offsetExpr());
    }

    private void validateTail(Tail tail) {
        this.validate(tail.child());
        this.expressionResolutionValidator().validate(tail.limitExpr());
    }

    private void validateDistinct(Distinct distinct) {
        this.validate(distinct.child());
    }

    private void validateInlineTable(ResolvedInlineTable inlineTable) {
        inlineTable.rows().foreach((Function1 & Serializable)row -> {
            row.foreach((Function1 & Serializable)expression -> {
                ResolutionValidator.$anonfun$validateInlineTable$2($this, expression);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.handleOperatorOutput(inlineTable);
    }

    private void validateRelation(LogicalPlan relation) {
        this.handleOperatorOutput(relation);
    }

    private void validateSetOperationLike(LogicalPlan plan2) {
        plan2.children().foreach((Function1 & Serializable)operator -> {
            this.validate(operator);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(plan2.children().length() > 1, (Function0 & Serializable)() -> plan2.nodeName() + " operator has to have at least 2 children");
        Seq<Attribute> firstChildOutput = ((QueryPlan)plan2.children().head()).output();
        ((IterableOnceOps)plan2.children().tail()).foreach((Function1 & Serializable)child -> {
            ResolutionValidator.$anonfun$validateSetOperationLike$3(firstChildOutput, plan2, child);
            return BoxedUnit.UNIT;
        });
        this.handleOperatorOutput(plan2);
    }

    private void validateSort(Sort sort) {
        this.validate(sort.child());
        sort.order().foreach((Function1 & Serializable)sortOrder -> {
            ResolutionValidator.$anonfun$validateSort$1(this, sortOrder);
            return BoxedUnit.UNIT;
        });
    }

    private void validateRepartition(Repartition repartition) {
        this.validate(repartition.child());
    }

    private void validateSample(Sample sample) {
        this.validate(sample.child());
    }

    private void validateJoin(Join join) {
        block9: {
            this.attributeScopeStack().pushScope(this.attributeScopeStack().pushScope$default$1());
            try {
                this.attributeScopeStack().pushScope(this.attributeScopeStack().pushScope$default$1());
                try {
                    this.validate(join.left());
                    this.validate(join.right());
                    Predef$.MODULE$.assert(join.left().outputSet().intersect(join.right().outputSet()).isEmpty());
                }
                finally {
                    this.attributeScopeStack().popScope();
                }
                this.attributeScopeStack().overwriteCurrent((Seq<Attribute>)((Seq)join.left().output().$plus$plus(join.right().output())));
                Option<Expression> option = join.condition();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Expression condition = (Expression)some.value();
                    this.expressionResolutionValidator().validate(condition);
                    break block9;
                }
                if (None$.MODULE$.equals(option)) {
                    break block9;
                }
                throw new MatchError(option);
            }
            finally {
                this.attributeScopeStack().popScope();
            }
        }
        this.handleOperatorOutput(join);
    }

    private void validateSupervisingCommand(SupervisingCommand supervisingCommand) {
    }

    private void handleOperatorOutput(LogicalPlan operator) {
        this.attributeScopeStack().overwriteCurrent(operator.output());
        operator.output().foreach((Function1 & Serializable)attribute -> {
            ResolutionValidator.$anonfun$handleOperatorOutput$1(this, attribute);
            return BoxedUnit.UNIT;
        });
    }

    private <R> void wrapErrors(LogicalPlan plan2, Function0<R> body) {
        try {
            body.apply();
        }
        catch (Throwable ex) {
            throw QueryCompilationErrors$.MODULE$.resolutionValidationError(ex, plan2);
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateWith$1(ResolutionValidator $this, HashSet knownCteDefIds$1, CTERelationDef cteDef) {
        Predef$.MODULE$.assert(!knownCteDefIds$1.contains(BoxesRunTime.boxToLong((long)cteDef.id())), (Function0 & Serializable)() -> "Duplicate CTE definition id: " + cteDef.id());
        $this.validate(cteDef);
        return knownCteDefIds$1.add(BoxesRunTime.boxToLong((long)cteDef.id()));
    }

    public static final /* synthetic */ void $anonfun$validateAggregate$1(ResolutionValidator $this, Expression expression) {
        $this.expressionResolutionValidator().validate(expression);
    }

    public static final /* synthetic */ boolean $anonfun$validateView$1(NamedExpression expression) {
        return expression instanceof GetViewColumnByNameAndOrdinal;
    }

    public static final /* synthetic */ void $anonfun$validateInlineTable$2(ResolutionValidator $this, Expression expression) {
        $this.expressionResolutionValidator().validate(expression);
    }

    public static final /* synthetic */ void $anonfun$validateSetOperationLike$3(Seq firstChildOutput$1, LogicalPlan plan$2, LogicalPlan child) {
        Seq<Attribute> childOutput = child.output();
        Predef$.MODULE$.assert(childOutput.length() == firstChildOutput$1.length(), (Function0 & Serializable)() -> "Unexpected output length for " + plan$2.nodeName() + " child " + child);
    }

    public static final /* synthetic */ void $anonfun$validateSort$1(ResolutionValidator $this, SortOrder sortOrder) {
        $this.expressionResolutionValidator().validate(sortOrder.child());
    }

    public static final /* synthetic */ void $anonfun$handleOperatorOutput$1(ResolutionValidator $this, Attribute attribute) {
        Predef$.MODULE$.assert(attribute instanceof AttributeReference, (Function0 & Serializable)() -> "Output of an operator must be a reference to an attribute, but got: " + attribute.getClass().getSimpleName());
        $this.expressionResolutionValidator().validate(attribute);
    }
}

