/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase.stats;

import java.util.List;
import org.apache.hadoop.hive.metastore.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.hbase.stats.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.hbase.stats.ColumnStatsAggregatorFactory;

public class StringColumnStatsAggregator
extends ColumnStatsAggregator {
    @Override
    public ColumnStatisticsObj aggregate(String colName, List<String> partNames, List<ColumnStatistics> css) throws MetaException {
        StringColumnStatsData aggregateData;
        ColumnStatisticsObj statsObj = null;
        boolean doAllPartitionContainStats = partNames.size() == css.size();
        boolean isNDVBitVectorSet = true;
        String colType = null;
        for (ColumnStatistics cs : css) {
            if (cs.getStatsObjSize() != 1) {
                throw new MetaException("The number of columns should be exactly one in aggrStats, but found " + cs.getStatsObjSize());
            }
            ColumnStatisticsObj cso = cs.getStatsObjIterator().next();
            if (statsObj == null) {
                colType = cso.getColType();
                statsObj = ColumnStatsAggregatorFactory.newColumnStaticsObj(colName, colType, (ColumnStatisticsData._Fields)cso.getStatsData().getSetField());
            }
            if (this.numBitVectors > 0 && cso.getStatsData().getStringStats().isSetBitVectors() && cso.getStatsData().getStringStats().getBitVectors().length() != 0) continue;
            isNDVBitVectorSet = false;
            break;
        }
        ColumnStatisticsData columnStatisticsData = new ColumnStatisticsData();
        if (doAllPartitionContainStats && isNDVBitVectorSet) {
            aggregateData = null;
            NumDistinctValueEstimator ndvEstimator = new NumDistinctValueEstimator(this.numBitVectors);
            for (ColumnStatistics cs : css) {
                ColumnStatisticsObj cso = cs.getStatsObjIterator().next();
                StringColumnStatsData newData = cso.getStatsData().getStringStats();
                ndvEstimator.mergeEstimators(new NumDistinctValueEstimator(newData.getBitVectors(), ndvEstimator.getnumBitVectors()));
                if (aggregateData == null) {
                    aggregateData = newData.deepCopy();
                    continue;
                }
                aggregateData.setMaxColLen(Math.max(aggregateData.getMaxColLen(), newData.getMaxColLen()));
                aggregateData.setAvgColLen(Math.max(aggregateData.getAvgColLen(), newData.getAvgColLen()));
                aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
            }
            aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
            columnStatisticsData.setStringStats(aggregateData);
        } else {
            aggregateData = null;
            for (ColumnStatistics cs : css) {
                ColumnStatisticsObj cso = cs.getStatsObjIterator().next();
                StringColumnStatsData newData = cso.getStatsData().getStringStats();
                if (aggregateData == null) {
                    aggregateData = newData.deepCopy();
                    continue;
                }
                aggregateData.setMaxColLen(Math.max(aggregateData.getMaxColLen(), newData.getMaxColLen()));
                aggregateData.setAvgColLen(Math.max(aggregateData.getAvgColLen(), newData.getAvgColLen()));
                aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
                aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
            }
            columnStatisticsData.setStringStats(aggregateData);
        }
        statsObj.setStatsData(columnStatisticsData);
        return statsObj;
    }
}

