/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.kickstart.run;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.sling.maven.kickstart.run.ControlClient;

public class ProcessDescription {
    private final String id;
    private final File directory;
    private final ControlClient controlClient;
    private volatile Process process;

    public ProcessDescription(String id, File directory, String listenerSpec, Log logger) throws MojoExecutionException {
        this.id = id;
        this.directory = directory;
        this.controlClient = new ControlClient(directory, logger);
    }

    public String getId() {
        return this.id;
    }

    public File getDirectory() {
        return this.directory;
    }

    public ControlClient getControlClient() {
        return this.controlClient;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public void installShutdownHook() {
        final ProcessDescription cfg = this;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (cfg.getProcess() != null) {
                    System.out.println("Terminating kickstart " + cfg.getId());
                    cfg.getProcess().destroy();
                    cfg.setProcess(null);
                }
            }
        });
    }

    public String toString() {
        return "RunningProcessDescription [id=" + this.id + ", directory=" + this.directory + ", process=" + this.process + "]";
    }
}

