/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.write;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.write.NamedTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ItemDefinitionTemplate
extends NamedTemplate
implements ItemDefinition {
    private boolean residual = false;
    private boolean isAutoCreated = false;
    private int onParentVersion = 1;
    private boolean isProtected = false;
    private boolean isMandatory = false;

    protected ItemDefinitionTemplate(NameMapper mapper) {
        super(mapper);
    }

    protected ItemDefinitionTemplate(NameMapper mapper, ItemDefinition definition) throws ConstraintViolationException {
        super(mapper, definition.getName());
        this.setProtected(definition.isProtected());
        this.setMandatory(definition.isMandatory());
        this.setAutoCreated(definition.isAutoCreated());
        this.setOnParentVersion(definition.getOnParentVersion());
    }

    void writeTo(Tree tree) throws RepositoryException {
        if (!this.residual) {
            String oakName = this.getOakName();
            if (oakName == null) {
                throw new RepositoryException("Unnamed item definition");
            }
            tree.setProperty("jcr:name", oakName, Type.NAME);
        } else {
            tree.removeProperty("jcr:name");
        }
        tree.setProperty("jcr:autoCreated", this.isAutoCreated);
        tree.setProperty("jcr:mandatory", this.isMandatory);
        tree.setProperty("jcr:protected", this.isProtected);
        tree.setProperty("jcr:onParentVersion", OnParentVersionAction.nameFromValue((int)this.onParentVersion));
    }

    @Override
    @Nullable
    public String getName() {
        if (this.residual) {
            return "*";
        }
        return super.getName();
    }

    @Override
    public void setName(@NotNull String jcrName) throws ConstraintViolationException {
        this.residual = "*".equals(jcrName);
        if (!this.residual) {
            super.setName(jcrName);
        }
    }

    public NodeType getDeclaringNodeType() {
        return null;
    }

    public boolean isAutoCreated() {
        return this.isAutoCreated;
    }

    public void setAutoCreated(boolean isAutoCreated) {
        this.isAutoCreated = isAutoCreated;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public void setMandatory(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    public int getOnParentVersion() {
        return this.onParentVersion;
    }

    public void setOnParentVersion(int onParentVersion) {
        OnParentVersionAction.nameFromValue((int)onParentVersion);
        this.onParentVersion = onParentVersion;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }
}

