/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.email.impl;

import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

@Component(service={SmtpServerWrapper.class}, immediate=true)
@Designate(ocd=Config.class)
public class SmtpServerWrapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object sync = new Object();
    private Wiser wiser;
    private int effectiveBindPort;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate(Config cfg) throws ReflectiveOperationException {
        int bindPort;
        Object object = this.sync;
        synchronized (object) {
            this.wiser = new Wiser();
            this.wiser.setPort(cfg.bind_port());
            this.wiser.start();
            bindPort = cfg.bind_port() == 0 ? this.reflectiveGetEffectiveBindPort(this.wiser.getServer()) : cfg.bind_port();
        }
        this.effectiveBindPort = bindPort;
        this.logger.info("Started, Wiser listening on port {}", (Object)this.effectiveBindPort);
    }

    private int reflectiveGetEffectiveBindPort(SMTPServer server) throws ReflectiveOperationException {
        Field field = SMTPServer.class.getDeclaredField("serverSocket");
        field.setAccessible(true);
        ServerSocket socket = (ServerSocket)field.get(server);
        return socket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void deactivate() {
        Object object = this.sync;
        synchronized (object) {
            this.wiser.stop();
        }
    }

    public int getEffectiveBindPort() {
        return this.effectiveBindPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMessages() {
        Object object = this.sync;
        synchronized (object) {
            this.wiser.getMessages().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MimeMessage> getMessages() {
        try {
            ArrayList<MimeMessage> messages = new ArrayList<MimeMessage>();
            Object object = this.sync;
            synchronized (object) {
                for (WiserMessage message : this.wiser.getMessages()) {
                    messages.add(message.getMimeMessage());
                }
            }
            return messages;
        }
        catch (MessagingException e) {
            throw new RuntimeException("Failed converting to " + MimeMessage.class.getName(), e);
        }
    }

    @ObjectClassDefinition(name="Apache Sling Testing SMTP Server Wrapper")
    public static @interface Config {
        @AttributeDefinition(name="Bind port", description="The port on which the server will bind. A value of 0 requests binding on any available port ")
        public int bind_port() default 0;
    }
}

