/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.testservices.serversidetests;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.junit.annotations.SlingAnnotationsTestRunner;
import org.apache.sling.junit.annotations.TestReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SlingAnnotationsTestRunner.class)
public class WriteableResourcesTest {
    @TestReference
    private ResourceResolverFactory resourceResolverFactory;
    private ResourceResolver resolver;
    private Resource testRoot;

    @Before
    public void setup() throws Exception {
        this.resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
        Assert.assertNotNull((String)"Expecting non-null ResourceResolver", (Object)this.resolver);
        Resource root = this.resolver.getResource("/");
        Assert.assertNotNull((String)"Expecting non-null root Resource", (Object)root);
        String path = this.getClass().getSimpleName() + "_" + System.currentTimeMillis();
        this.testRoot = this.resolver.create(root, path, null);
    }

    @After
    public void cleanup() throws Exception {
        this.resolver.delete(this.testRoot);
        this.resolver.close();
    }

    private void assertValueMap(ValueMap m, String ... keyValue) {
        Assert.assertNotNull((String)"Expecting non-null ValueMap", (Object)m);
        for (int i = 0; i < keyValue.length; i += 2) {
            String key = keyValue[i];
            String value = keyValue[i + 1];
            Assert.assertEquals((String)("Expecting " + key + "=" + value), (Object)value, (Object)m.get(key, String.class));
        }
    }

    @Test
    public void testSimpleCRUD() throws Exception {
        Props props = new Props("title", "hello", "text", "world");
        String fullPath = this.resolver.create(this.testRoot, "child_" + System.currentTimeMillis(), (Map)props).getPath();
        this.resolver.commit();
        Resource r = this.resolver.getResource(fullPath);
        Assert.assertNotNull((String)("Expecting Resource at " + fullPath), (Object)r);
        ModifiableValueMap m = (ModifiableValueMap)r.adaptTo(ModifiableValueMap.class);
        this.assertValueMap((ValueMap)m, "title", "hello", "text", "world");
        m.put((Object)"more", (Object)"fun");
        m.put((Object)"title", (Object)"changed");
        this.resolver.commit();
        r = this.resolver.getResource(fullPath);
        Assert.assertNotNull((String)("Expecting modified Resource at " + fullPath), (Object)r);
        this.assertValueMap((ValueMap)r.adaptTo(ValueMap.class), "title", "changed", "more", "fun", "text", "world");
        r = this.resolver.getResource(fullPath);
        Assert.assertNotNull((String)("Expecting non-null resource to delete, at " + fullPath), (Object)r);
        this.resolver.delete(r);
        this.resolver.commit();
        Assert.assertNull((String)("Expecting " + fullPath + " to be deleted"), (Object)this.resolver.getResource(fullPath));
    }

    private static class Props
    extends HashMap<String, Object> {
        Props(String ... keyValue) {
            for (int i = 0; i < keyValue.length; i += 2) {
                this.put(keyValue[i], keyValue[i + 1]);
            }
        }
    }
}

