/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sling.query.api.SearchStrategy;
import org.apache.sling.query.api.internal.TreeProvider;
import org.apache.sling.query.impl.function.AddFunction;
import org.apache.sling.query.impl.function.ChildrenFunction;
import org.apache.sling.query.impl.function.ClosestFunction;
import org.apache.sling.query.impl.function.CompositeFunction;
import org.apache.sling.query.impl.function.DescendantFunction;
import org.apache.sling.query.impl.function.FilterFunction;
import org.apache.sling.query.impl.function.FindFunction;
import org.apache.sling.query.impl.function.HasFunction;
import org.apache.sling.query.impl.function.IdentityFunction;
import org.apache.sling.query.impl.function.LastFunction;
import org.apache.sling.query.impl.function.NextFunction;
import org.apache.sling.query.impl.function.NotFunction;
import org.apache.sling.query.impl.function.ParentFunction;
import org.apache.sling.query.impl.function.ParentsFunction;
import org.apache.sling.query.impl.function.PrevFunction;
import org.apache.sling.query.impl.function.SiblingsFunction;
import org.apache.sling.query.impl.function.SliceFunction;
import org.apache.sling.query.impl.function.UniqueFunction;
import org.apache.sling.query.impl.iterator.EmptyElementFilter;
import org.apache.sling.query.impl.iterator.OptionDecoratingIterator;
import org.apache.sling.query.impl.iterator.OptionStrippingIterator;
import org.apache.sling.query.impl.predicate.IterableContainsPredicate;
import org.apache.sling.query.impl.predicate.RejectingPredicate;
import org.apache.sling.query.impl.selector.SelectorFunction;
import org.apache.sling.query.impl.util.LazyList;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class AbstractQuery<T, Q extends AbstractQuery<T, Q>>
implements Iterable<T> {
    protected final List<Function<?, ?>> functions = new ArrayList();
    private final List<T> initialCollection;
    private final SearchStrategy searchStrategy;
    private final TreeProvider<T> provider;

    AbstractQuery(TreeProvider<T> provider, T[] initialCollection, SearchStrategy strategy) {
        this.provider = provider;
        this.initialCollection = new ArrayList<T>(Arrays.asList(initialCollection));
        this.searchStrategy = strategy;
    }

    protected AbstractQuery(AbstractQuery<T, Q> original, SearchStrategy searchStrategy) {
        this.functions.addAll(original.functions);
        this.initialCollection = new ArrayList<T>(original.initialCollection);
        this.searchStrategy = searchStrategy;
        this.provider = original.provider;
    }

    @Override
    public Iterator<T> iterator() {
        CompositeFunction<OptionDecoratingIterator<T>> f = new CompositeFunction<OptionDecoratingIterator<T>>(this.functions);
        EmptyElementFilter iterator = (EmptyElementFilter)f.apply(new OptionDecoratingIterator<T>(this.initialCollection.iterator()));
        iterator = new EmptyElementFilter(iterator);
        return new OptionStrippingIterator(iterator);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Q add(T ... resources) {
        return this.function(new AddFunction<T>(Arrays.asList(resources)));
    }

    public Q add(Iterable<T> iterable) {
        return this.function(new AddFunction<T>(iterable));
    }

    public List<T> asList() {
        return new LazyList<T>(this.iterator());
    }

    public Q children() {
        return this.function(new ChildrenFunction<T>(this.provider));
    }

    public Q children(String filter) {
        return this.function(new ChildrenFunction<T>(this.provider), filter);
    }

    public Q children(Predicate<T> filter) {
        return this.function(new ChildrenFunction<T>(this.provider), filter);
    }

    public Q children(Iterable<T> filter) {
        return this.function(new ChildrenFunction<T>(this.provider), filter);
    }

    public Q closest(String selector) {
        return this.closest(this.parse(selector));
    }

    public Q closest(Iterable<T> iterable) {
        return this.closest(new IterableContainsPredicate<T>(iterable, this.provider));
    }

    public Q closest(Predicate<T> predicate) {
        return this.function(new ClosestFunction<T>(predicate, this.provider));
    }

    public Q eq(int index) {
        return this.slice(index, index);
    }

    public Q filter(String selector) {
        return this.function(new IdentityFunction(), selector);
    }

    public Q filter(Predicate<T> predicate) {
        return this.function(new FilterFunction<T>(predicate));
    }

    public Q filter(Iterable<T> iterable) {
        return this.function(new FilterFunction<T>(new IterableContainsPredicate<T>(iterable, this.provider)));
    }

    public Q find() {
        return this.function(new FindFunction<T>(this.searchStrategy, this.provider, ""));
    }

    public Q find(String selector) {
        return this.function(new FindFunction<T>(this.searchStrategy, this.provider, selector), selector);
    }

    public Q find(Predicate<T> predicate) {
        return this.function(new FindFunction<T>(this.searchStrategy, this.provider, ""), predicate);
    }

    public Q find(Iterable<T> iterable) {
        return this.function(new DescendantFunction<T>(new LazyList<T>(iterable.iterator()), this.provider));
    }

    public Q first() {
        return this.eq(0);
    }

    public Q has(String selector) {
        return this.function(new HasFunction<T>(selector, this.searchStrategy, this.provider));
    }

    public Q has(Predicate<T> predicate) {
        return this.function(new HasFunction<T>(predicate, this.searchStrategy, this.provider));
    }

    public Q has(Iterable<T> iterable) {
        return this.function(new HasFunction<T>(iterable, this.provider));
    }

    public Q last() {
        return this.function(new LastFunction());
    }

    public Q next() {
        return this.function(new NextFunction<T>(this.provider));
    }

    public Q next(String selector) {
        return this.function(new NextFunction<T>(this.provider), selector);
    }

    public Q next(Predicate<T> predicate) {
        return this.function(new NextFunction<T>(this.provider), predicate);
    }

    public Q next(Iterable<T> iterable) {
        return this.function(new NextFunction<T>(this.provider), iterable);
    }

    public Q nextAll() {
        return this.function(new NextFunction(new RejectingPredicate(), this.provider));
    }

    public Q nextAll(String selector) {
        return this.function(new NextFunction(new RejectingPredicate(), this.provider), selector);
    }

    public Q nextAll(Predicate<T> predicate) {
        return this.function(new NextFunction(new RejectingPredicate(), this.provider), predicate);
    }

    public Q nextAll(Iterable<T> iterable) {
        return this.function(new NextFunction(new RejectingPredicate(), this.provider), iterable);
    }

    public Q nextUntil(String until) {
        return this.function(new NextFunction<T>(this.parse(until), this.provider));
    }

    public Q nextUntil(Predicate<T> predicate) {
        return this.function(new NextFunction<T>(predicate, this.provider));
    }

    public Q nextUntil(Iterable<T> iterable) {
        return this.nextUntil(new IterableContainsPredicate<T>(iterable, this.provider));
    }

    public Q not(String selector) {
        return this.function(new NotFunction<T>(this.parse(selector)));
    }

    public Q not(Predicate<T> predicate) {
        return this.function(new FilterFunction<T>(new RejectingPredicate<T>(predicate)));
    }

    public Q not(Iterable<T> iterable) {
        return this.not(new IterableContainsPredicate<T>(iterable, this.provider));
    }

    public Q parent() {
        return this.function(new ParentFunction<T>(this.provider));
    }

    public Q parents() {
        return this.function(new ParentsFunction(new RejectingPredicate(), this.provider));
    }

    public Q parents(String selector) {
        return this.function(new ParentsFunction(new RejectingPredicate(), this.provider), selector);
    }

    public Q parents(Predicate<T> predicate) {
        return this.function(new ParentsFunction(new RejectingPredicate(), this.provider), predicate);
    }

    public Q parents(Iterable<T> iterable) {
        return this.function(new ParentsFunction(new RejectingPredicate(), this.provider), iterable);
    }

    public Q parentsUntil(String until) {
        return this.function(new ParentsFunction<T>(this.parse(until), this.provider));
    }

    public Q parentsUntil(Predicate<T> predicate) {
        return this.function(new ParentsFunction<T>(predicate, this.provider));
    }

    public Q parentsUntil(Iterable<T> iterable) {
        return this.parentsUntil(new IterableContainsPredicate<T>(iterable, this.provider));
    }

    public Q prev() {
        return this.function(new PrevFunction<T>(this.provider));
    }

    public Q prev(String selector) {
        return this.function(new PrevFunction<T>(null, this.provider), selector);
    }

    public Q prev(Predicate<T> predicate) {
        return this.function(new PrevFunction<T>(null, this.provider), predicate);
    }

    public Q prev(Iterable<T> iterable) {
        return this.function(new PrevFunction<T>(null, this.provider), iterable);
    }

    public Q prevAll() {
        return this.function(new PrevFunction(new RejectingPredicate(), this.provider));
    }

    public Q prevAll(String selector) {
        return this.function(new PrevFunction(new RejectingPredicate(), this.provider), selector);
    }

    public Q prevAll(Predicate<T> predicate) {
        return this.function(new PrevFunction(new RejectingPredicate(), this.provider), predicate);
    }

    public Q prevAll(Iterable<T> iterable) {
        return this.function(new PrevFunction(new RejectingPredicate(), this.provider), iterable);
    }

    public Q prevUntil(String until) {
        return this.function(new PrevFunction<T>(this.parse(until), this.provider));
    }

    public Q prevUntil(Predicate<T> predicate) {
        return this.function(new PrevFunction<T>(predicate, this.provider));
    }

    public Q prevUntil(Iterable<T> iterable) {
        return this.prevUntil(new IterableContainsPredicate<T>(iterable, this.provider));
    }

    public Q searchStrategy(SearchStrategy strategy) {
        return this.clone(this, strategy);
    }

    public Q siblings() {
        return this.siblings("");
    }

    public Q siblings(String selector) {
        return this.function(new SiblingsFunction<T>(this.provider), selector);
    }

    public Q siblings(Predicate<T> predicate) {
        return this.function(new SiblingsFunction<T>(this.provider), predicate);
    }

    public Q siblings(Iterable<T> iterable) {
        return this.function(new SiblingsFunction<T>(this.provider), iterable);
    }

    public Q slice(int from) {
        if (from < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.function(new SliceFunction(from));
    }

    public Q slice(int from, int to) {
        if (from < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (from > to) {
            throw new IllegalArgumentException();
        }
        return this.function(new SliceFunction(from, to));
    }

    public Q unique() {
        return this.function(new UniqueFunction());
    }

    private Q function(Function<?, ?> function, Iterable<T> iterable) {
        Q newQuery = this.clone(this, this.searchStrategy);
        ((AbstractQuery)newQuery).functions.add(function);
        ((AbstractQuery)newQuery).functions.add(new FilterFunction<T>(new IterableContainsPredicate<T>(iterable, this.provider)));
        return newQuery;
    }

    private Q function(Function<?, ?> function, Predicate<T> predicate) {
        Q newQuery = this.clone(this, this.searchStrategy);
        ((AbstractQuery)newQuery).functions.add(function);
        ((AbstractQuery)newQuery).functions.add(new FilterFunction<T>(predicate));
        return newQuery;
    }

    private Q function(Function<?, ?> function, String selector) {
        Q newQuery = this.clone(this, this.searchStrategy);
        ((AbstractQuery)newQuery).functions.add(function);
        ((AbstractQuery)newQuery).functions.add(new SelectorFunction<T>(selector, this.provider, this.searchStrategy));
        return newQuery;
    }

    private Q function(Function<?, ?> function) {
        Q newQuery = this.clone(this, this.searchStrategy);
        ((AbstractQuery)newQuery).functions.add(function);
        return newQuery;
    }

    private SelectorFunction<T> parse(String selector) {
        return new SelectorFunction<T>(selector, this.provider, this.searchStrategy);
    }

    protected abstract Q clone(AbstractQuery<T, Q> var1, SearchStrategy var2);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("$(");
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            builder.append('[');
            builder.append(iterator.next());
            builder.append(']');
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(")");
        return builder.toString();
    }
}

