/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.introspection.JexlPropertySet;
import org.apache.commons.jexl3.parser.ASTArrayAccess;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTIdentifierAccess;
import org.apache.commons.jexl3.parser.ASTMapEntry;
import org.apache.commons.jexl3.parser.ASTReference;
import org.apache.commons.jexl3.parser.Parser;
import org.apache.commons.jexl3.parser.SimpleNode;
import org.apache.commons.jexl3.parser.Token;

public abstract class JexlNode
extends SimpleNode {
    private int lc = -1;

    public JexlNode(int id) {
        super(id);
    }

    public JexlNode(Parser p, int id) {
        super(p, id);
    }

    public void jjtSetFirstToken(Token t) {
        this.lc = t.beginLine << 12 | 0xFFF & t.beginColumn;
    }

    public void jjtSetLastToken(Token t) {
    }

    public JexlInfo jexlInfo() {
        for (JexlNode node = this; node != null; node = node.jjtGetParent()) {
            if (!(node.jjtGetValue() instanceof JexlInfo)) continue;
            JexlInfo info = (JexlInfo)node.jjtGetValue();
            if (this.lc >= 0) {
                int c = this.lc & 0xFFF;
                int l = this.lc >> 12;
                return info.at(l, c);
            }
            return info;
        }
        return null;
    }

    public void clearCache() {
        Object value = this.jjtGetValue();
        if (value instanceof JexlPropertyGet || value instanceof JexlPropertySet || value instanceof JexlMethod) {
            this.jjtSetValue(null);
        }
        for (int n = 0; n < this.jjtGetNumChildren(); ++n) {
            this.jjtGetChild(n).clearCache();
        }
    }

    public boolean isConstant() {
        return this.isConstant(this instanceof Constant);
    }

    protected boolean isConstant(boolean literal) {
        if (literal) {
            for (int n = 0; n < this.jjtGetNumChildren(); ++n) {
                boolean is;
                JexlNode child = this.jjtGetChild(n);
                if (!(child instanceof ASTReference ? !(is = child.isConstant(true)) : (child instanceof ASTMapEntry ? !(is = child.isConstant(true)) : !child.isConstant()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isLeftValue() {
        if (this instanceof ASTIdentifier || this instanceof ASTIdentifierAccess) {
            return true;
        }
        int nc = this.jjtGetNumChildren() - 1;
        if (nc >= 0) {
            JexlNode last = this.jjtGetChild(this.jjtGetNumChildren() - 1);
            return last.isLeftValue();
        }
        return this.jjtGetParent() instanceof ASTReference || this.jjtGetParent() instanceof ASTArrayAccess;
    }

    public static interface Constant<T> {
        public T getLiteral();
    }
}

