/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.internal.TemplateEngine;
import org.apache.commons.jexl3.internal.TemplateInterpreter;
import org.apache.commons.jexl3.parser.ASTJexlScript;

public final class TemplateScript
implements JxltEngine.Template {
    private final String prefix;
    private final TemplateEngine.Block[] source;
    private final ASTJexlScript script;
    private final TemplateEngine.TemplateExpression[] exprs;
    private final TemplateEngine jxlt;

    public TemplateScript(TemplateEngine engine, JexlInfo info, String directive, Reader reader, String ... parms) {
        TemplateEngine.Block block;
        int b;
        if (directive == null) {
            throw new NullPointerException("null prefix");
        }
        if (Character.toString(engine.getImmediateChar()).equals(directive) || (Character.toString(engine.getImmediateChar()) + "{").equals(directive) || Character.toString(engine.getDeferredChar()).equals(directive) || (Character.toString(engine.getDeferredChar()) + "{").equals(directive)) {
            throw new IllegalArgumentException(directive + ": is not a valid directive pattern");
        }
        if (reader == null) {
            throw new NullPointerException("null input");
        }
        this.jxlt = engine;
        Scope scope = parms == null ? null : new Scope(null, parms);
        this.prefix = directive;
        List<TemplateEngine.Block> blocks = this.jxlt.readTemplate(this.prefix, reader);
        ArrayList<TemplateEngine.TemplateExpression> uexprs = new ArrayList<TemplateEngine.TemplateExpression>();
        StringBuilder strb = new StringBuilder();
        int nuexpr = 0;
        int codeStart = -1;
        for (b = 0; b < blocks.size(); ++b) {
            block = blocks.get(b);
            if (block.getType() == TemplateEngine.BlockType.VERBATIM) {
                strb.append("jexl:print(");
                strb.append(nuexpr++);
                strb.append(");\n");
                continue;
            }
            if (codeStart < 0) {
                codeStart = b;
            }
            strb.append(block.getBody());
        }
        if (info == null) {
            info = this.jxlt.getEngine().createInfo();
        }
        this.script = this.jxlt.getEngine().parse(info.at(0, 0), strb.toString(), scope, false, false).script();
        scope = this.script.getScope();
        for (b = 0; b < blocks.size(); ++b) {
            block = blocks.get(b);
            if (block.getType() != TemplateEngine.BlockType.VERBATIM) continue;
            uexprs.add(this.jxlt.parseExpression(info.at(block.getLine(), 0), block.getBody(), b > codeStart ? scope : null));
        }
        this.source = blocks.toArray(new TemplateEngine.Block[blocks.size()]);
        this.exprs = uexprs.toArray(new TemplateEngine.TemplateExpression[uexprs.size()]);
    }

    TemplateScript(TemplateEngine engine, String thePrefix, TemplateEngine.Block[] theSource, ASTJexlScript theScript, TemplateEngine.TemplateExpression[] theExprs) {
        this.jxlt = engine;
        this.prefix = thePrefix;
        this.source = theSource;
        this.script = theScript;
        this.exprs = theExprs;
    }

    ASTJexlScript getScript() {
        return this.script;
    }

    TemplateEngine.TemplateExpression[] getExpressions() {
        return this.exprs;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        for (TemplateEngine.Block block : this.source) {
            block.toString(strb, this.prefix);
        }
        return strb.toString();
    }

    @Override
    public String asString() {
        StringBuilder strb = new StringBuilder();
        int e = 0;
        for (int b = 0; b < this.source.length; ++b) {
            TemplateEngine.Block block = this.source[b];
            if (block.getType() == TemplateEngine.BlockType.DIRECTIVE) {
                strb.append(this.prefix);
                continue;
            }
            this.exprs[e++].asString(strb);
        }
        return strb.toString();
    }

    @Override
    public TemplateScript prepare(JexlContext context) {
        Scope.Frame frame = this.script.createFrame(null);
        TemplateEngine.TemplateExpression[] immediates = new TemplateEngine.TemplateExpression[this.exprs.length];
        for (int e = 0; e < this.exprs.length; ++e) {
            immediates[e] = this.exprs[e].prepare(frame, context);
        }
        return new TemplateScript(this.jxlt, this.prefix, this.source, this.script, immediates);
    }

    @Override
    public void evaluate(JexlContext context, Writer writer) {
        this.evaluate(context, writer, null);
    }

    @Override
    public void evaluate(JexlContext context, Writer writer, Object ... args) {
        Scope.Frame frame = this.script.createFrame(args);
        TemplateInterpreter interpreter = new TemplateInterpreter(this.jxlt.getEngine(), context, frame, this.exprs, writer);
        interpreter.interpret(this.script);
    }

    @Override
    public Set<List<String>> getVariables() {
        Engine.VarCollector collector = new Engine.VarCollector();
        for (TemplateEngine.TemplateExpression expr : this.exprs) {
            expr.getVariables(collector);
        }
        return collector.collected();
    }

    @Override
    public String[] getParameters() {
        return this.script.getParameters();
    }
}

