/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.transport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.ide.transport.RepositoryPath;

public class ResourceProxy {
    private final RepositoryPath path;
    private final Map<String, Object> properties;
    private final List<ResourceProxy> children = new ArrayList<ResourceProxy>();
    private final Map<Class<?>, Object> adapted = new HashMap(1);

    public ResourceProxy(RepositoryPath path) {
        this(path, new HashMap<String, Object>());
    }

    public ResourceProxy(RepositoryPath path, Map<String, Object> properties) {
        this.path = path;
        this.properties = properties;
    }

    public void addChild(ResourceProxy child) {
        if (!this.path.isParent(child.path)) {
            throw new IllegalArgumentException("Resource at path " + String.valueOf(child.getPath()) + " is not a direct child of " + String.valueOf(this.path));
        }
        this.children.add(child);
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public RepositoryPath getPath() {
        return this.path;
    }

    public List<ResourceProxy> getChildren() {
        return this.children;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public <T> void addAdapted(Class<T> klazz, T adaptedInstance) {
        this.adapted.put(klazz, adaptedInstance);
    }

    public <T> T adaptTo(Class<T> klazz) {
        Object res = this.adapted.get(klazz);
        return (T)res;
    }

    public List<ResourceProxy> getCoveredChildren() {
        ArrayList<ResourceProxy> coveredChildren = new ArrayList<ResourceProxy>();
        for (ResourceProxy child : this.getChildren()) {
            if (child.getProperties().isEmpty()) continue;
            coveredChildren.add(child);
        }
        return coveredChildren;
    }

    public boolean covers(RepositoryPath path) {
        for (ResourceProxy child : this.getCoveredChildren()) {
            if (child.getPath().equals(path)) {
                return true;
            }
            if (!child.getPath().isDescendent(path)) continue;
            return child.covers(path);
        }
        return false;
    }

    public ResourceProxy getChild(RepositoryPath path) {
        for (ResourceProxy child : this.getChildren()) {
            if (child.getPath().equals(path)) {
                return child;
            }
            if (!child.getPath().isDescendent(path)) continue;
            return child.getChild(path);
        }
        return null;
    }

    public String toString() {
        return this.toString0(1);
    }

    private String toString0(int padding) {
        StringBuilder out = new StringBuilder();
        out.append(this.getClass().getSimpleName()).append(": path=").append(this.path).append(", properties=").append(this.properties);
        for (ResourceProxy child : this.children) {
            out.append("\n");
            for (int i = 0; i < padding * 2; ++i) {
                out.append(' ');
            }
            out.append(child.toString0(padding + 1));
        }
        return out.toString();
    }
}

