/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core;

import com.googlecode.pngtastic.core.PngChunk;
import com.googlecode.pngtastic.core.PngException;
import com.googlecode.pngtastic.core.PngImage;
import com.googlecode.pngtastic.core.PngImageType;
import com.googlecode.pngtastic.core.PngPixel;
import com.googlecode.pngtastic.core.PngProcessor;
import com.googlecode.pngtastic.core.processing.PngByteArrayOutputStream;
import com.googlecode.pngtastic.core.processing.PngInterlaceHandler;
import com.googlecode.pngtastic.core.processing.PngtasticInterlaceHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PngColorCounter
extends PngProcessor {
    private final PngInterlaceHandler pngInterlaceHandler;
    private final double distThreshold;
    private final double freqThreshold;
    private final int minAlpha;
    private final long timeout;
    private ColorCounterResult colorCounterResult;

    public ColorCounterResult getResult() {
        return this.colorCounterResult;
    }

    public PngColorCounter() {
        this("NONE", 0.01, 0.01, 30, 0L);
    }

    public PngColorCounter(double distThreshold, double freqThreshold, int minAlpha) {
        this("NONE", distThreshold, freqThreshold, minAlpha, 0L);
    }

    public PngColorCounter(double distThreshold, double freqThreshold, int minAlpha, long timeout) {
        this("NONE", distThreshold, freqThreshold, minAlpha, timeout);
    }

    public PngColorCounter(String logLevel, double distThreshold, double freqThreshold, int minAlpha, long timeout) {
        super(logLevel);
        this.distThreshold = distThreshold;
        this.freqThreshold = freqThreshold;
        this.minAlpha = minAlpha;
        this.timeout = timeout;
        this.pngInterlaceHandler = new PngtasticInterlaceHandler(this.log, this.pngFilterHandler);
    }

    public void count(PngImage image) throws IOException {
        this.log.debug("=== COUNTING ===", new Object[0]);
        if (image.getInterlace() == 1 && image.getSampleBitCount() < 8) {
            this.log.debug("not supported", new Object[0]);
            return;
        }
        long start = System.currentTimeMillis();
        Iterator<PngChunk> itChunks = image.getChunks().iterator();
        PngChunk chunk = this.processHeadChunks(null, false, itChunks);
        PngByteArrayOutputStream inflatedImageData = this.getInflatedImageData(chunk, itChunks);
        long width = image.getWidth();
        long height = image.getHeight();
        int scanlineLength = (int)Math.ceil((float)(width * (long)image.getSampleBitCount()) / 8.0f) + 1;
        List<byte[]> originalScanlines = image.getInterlace() == 1 ? this.pngInterlaceHandler.deInterlace((int)width, (int)height, image.getSampleBitCount(), inflatedImageData) : this.getScanlines(inflatedImageData, image.getSampleBitCount(), scanlineLength, height);
        List<PngPixel> colors = this.getColors(image, originalScanlines, start);
        List<PngPixel> results = this.getMergedColors(image, colors, start);
        long elapsed = System.currentTimeMillis() - start;
        this.colorCounterResult = new ColorCounterResult(image.getFileName(), width, height, colors.size(), results, elapsed);
    }

    private List<PngPixel> getColors(PngImage original, List<byte[]> rows, long start) throws IOException {
        LinkedHashMap<PngPixel, Integer> colors = new LinkedHashMap<PngPixel, Integer>();
        PngImageType imageType = PngImageType.forColorType(original.getColorType());
        int sampleSize = original.getSampleBitCount();
        int y = 0;
        for (byte[] row : rows) {
            if (this.timeout > 0L && System.currentTimeMillis() - start > this.timeout) {
                throw new PngException("Reached " + this.timeout + "ms timeout");
            }
            int sampleCount = (row.length - 1) * 8 / sampleSize;
            ByteArrayInputStream ins = new ByteArrayInputStream(row);
            DataInputStream dis = new DataInputStream(ins);
            dis.readUnsignedByte();
            block7: for (int x = 0; x < sampleCount; ++x) {
                switch (imageType) {
                    case INDEXED_COLOR: {
                        int offset = dis.readUnsignedByte() * 3;
                        short r = original.getPalette().getUnsignedByte(offset);
                        int g = original.getPalette().getUnsignedByte(offset + 1);
                        int b = original.getPalette().getUnsignedByte(offset + 2);
                        PngPixel pixel = new PngPixel(x, y, (int)r, g, b, true);
                        Integer count = (Integer)colors.get(pixel);
                        colors.put(pixel, count == null ? 1 : count + 1);
                        continue block7;
                    }
                    case GREYSCALE: 
                    case GREYSCALE_ALPHA: {
                        throw new PngException("Greyscale images not supported");
                    }
                    case TRUECOLOR: {
                        PngPixel pixel;
                        int r;
                        int b;
                        int g;
                        if (original.getBitDepth() == 8) {
                            r = dis.readUnsignedByte();
                            g = dis.readUnsignedByte();
                            b = dis.readUnsignedByte();
                            pixel = new PngPixel(x, y, r, g, b, true);
                        } else {
                            r = dis.readUnsignedShort();
                            g = dis.readUnsignedShort();
                            b = dis.readUnsignedShort();
                            pixel = new PngPixel(x, y, r, g, b, false);
                        }
                        Integer count = (Integer)colors.get(pixel);
                        colors.put(pixel, count == null ? 1 : count + 1);
                        continue block7;
                    }
                    case TRUECOLOR_ALPHA: {
                        PngPixel pixel;
                        int a;
                        int r;
                        int b;
                        int g;
                        if (original.getBitDepth() == 8) {
                            r = dis.readUnsignedByte();
                            g = dis.readUnsignedByte();
                            b = dis.readUnsignedByte();
                            a = dis.readUnsignedByte();
                            pixel = new PngPixel(x, y, r, g, b, a);
                        } else {
                            r = dis.readUnsignedShort();
                            g = dis.readUnsignedShort();
                            b = dis.readUnsignedShort();
                            a = dis.readUnsignedShort();
                            pixel = new PngPixel(x, y, r, g, b, a);
                        }
                        if (pixel.getAlpha() <= this.minAlpha) continue block7;
                        Integer count = (Integer)colors.get(pixel);
                        colors.put(pixel, count == null ? 1 : count + 1);
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            ++y;
        }
        this.log.debug("Full color count=%d", colors.size());
        if (this.freqThreshold > 0.0) {
            int minFreq = (int)((double)(original.getWidth() * original.getHeight()) * this.freqThreshold);
            Iterator it = colors.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if ((Integer)entry.getValue() >= minFreq) continue;
                it.remove();
            }
        }
        this.log.debug("Filtered color count=%d", colors.size());
        ArrayList<PngPixel> results = new ArrayList<PngPixel>(colors.keySet());
        for (PngPixel pixel : results) {
            pixel.setFreq((Integer)colors.get(pixel));
        }
        return results;
    }

    private List<PngPixel> getMergedColors(PngImage image, List<PngPixel> colors, long start) {
        short bits = image.getBitDepth();
        ArrayList<PngPixel> copy = new ArrayList<PngPixel>(colors);
        for (PngPixel pa : colors) {
            if (this.timeout > 0L && System.currentTimeMillis() - start > this.timeout) {
                throw new PngException("Reached " + this.timeout + "ms timeout");
            }
            if (pa.isDuplicate()) continue;
            Iterator it = copy.iterator();
            while (it.hasNext()) {
                PngPixel pb = (PngPixel)it.next();
                if (pb.isDuplicate()) {
                    it.remove();
                    continue;
                }
                if (pa == pb || !(pa.rgbaDistance(pb, bits) < this.distThreshold)) continue;
                if (pa.getFreq() > pb.getFreq()) {
                    pb.setDuplicate(true);
                    it.remove();
                    continue;
                }
                pa.setDuplicate(true);
            }
        }
        ArrayList<PngPixel> results = new ArrayList<PngPixel>();
        for (PngPixel p : colors) {
            if (p.isDuplicate()) continue;
            results.add(p);
        }
        return results;
    }

    public static class ColorCounterResult {
        private final String fileName;
        private final long width;
        private final long height;
        private final int totalColors;
        private final List<PngPixel> dominantColors;
        private final long elapsed;

        public ColorCounterResult(String fileName, long width, long height, int totalColors, List<PngPixel> dominantColors, long elapsed) {
            this.fileName = fileName;
            this.width = width;
            this.height = height;
            this.totalColors = totalColors;
            this.dominantColors = dominantColors;
            this.elapsed = elapsed;
        }

        public String toString() {
            return "Filename: " + this.fileName + " " + this.width + "x" + this.height + "\nCandidates: " + this.totalColors + "\nDominant Colors: " + this.dominantColors.size() + "\nColors: " + this.dominantColors.toString() + "\nElapsed: " + this.elapsed + "ms\n";
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getWidth() {
            return this.width;
        }

        public long getHeight() {
            return this.height;
        }

        public int getTotalColors() {
            return this.totalColors;
        }

        public List<PngPixel> getDominantColors() {
            return this.dominantColors;
        }

        public long getElapsed() {
            return this.elapsed;
        }
    }
}

