/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.artifacts;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.io.artifacts.ArtifactHandler;
import org.apache.sling.feature.io.artifacts.ArtifactManagerConfig;
import org.apache.sling.feature.io.artifacts.spi.ArtifactProvider;
import org.apache.sling.feature.io.artifacts.spi.ArtifactProviderContext;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactManager
implements AutoCloseable,
org.apache.sling.feature.builder.ArtifactProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ArtifactProvider> providers;
    private final ArtifactManagerConfig config;

    public static ArtifactManager getArtifactManager(ArtifactManagerConfig config) throws IOException {
        ServiceLoader<ArtifactProvider> loader = ServiceLoader.load(ArtifactProvider.class);
        HashMap<String, ArtifactProvider> providers = new HashMap<String, ArtifactProvider>();
        for (ArtifactProvider provider : loader) {
            providers.put(provider.getProtocol(), provider);
        }
        String[] repositoryURLs = new String[config.getRepositoryUrls().length];
        int index = 0;
        String[] stringArray = config.getRepositoryUrls();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String urlString;
            repositoryURLs[index] = urlString = stringArray[i];
            ++index;
        }
        if (!providers.containsKey("*")) {
            providers.put("*", new DefaultArtifactHandler());
        }
        return new ArtifactManager(config, providers);
    }

    ArtifactManager(ArtifactManagerConfig config, Map<String, ArtifactProvider> providers) throws IOException {
        this.config = config;
        this.providers = providers;
        try {
            for (ArtifactProvider provider : this.providers.values()) {
                provider.init(config);
            }
        }
        catch (IOException io) {
            this.shutdown();
            throw io;
        }
    }

    public void shutdown() {
        for (ArtifactProvider provider : this.providers.values()) {
            provider.shutdown();
        }
        this.providers.clear();
    }

    @Override
    public void close() {
        this.shutdown();
    }

    @Override
    public URL provide(ArtifactId id) {
        try {
            ArtifactHandler handler = this.getArtifactHandler(id.toMvnUrl());
            return handler.getLocalURL();
        }
        catch (IOException e) {
            return null;
        }
    }

    public FeatureProvider toFeatureProvider() {
        return id -> {
            Feature feature;
            ArtifactHandler handler = this.getArtifactHandler(id.toMvnUrl());
            InputStreamReader r = new InputStreamReader(handler.getLocalURL().openStream(), "UTF-8");
            try {
                Feature f;
                feature = f = FeatureJSONReader.read(r, handler.getUrl());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)r).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            ((Reader)r).close();
            return feature;
        };
    }

    private final URL getArtifactFromProviders(String url, String relativeCachePath) throws IOException {
        int pos = url.indexOf(":");
        String scheme = url.substring(0, pos);
        ArtifactProvider provider = this.providers.get(scheme);
        if (provider == null) {
            provider = this.providers.get("*");
        }
        if (provider == null) {
            throw new IOException("No URL provider found for " + url);
        }
        return provider.getArtifact(url, relativeCachePath);
    }

    public ArtifactHandler getArtifactHandler(String url) throws IOException {
        Path file;
        String path;
        this.logger.debug("Trying to get artifact for {}", (Object)url);
        ArtifactId artifactId = null;
        if (url.startsWith("mvn:")) {
            try {
                artifactId = ArtifactId.fromMvnUrl(url);
                path = artifactId.toMvnPath();
            }
            catch (IllegalArgumentException iae) {
                throw new IOException(iae.getMessage(), iae);
            }
        } else if (url.startsWith(":")) {
            path = url.substring(1);
        } else {
            if (url.indexOf(":/") > 0) {
                int pos = url.indexOf(":/") + 2;
                while (url.charAt(pos) == '/') {
                    ++pos;
                }
                URL file2 = this.getArtifactFromProviders(url, url.substring(pos));
                if (file2 == null) {
                    throw new IOException("Artifact " + url + " not found.");
                }
                return new ArtifactHandler(url, file2);
            }
            Path f = Paths.get(url, new String[0]);
            if (!Files.exists(f, new LinkOption[0])) {
                throw new IOException("Artifact " + url + " not found.");
            }
            return new ArtifactHandler(f);
        }
        this.logger.debug("Querying repositories for {}", (Object)path);
        for (String repoUrl : this.config.getRepositoryUrls()) {
            StringBuilder builder = new StringBuilder();
            builder.append(repoUrl);
            builder.append('/');
            builder.append(path);
            String artifactUrl = builder.toString();
            int pos = artifactUrl.indexOf(":");
            String scheme = artifactUrl.substring(0, pos);
            ArtifactProvider handler = this.providers.get(scheme);
            if (handler == null) {
                handler = this.providers.get("*");
            }
            if (handler == null) {
                throw new IOException("No URL handler found for " + artifactUrl);
            }
            this.logger.debug("Checking {} to get artifact from {}", (Object)handler, (Object)artifactUrl);
            URL file3 = handler.getArtifact(artifactUrl, path);
            if (file3 != null) {
                this.logger.debug("Found artifact {}", (Object)artifactUrl);
                return new ArtifactHandler(artifactUrl, file3);
            }
            int lastSlash = artifactUrl.lastIndexOf(47);
            int startSnapshot = artifactUrl.indexOf("-SNAPSHOT", lastSlash + 1);
            if (startSnapshot <= -1) continue;
            String metadataUrl = artifactUrl.substring(0, lastSlash) + "/maven-metadata.xml";
            try {
                ArtifactHandler metadataHandler = this.getArtifactHandler(metadataUrl);
                String contents = this.getFileContents(metadataHandler);
                String latestVersion = ArtifactManager.getLatestSnapshot(contents);
                if (latestVersion == null) continue;
                String name = artifactUrl.substring(lastSlash);
                String fullURL = artifactUrl.substring(0, lastSlash) + name.replace("SNAPSHOT", latestVersion);
                int pos2 = fullURL.indexOf(":/") + 2;
                while (fullURL.charAt(pos2) == '/') {
                    ++pos2;
                }
                URL file2 = this.getArtifactFromProviders(fullURL, path);
                if (file2 == null) {
                    throw new IOException("Artifact " + fullURL + " not found.");
                }
                return new ArtifactHandler(artifactUrl, file2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (artifactId != null && this.config.isUseMvn() && (file = this.getArtifactFromMvn(artifactId)) != null) {
            return new ArtifactHandler(file);
        }
        throw new IOException("Artifact " + url + " not found in any repository.");
    }

    protected String getFileContents(ArtifactHandler handler) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(handler.getLocalURL().openStream(), "UTF-8"));){
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append('\n');
                line = reader.readLine();
            }
        }
        return sb.toString();
    }

    public static String getValue(String xml, String[] xpath) {
        int endPos;
        String value = null;
        int pos = 0;
        for (String name : xpath) {
            String elementWithAttributes;
            String element = '<' + name + '>';
            pos = xml.indexOf(element, pos);
            if (pos == -1 && (pos = xml.indexOf(elementWithAttributes = '<' + name + ' ', pos)) == -1) break;
            pos = xml.indexOf(62, pos) + 1;
        }
        if (pos != -1 && (endPos = xml.indexOf("</", pos)) != -1) {
            value = xml.substring(pos, endPos).trim();
        }
        return value;
    }

    public static String getLatestSnapshot(String mavenMetadata) {
        String timestamp = ArtifactManager.getValue(mavenMetadata, new String[]{"metadata", "versioning", "snapshot", "timestamp"});
        String buildNumber = ArtifactManager.getValue(mavenMetadata, new String[]{"metadata", "versioning", "snapshot", "buildNumber"});
        if (timestamp != null && buildNumber != null) {
            return timestamp + '-' + buildNumber;
        }
        return null;
    }

    private Path getArtifactFromMvn(ArtifactId artifactId) {
        Path filePath = Paths.get(this.config.getMvnHome(), artifactId.toMvnPath().replace("/", FileSystems.getDefault().getSeparator()));
        this.logger.debug("Trying to fetch artifact {} from local mvn repository {}", (Object)artifactId.toMvnId(), (Object)filePath);
        if (!Files.exists(filePath, new LinkOption[0]) || !Files.isRegularFile(filePath, new LinkOption[0]) || Files.isReadable(filePath)) {
            this.logger.debug("Trying to download {}", (Object)artifactId.toMvnId());
            try {
                this.downloadArtifact(artifactId);
            }
            catch (IOException ioe) {
                this.logger.debug("Error downloading file.", (Throwable)ioe);
            }
            if (!(Files.exists(filePath, new LinkOption[0]) && Files.isRegularFile(filePath, new LinkOption[0]) && Files.isReadable(filePath))) {
                this.logger.info("Artifact not found {}", (Object)artifactId.toMvnId());
                return null;
            }
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadArtifact(ArtifactId artifactId) throws IOException {
        Path dir = Files.createTempDirectory(null, new FileAttribute[0]);
        try {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">");
            lines.add("    <modelVersion>4.0.0</modelVersion>");
            lines.add("    <groupId>org.apache.sling</groupId>");
            lines.add("    <artifactId>temp-artifact</artifactId>");
            lines.add("    <version>1-SNAPSHOT</version>");
            lines.add("    <dependencies>");
            lines.add("        <dependency>");
            lines.add("            <groupId>".concat(artifactId.getGroupId()).concat("</groupId>"));
            lines.add("            <artifactId>".concat(artifactId.getArtifactId()).concat("</artifactId>"));
            lines.add("            <version>".concat(artifactId.getVersion()).concat("</version>"));
            if (artifactId.getClassifier() != null) {
                lines.add("            <classifier>".concat(artifactId.getClassifier()).concat("</classifier>"));
            }
            if (!"bundle".equals(artifactId.getType()) && !"jar".equals(artifactId.getType())) {
                lines.add("            <type>".concat(artifactId.getType()).concat("</type>"));
            }
            lines.add("            <scope>provided</scope>");
            lines.add("        </dependency>");
            lines.add("    </dependencies>");
            lines.add("</project>");
            this.logger.debug("Writing pom to {}", (Object)dir);
            Files.write(dir.resolve("pom.xml"), lines, Charset.forName("UTF-8"), new OpenOption[0]);
            Path output = dir.resolve("output.txt");
            Path error = dir.resolve("error.txt");
            this.logger.debug("Invoking mvn...");
            ProcessBuilder pb = new ProcessBuilder("mvn", "verify");
            pb.directory(dir.toFile());
            pb.redirectOutput(ProcessBuilder.Redirect.to(output.toFile()));
            pb.redirectError(ProcessBuilder.Redirect.to(error.toFile()));
            Process p = pb.start();
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            ArtifactManager.deleteDirectoryRecursively(dir);
        }
    }

    private static void deleteDirectoryRecursively(Path directory) throws IOException {
        try (Stream<Path> filesStream = Files.walk(directory, new FileVisitOption[0]);){
            List pathsToDelete = filesStream.sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            for (Path path : pathsToDelete) {
                Files.deleteIfExists(path);
            }
        }
    }

    private static final class DefaultArtifactHandler
    implements ArtifactProvider {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private Path cacheDir;
        private boolean isNewlyCreatedCacheDir;
        private ArtifactProviderContext config;

        private DefaultArtifactHandler() {
        }

        @Override
        public String getProtocol() {
            return "*";
        }

        @Override
        public void init(ArtifactProviderContext config) throws IOException {
            File cd = config.getCacheDirectory();
            if (cd != null) {
                this.cacheDir = cd.toPath();
            } else {
                this.cacheDir = Files.createTempDirectory("slingfeature", new FileAttribute[0]);
                this.isNewlyCreatedCacheDir = true;
            }
            this.config = config;
        }

        @Override
        public void shutdown() {
            this.config = null;
            if (this.isNewlyCreatedCacheDir) {
                try {
                    ArtifactManager.deleteDirectoryRecursively(this.cacheDir);
                }
                catch (IOException e) {
                    this.logger.warn("Could not remove temp directory at " + this.cacheDir, (Throwable)e);
                }
            }
            this.cacheDir = null;
        }

        @Override
        public URL getArtifact(String url, String relativeCachePath) {
            this.logger.debug("Checking url to be local file {}", (Object)url);
            try {
                URI uri = new URI(url);
                if (FileSystems.getDefault().provider().getScheme().equals(uri.getScheme())) {
                    Path f = Paths.get(uri);
                    if (Files.exists(f, new LinkOption[0])) {
                        this.config.incLocalArtifacts();
                        return f.toUri().toURL();
                    }
                    return null;
                }
            }
            catch (URISyntaxException uri) {
            }
            catch (MalformedURLException uri) {
                // empty catch block
            }
            this.logger.debug("Checking remote url {}", (Object)url);
            try {
                Path cacheFile;
                if (url.indexOf(":") == -1) {
                    return null;
                }
                String adjustedRelativePath = relativeCachePath;
                int pos = adjustedRelativePath.indexOf(":/");
                if (pos >= 0) {
                    adjustedRelativePath = adjustedRelativePath.substring(pos + 2);
                }
                if (!Files.exists(cacheFile = this.cacheDir.resolve(adjustedRelativePath.replace("/", FileSystems.getDefault().getSeparator())), new LinkOption[0])) {
                    Files.createDirectories(cacheFile.getParent(), new FileAttribute[0]);
                    URL u = new URL(url);
                    URLConnection con = u.openConnection();
                    String userInfo = u.getUserInfo();
                    if (userInfo != null) {
                        con.addRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(u.toURI().getUserInfo().getBytes("UTF-8")));
                    }
                    con.connect();
                    try (InputStream input = con.getInputStream();){
                        Files.copy(input, cacheFile, new CopyOption[0]);
                    }
                    catch (IOException e) {
                        this.logger.debug("Failed to copy file", (Throwable)e);
                        throw e;
                    }
                    this.config.incDownloadedArtifacts();
                } else {
                    this.config.incCachedArtifacts();
                }
                return cacheFile.toUri().toURL();
            }
            catch (Exception e) {
                this.logger.info("Artifact not found in one repository", (Throwable)e);
                return null;
            }
        }

        public String toString() {
            return "DefaultArtifactHandler";
        }
    }
}

