/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.metrics;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sling.distribution.journal.metrics.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaggedMetrics {
    private static Logger log = LoggerFactory.getLogger(TaggedMetrics.class);

    private TaggedMetrics() {
    }

    public static String getMetricName(String metricName, List<Tag> tags) {
        String metric = tags.stream().map(tag -> ";" + tag.getKey() + "=" + tag.getValue()).collect(Collectors.joining("", metricName, ""));
        log.debug("metric={}", (Object)metric);
        return metric;
    }

    public static String getMetricName(String metricName, Tag tag) {
        return TaggedMetrics.getMetricName(metricName, Collections.singletonList(tag));
    }
}

