/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.DescribeTopicPartitionsRequestData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.DescribeTopicPartitionsResponse;

public class DescribeTopicPartitionsRequest
extends AbstractRequest {
    private final DescribeTopicPartitionsRequestData data;

    public DescribeTopicPartitionsRequest(DescribeTopicPartitionsRequestData data) {
        super(ApiKeys.DESCRIBE_TOPIC_PARTITIONS, (short)0);
        this.data = data;
    }

    public DescribeTopicPartitionsRequest(DescribeTopicPartitionsRequestData data, short version) {
        super(ApiKeys.DESCRIBE_TOPIC_PARTITIONS, version);
        this.data = data;
    }

    @Override
    public DescribeTopicPartitionsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        DescribeTopicPartitionsResponseData responseData = new DescribeTopicPartitionsResponseData();
        for (DescribeTopicPartitionsRequestData.TopicRequest topic : this.data.topics()) {
            responseData.topics().add(new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setName(topic.name()).setErrorCode(error.code()).setIsInternal(false).setPartitions(Collections.emptyList()));
        }
        responseData.setThrottleTimeMs(throttleTimeMs);
        return new DescribeTopicPartitionsResponse(responseData);
    }

    public static DescribeTopicPartitionsRequest parse(ByteBuffer buffer, short version) {
        return new DescribeTopicPartitionsRequest(new DescribeTopicPartitionsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeTopicPartitionsRequest> {
        private final DescribeTopicPartitionsRequestData data;

        public Builder(DescribeTopicPartitionsRequestData data) {
            super(ApiKeys.DESCRIBE_TOPIC_PARTITIONS);
            this.data = data;
        }

        public Builder(List<String> topics) {
            super(ApiKeys.DESCRIBE_TOPIC_PARTITIONS, ApiKeys.DESCRIBE_TOPIC_PARTITIONS.oldestVersion(), ApiKeys.DESCRIBE_TOPIC_PARTITIONS.latestVersion());
            DescribeTopicPartitionsRequestData data = new DescribeTopicPartitionsRequestData();
            topics.forEach(topicName -> data.topics().add(new DescribeTopicPartitionsRequestData.TopicRequest().setName((String)topicName)));
            this.data = data;
        }

        @Override
        public DescribeTopicPartitionsRequest build(short version) {
            return new DescribeTopicPartitionsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

