/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;
import org.apache.skywalking.apm.dependencies.org.slf4j.LoggerFactory;

public final class OffsetsForLeaderEpochUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OffsetsForLeaderEpochUtils.class);

    private OffsetsForLeaderEpochUtils() {
    }

    static AbstractRequest.Builder<OffsetsForLeaderEpochRequest> prepareRequest(Map<TopicPartition, SubscriptionState.FetchPosition> requestData) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(requestData.size());
        requestData.forEach((topicPartition, fetchPosition) -> fetchPosition.offsetEpoch.ifPresent(fetchEpoch -> {
            OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic = topics.find(topicPartition.topic());
            if (topic == null) {
                topic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic());
                topics.add(topic);
            }
            topic.partitions().add(new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(topicPartition.partition()).setLeaderEpoch((int)fetchEpoch).setCurrentLeaderEpoch(fetchPosition.currentLeader.epoch.orElse(-1)));
        }));
        return OffsetsForLeaderEpochRequest.Builder.forConsumer(topics);
    }

    public static OffsetForEpochResult handleResponse(Map<TopicPartition, SubscriptionState.FetchPosition> requestData, OffsetsForLeaderEpochResponse response) {
        HashSet<TopicPartition> partitionsToRetry = new HashSet<TopicPartition>(requestData.keySet());
        HashSet<String> unauthorizedTopics = new HashSet<String>();
        HashMap<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> endOffsets = new HashMap<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>();
        for (OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult topic : response.data().topics()) {
            block7: for (OffsetForLeaderEpochResponseData.EpochEndOffset partition : topic.partitions()) {
                TopicPartition topicPartition = new TopicPartition(topic.topic(), partition.partition());
                if (!requestData.containsKey(topicPartition)) {
                    LOG.warn("Received unrequested topic or partition {} from response, ignoring.", (Object)topicPartition);
                    continue;
                }
                Errors error = Errors.forCode(partition.errorCode());
                switch (error) {
                    case NONE: {
                        LOG.debug("Handling OffsetsForLeaderEpoch response for {}. Got offset {} for epoch {}.", topicPartition, partition.endOffset(), partition.leaderEpoch());
                        endOffsets.put(topicPartition, partition);
                        partitionsToRetry.remove(topicPartition);
                        continue block7;
                    }
                    case NOT_LEADER_OR_FOLLOWER: 
                    case REPLICA_NOT_AVAILABLE: 
                    case KAFKA_STORAGE_ERROR: 
                    case OFFSET_NOT_AVAILABLE: 
                    case LEADER_NOT_AVAILABLE: 
                    case FENCED_LEADER_EPOCH: 
                    case UNKNOWN_LEADER_EPOCH: {
                        LOG.debug("Attempt to fetch offsets for partition {} failed due to {}, retrying.", (Object)topicPartition, (Object)error);
                        continue block7;
                    }
                    case UNKNOWN_TOPIC_OR_PARTITION: {
                        LOG.warn("Received unknown topic or partition error in OffsetsForLeaderEpoch request for partition {}.", (Object)topicPartition);
                        continue block7;
                    }
                    case TOPIC_AUTHORIZATION_FAILED: {
                        unauthorizedTopics.add(topicPartition.topic());
                        partitionsToRetry.remove(topicPartition);
                        continue block7;
                    }
                }
                LOG.warn("Attempt to fetch offsets for partition {} failed due to: {}, retrying.", (Object)topicPartition, (Object)error.message());
            }
        }
        if (!unauthorizedTopics.isEmpty()) {
            throw new TopicAuthorizationException(unauthorizedTopics);
        }
        return new OffsetForEpochResult(endOffsets, partitionsToRetry);
    }

    static class OffsetForEpochResult {
        private final Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> endOffsets;
        private final Set<TopicPartition> partitionsToRetry;

        OffsetForEpochResult(Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> endOffsets, Set<TopicPartition> partitionsNeedingRetry) {
            this.endOffsets = endOffsets;
            this.partitionsToRetry = partitionsNeedingRetry;
        }

        public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> endOffsets() {
            return this.endOffsets;
        }

        public Set<TopicPartition> partitionsToRetry() {
            return this.partitionsToRetry;
        }
    }
}

