/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.trace;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.ids.DistributedTraceId;
import org.apache.skywalking.apm.agent.core.context.ids.GlobalIdGenerator;
import org.apache.skywalking.apm.agent.core.context.ids.NewDistributedTraceId;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractTracingSpan;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegmentRef;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;

public class TraceSegment {
    private String traceSegmentId = GlobalIdGenerator.generate();
    private TraceSegmentRef ref;
    private List<AbstractTracingSpan> spans = new LinkedList<AbstractTracingSpan>();
    private DistributedTraceId relatedGlobalTraceId = new NewDistributedTraceId();
    private boolean ignore = false;
    private boolean isSizeLimited = false;
    private final long createTime = System.currentTimeMillis();

    public void ref(TraceSegmentRef refSegment) {
        if (null == this.ref) {
            this.ref = refSegment;
        }
    }

    public void relatedGlobalTrace(DistributedTraceId distributedTraceId) {
        if (this.relatedGlobalTraceId instanceof NewDistributedTraceId) {
            this.relatedGlobalTraceId = distributedTraceId;
        }
    }

    public void archive(AbstractTracingSpan finishedSpan) {
        this.spans.add(finishedSpan);
    }

    public TraceSegment finish(boolean isSizeLimited) {
        this.isSizeLimited = isSizeLimited;
        return this;
    }

    public String getTraceSegmentId() {
        return this.traceSegmentId;
    }

    public TraceSegmentRef getRef() {
        return this.ref;
    }

    public DistributedTraceId getRelatedGlobalTrace() {
        return this.relatedGlobalTraceId;
    }

    public boolean isSingleSpanSegment() {
        return this.spans != null && this.spans.size() == 1;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public SegmentObject transform() {
        SegmentObject.Builder traceSegmentBuilder = SegmentObject.newBuilder();
        traceSegmentBuilder.setTraceId(this.getRelatedGlobalTrace().getId());
        traceSegmentBuilder.setTraceSegmentId(this.traceSegmentId);
        for (AbstractTracingSpan span : this.spans) {
            traceSegmentBuilder.addSpans(span.transform());
        }
        traceSegmentBuilder.setService(Config.Agent.SERVICE_NAME);
        traceSegmentBuilder.setServiceInstance(Config.Agent.INSTANCE_NAME);
        traceSegmentBuilder.setIsSizeLimited(this.isSizeLimited);
        return traceSegmentBuilder.build();
    }

    public String toString() {
        return "TraceSegment{traceSegmentId='" + this.traceSegmentId + '\'' + ", ref=" + this.ref + ", spans=" + this.spans + "}";
    }

    public long createTime() {
        return this.createTime;
    }
}

