/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client.response;

import com.alibaba.nacos.common.http.client.response.HttpClientResponse;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.utils.IoUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;

public class JdkHttpClientResponse
implements HttpClientResponse {
    private final HttpURLConnection conn;
    private InputStream responseStream;
    private Header responseHeader;
    private static final String CONTENT_ENCODING = "gzip";

    public JdkHttpClientResponse(HttpURLConnection conn) {
        this.conn = conn;
    }

    @Override
    public Header getHeaders() {
        if (this.responseHeader == null) {
            this.responseHeader = Header.newInstance();
        }
        for (Map.Entry<String, List<String>> entry : this.conn.getHeaderFields().entrySet()) {
            this.responseHeader.addOriginalResponseHeader(entry.getKey(), entry.getValue());
        }
        return this.responseHeader;
    }

    @Override
    public InputStream getBody() throws IOException {
        Header headers = this.getHeaders();
        InputStream errorStream = this.conn.getErrorStream();
        this.responseStream = errorStream != null ? errorStream : this.conn.getInputStream();
        String contentEncoding = headers.getValue("Content-Encoding");
        if (CONTENT_ENCODING.equals(contentEncoding)) {
            byte[] bytes = IoUtils.tryDecompress(this.responseStream);
            return new ByteArrayInputStream(bytes);
        }
        return this.responseStream;
    }

    @Override
    public int getStatusCode() throws IOException {
        return this.conn.getResponseCode();
    }

    @Override
    public String getStatusText() throws IOException {
        return this.conn.getResponseMessage();
    }

    @Override
    public void close() {
        IoUtils.closeQuietly((Closeable)this.responseStream);
    }
}

