/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.logql.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.skywalking.logql.rt.grammar.LogQLLexer;
import org.apache.skywalking.logql.rt.grammar.LogQLParser;
import org.apache.skywalking.oap.query.logql.entity.LabelName;
import org.apache.skywalking.oap.query.logql.entity.LogDirection;
import org.apache.skywalking.oap.query.logql.entity.ResultStatus;
import org.apache.skywalking.oap.query.logql.entity.response.LabelValuesQueryRsp;
import org.apache.skywalking.oap.query.logql.entity.response.LabelsQueryRsp;
import org.apache.skywalking.oap.query.logql.entity.response.LogRangeQueryRsp;
import org.apache.skywalking.oap.query.logql.entity.response.QueryResponse;
import org.apache.skywalking.oap.query.logql.entity.response.ResultType;
import org.apache.skywalking.oap.query.logql.entity.response.StreamLog;
import org.apache.skywalking.oap.query.logql.entity.response.TimeValuePair;
import org.apache.skywalking.oap.query.logql.rt.LogQLExprVisitor;
import org.apache.skywalking.oap.query.logql.rt.exception.ParseErrorListener;
import org.apache.skywalking.oap.query.logql.rt.result.LogQLParseResult;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.LogQueryService;
import org.apache.skywalking.oap.server.core.query.TagAutoCompleteQueryService;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TraceScopeCondition;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.query.type.Pagination;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class LogQLApiHandler {
    private final LogQueryService logQueryService;
    private final TagAutoCompleteQueryService tagAutoCompleteQueryService;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public LogQLApiHandler(ModuleManager moduleManager) {
        this.logQueryService = (LogQueryService)moduleManager.find("core").provider().getService(LogQueryService.class);
        this.tagAutoCompleteQueryService = (TagAutoCompleteQueryService)moduleManager.find("core").provider().getService(TagAutoCompleteQueryService.class);
    }

    @Get
    @Path(value="/loki/api/v1/labels")
    public HttpResponse labels(@Param(value="start") Long start, @Param(value="end") Long end) throws IOException {
        LabelsQueryRsp labelsQueryRsp = new LabelsQueryRsp();
        labelsQueryRsp.setStatus(ResultStatus.SUCCESS);
        Duration duration = DurationUtils.timestamp2Duration((long)this.nano2Millis(start), (long)this.nano2Millis(end));
        this.tagAutoCompleteQueryService.queryTagAutocompleteKeys(TagType.LOG, duration).forEach(tag -> labelsQueryRsp.getData().add((String)tag));
        return this.successResponse(labelsQueryRsp);
    }

    @Get
    @Path(value="/loki/api/v1/label/{label_name}/values")
    public HttpResponse labelValues(@Param(value="label_name") String labelName, @Param(value="start") Long start, @Param(value="end") Long end) throws IOException {
        LabelValuesQueryRsp response = new LabelValuesQueryRsp();
        response.setStatus(ResultStatus.SUCCESS);
        Duration duration = DurationUtils.timestamp2Duration((long)this.nano2Millis(start), (long)this.nano2Millis(end));
        this.tagAutoCompleteQueryService.queryTagAutocompleteValues(TagType.LOG, labelName, duration).forEach(value -> response.getData().add((String)value));
        return this.successResponse(response);
    }

    @Get
    @Path(value="/loki/api/v1/query_range")
    public HttpResponse rangeQuery(@Param(value="start") Long start, @Param(value="end") Long end, @Param(value="query") String query, @Param(value="limit") Integer limit, @Param(value="direction") LogDirection direction) throws IOException {
        LogQLParser.RootContext tree;
        LogRangeQueryRsp logRangeQueryRsp = new LogRangeQueryRsp();
        logRangeQueryRsp.setStatus(ResultStatus.SUCCESS);
        LogQLLexer lexer = new LogQLLexer((CharStream)CharStreams.fromString((String)query));
        lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        LogQLParser parser = new LogQLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        try {
            tree = parser.root();
        }
        catch (ParseCancellationException e) {
            return this.badResponse(e.getMessage());
        }
        LogQLExprVisitor visitor = new LogQLExprVisitor();
        LogQLParseResult parseResult = (LogQLParseResult)visitor.visit((ParseTree)tree);
        Map<String, String> labelMap = parseResult.getLabelMap();
        String serviceId = labelMap.containsKey(LabelName.SERVICE.getLabel()) ? IDManager.ServiceID.buildId((String)labelMap.get(LabelName.SERVICE.getLabel()), (boolean)true) : null;
        String serviceInstanceId = null;
        String endpointId = null;
        if (StringUtil.isNotEmpty((String)serviceId)) {
            serviceInstanceId = labelMap.containsKey(LabelName.SERVICE_INSTANCE.getLabel()) ? IDManager.ServiceInstanceID.buildId((String)serviceId, (String)labelMap.get(LabelName.SERVICE_INSTANCE.getLabel())) : null;
            endpointId = labelMap.containsKey(LabelName.ENDPOINT.getLabel()) ? IDManager.EndpointID.buildId((String)serviceId, (String)labelMap.get(LabelName.ENDPOINT.getLabel())) : null;
        }
        String traceId = labelMap.get(LabelName.TRACE_ID.getLabel());
        TraceScopeCondition traceScopeCondition = new TraceScopeCondition();
        if (StringUtil.isNotEmpty((String)traceId)) {
            traceScopeCondition.setTraceId(traceId);
        }
        List tags = labelMap.entrySet().stream().filter(entry -> !LabelName.containsLabel((String)entry.getKey())).map(entry -> new Tag((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        Duration duration = DurationUtils.timestamp2Duration((long)this.nano2Millis(start), (long)this.nano2Millis(end));
        Logs logs = this.logQueryService.queryLogs(serviceId, serviceInstanceId, endpointId, traceScopeCondition, new Pagination(1, limit.intValue()), direction.getOrder(), duration, tags, parseResult.getKeywordsOfContent(), parseResult.getExcludingKeywordsOfContent());
        if (StringUtil.isNotEmpty((String)logs.getErrorReason())) {
            return this.badResponse(logs.getErrorReason());
        }
        StreamLog responseData = new StreamLog();
        responseData.setResultType(ResultType.STREAMS);
        logRangeQueryRsp.setData(responseData);
        logs.getLogs().stream().collect(Collectors.groupingBy(log -> log.getServiceId() + log.getServiceInstanceId() + log.getEndpointName() + log.getTraceId())).forEach((streamKey, logList) -> {
            StreamLog.Result result = new StreamLog.Result();
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put(LabelName.SERVICE.getLabel(), ((Log)logList.get(0)).getServiceName());
            labels.put(LabelName.SERVICE_INSTANCE.getLabel(), ((Log)logList.get(0)).getServiceInstanceName());
            labels.put(LabelName.ENDPOINT.getLabel(), ((Log)logList.get(0)).getEndpointName());
            labels.put(LabelName.TRACE_ID.getLabel(), ((Log)logList.get(0)).getTraceId());
            result.setStream(labels);
            ArrayList<TimeValuePair> timeValuePairs = new ArrayList<TimeValuePair>();
            for (Log log : logList) {
                timeValuePairs.add(new TimeValuePair(String.valueOf(this.millis2Nano(log.getTimestamp())), log.getContent()));
            }
            result.setValues(timeValuePairs);
            responseData.getResult().add(result);
        });
        return this.successResponse(logRangeQueryRsp);
    }

    private long nano2Millis(Long nanosecond) {
        return nanosecond / 1000000L;
    }

    private long millis2Nano(Long nanosecond) {
        return nanosecond * 1000000L;
    }

    private HttpResponse badResponse(String message) {
        return HttpResponse.of((ResponseHeaders)ResponseHeaders.builder((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.PLAIN_TEXT_UTF_8).build(), (HttpData)HttpData.ofUtf8((String)message));
    }

    private HttpResponse successResponse(QueryResponse response) throws JsonProcessingException {
        return HttpResponse.of((ResponseHeaders)ResponseHeaders.builder((HttpStatus)HttpStatus.OK).contentType(MediaType.JSON_UTF_8).build(), (HttpData)HttpData.ofUtf8((String)MAPPER.writeValueAsString((Object)response)));
    }
}

