/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.source.ScopeDefaultColumn;
import org.apache.skywalking.oap.server.core.source.SideCar;
import org.apache.skywalking.oap.server.core.source.Source;

@ScopeDeclaration(id=57, name="TCPService", catalog="SERVICE")
@ScopeDefaultColumn.VirtualColumnDefinition(fieldName="entityId", columnName="entity_id", isID=true, type=String.class)
public class TCPService
extends Source {
    private volatile String entityId;
    @ScopeDefaultColumn.DefinedByField(columnName="name", requireDynamicActive=true)
    private String name;
    private Layer layer;
    private String serviceInstanceName;
    private List<String> tags;
    private Map<String, String> originalTags;
    private SideCar sideCar = new SideCar();
    private long receivedBytes;
    private long sentBytes;

    @Override
    public int scope() {
        return 57;
    }

    @Override
    public String getEntityId() {
        if (this.entityId == null) {
            this.entityId = IDManager.ServiceID.buildId(this.name, this.layer.isNormal());
        }
        return this.entityId;
    }

    public String getTag(String key) {
        return this.originalTags.get(key);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    @Generated
    public Layer getLayer() {
        return this.layer;
    }

    @Generated
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Generated
    public void setServiceInstanceName(String serviceInstanceName) {
        this.serviceInstanceName = serviceInstanceName;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setOriginalTags(Map<String, String> originalTags) {
        this.originalTags = originalTags;
    }

    @Generated
    public SideCar getSideCar() {
        return this.sideCar;
    }

    @Generated
    public void setSideCar(SideCar sideCar) {
        this.sideCar = sideCar;
    }

    @Generated
    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    @Generated
    public void setReceivedBytes(long receivedBytes) {
        this.receivedBytes = receivedBytes;
    }

    @Generated
    public long getSentBytes() {
        return this.sentBytes;
    }

    @Generated
    public void setSentBytes(long sentBytes) {
        this.sentBytes = sentBytes;
    }
}

