/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.values.legacycoercing;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Scalars;
import graphql.execution.values.InputInterceptor;
import graphql.scalar.CoercingUtil;
import graphql.schema.GraphQLInputType;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyCoercingInputInterceptor
implements InputInterceptor {
    private final BiFunction<Object, GraphQLInputType, Object> behavior;

    public static LegacyCoercingInputInterceptor observesValues(BiConsumer<Object, GraphQLInputType> observerCallback) {
        return new LegacyCoercingInputInterceptor((input, graphQLInputType) -> {
            observerCallback.accept(input, (GraphQLInputType)graphQLInputType);
            return input;
        });
    }

    public static LegacyCoercingInputInterceptor migratesValues() {
        return LegacyCoercingInputInterceptor.migratesValues((input, type) -> {});
    }

    public static LegacyCoercingInputInterceptor migratesValues(BiConsumer<Object, GraphQLInputType> observerCallback) {
        return new LegacyCoercingInputInterceptor((input, graphQLInputType) -> {
            observerCallback.accept(input, (GraphQLInputType)graphQLInputType);
            if (Scalars.GraphQLBoolean.equals(graphQLInputType)) {
                return LegacyCoercingInputInterceptor.coerceLegacyBooleanValue(input);
            }
            if (Scalars.GraphQLFloat.equals(graphQLInputType)) {
                return LegacyCoercingInputInterceptor.coerceLegacyFloatValue(input);
            }
            if (Scalars.GraphQLInt.equals(graphQLInputType)) {
                return LegacyCoercingInputInterceptor.coerceLegacyIntValue(input);
            }
            if (Scalars.GraphQLString.equals(graphQLInputType)) {
                return LegacyCoercingInputInterceptor.coerceLegacyStringValue(input);
            }
            return input;
        });
    }

    private LegacyCoercingInputInterceptor(BiFunction<Object, GraphQLInputType, Object> behavior) {
        this.behavior = Assert.assertNotNull(behavior);
    }

    @Override
    public Object intercept(@Nullable Object input, @NotNull GraphQLInputType graphQLType, @NotNull GraphQLContext graphqlContext, @NotNull Locale locale) {
        if (LegacyCoercingInputInterceptor.isLegacyValue(input, graphQLType)) {
            return this.behavior.apply(input, graphQLType);
        }
        return input;
    }

    static boolean isLegacyValue(Object input, GraphQLInputType graphQLType) {
        if (Scalars.GraphQLBoolean.equals(graphQLType)) {
            return LegacyCoercingInputInterceptor.isLegacyBooleanValue(input);
        }
        if (Scalars.GraphQLFloat.equals(graphQLType)) {
            return LegacyCoercingInputInterceptor.isLegacyFloatValue(input);
        }
        if (Scalars.GraphQLInt.equals(graphQLType)) {
            return LegacyCoercingInputInterceptor.isLegacyIntValue(input);
        }
        if (Scalars.GraphQLString.equals(graphQLType)) {
            return LegacyCoercingInputInterceptor.isLegacyStringValue(input);
        }
        return false;
    }

    static boolean isLegacyBooleanValue(Object input) {
        return input instanceof String || CoercingUtil.isNumberIsh(input);
    }

    static boolean isLegacyFloatValue(Object input) {
        return input instanceof String;
    }

    static boolean isLegacyIntValue(Object input) {
        return input instanceof String;
    }

    static boolean isLegacyStringValue(Object input) {
        return !(input instanceof String);
    }

    static Object coerceLegacyBooleanValue(Object input) {
        if (input instanceof String) {
            String lStr = ((String)input).toLowerCase();
            if (lStr.equals("true")) {
                return true;
            }
            if (lStr.equals("false")) {
                return false;
            }
            return input;
        }
        if (CoercingUtil.isNumberIsh(input)) {
            BigDecimal value;
            try {
                value = new BigDecimal(input.toString());
            }
            catch (NumberFormatException e) {
                return input;
            }
            return value.compareTo(BigDecimal.ZERO) != 0;
        }
        return input;
    }

    static Object coerceLegacyFloatValue(Object input) {
        if (CoercingUtil.isNumberIsh(input)) {
            BigDecimal value;
            try {
                value = new BigDecimal(input.toString());
            }
            catch (NumberFormatException e) {
                return input;
            }
            return value.doubleValue();
        }
        return input;
    }

    static Object coerceLegacyIntValue(Object input) {
        if (CoercingUtil.isNumberIsh(input)) {
            BigDecimal value;
            try {
                value = new BigDecimal(input.toString());
            }
            catch (NumberFormatException e) {
                return input;
            }
            try {
                return value.intValueExact();
            }
            catch (ArithmeticException e) {
                return input;
            }
        }
        return input;
    }

    static Object coerceLegacyStringValue(Object input) {
        return String.valueOf(input);
    }
}

