/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.internal.AnnotatedMatrix;
import org.apache.sis.referencing.internal.ParameterizedTransformBuilder;
import org.apache.sis.referencing.internal.PositionalAccuracyConstant;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.internal.shared.CoordinateOperations;
import org.apache.sis.referencing.internal.shared.EllipsoidalHeightCombiner;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationRegistry;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultPassThroughOperation;
import org.apache.sis.referencing.operation.MathTransformContext;
import org.apache.sis.referencing.operation.MissingSourceDimensionsException;
import org.apache.sis.referencing.operation.SubOperationInfo;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.matrix.UnderdeterminedMatrixException;
import org.apache.sis.referencing.operation.provider.DatumShiftMethod;
import org.apache.sis.referencing.operation.provider.GeocentricAffine;
import org.apache.sis.referencing.operation.transform.MathTransformBuilder;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

public class CoordinateOperationFinder
extends CoordinateOperationRegistry {
    private final Map<Identifier, Object> identifierOfStepCRS = new HashMap<Identifier, Object>(8);
    private final Map<CRSPair, Boolean> previousSearches = new HashMap<CRSPair, Boolean>(8);
    private final boolean canReadFromCache;
    private boolean canStoreInCache;

    public CoordinateOperationFinder(CoordinateOperationAuthorityFactory registry, CoordinateOperationFactory factory, CoordinateOperationContext context) throws FactoryException {
        super(registry, factory, context);
        this.canReadFromCache = (context == null || context.canReadFromCache()) && factory == this.factorySIS;
        this.canStoreInCache = context == null;
    }

    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws OperationNotFoundException, FactoryException {
        boolean oldState = this.stopAtFirst;
        this.stopAtFirst = true;
        List<CoordinateOperation> operations = this.createOperations(sourceCRS, targetCRS);
        this.stopAtFirst = oldState;
        if (!operations.isEmpty()) {
            return operations.get(0);
        }
        throw new OperationNotFoundException(this.notFoundMessage(sourceCRS, targetCRS));
    }

    @Override
    public List<CoordinateOperation> createOperations(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        GeneralDerivedCRS source;
        List<CoordinateOperation> authoritatives;
        CoordinateOperation op;
        ArgumentChecks.ensureNonNull((String)"sourceCRS", (Object)sourceCRS);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)targetCRS);
        if (CRS.equivalent(sourceCRS, targetCRS)) {
            try {
                return CoordinateOperationFinder.asList(this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, null, CoordinateSystems.swapAndScaleAxes(sourceCRS.getCoordinateSystem(), targetCRS.getCoordinateSystem())));
            }
            catch (UnderdeterminedMatrixException exception) {
                throw new MissingSourceDimensionsException(this.notFoundMessage(sourceCRS, targetCRS), exception);
            }
            catch (IllegalArgumentException | IncommensurableException exception) {
                throw new OperationNotFoundException(this.notFoundMessage(sourceCRS, targetCRS), exception);
            }
        }
        CRSPair key = new CRSPair(sourceCRS, targetCRS);
        if (this.canReadFromCache && this.stopAtFirst && !this.previousSearches.isEmpty() && (op = (CoordinateOperation)this.factorySIS.cache.peek((Object)key)) != null) {
            return CoordinateOperationFinder.asList(op);
        }
        if (this.previousSearches.put(key, Boolean.TRUE) != null) {
            throw new FactoryException(this.resources().getString((short)62, CoordinateOperation.class, (Object)key));
        }
        GeographicBoundingBox bbox = Extents.getGeographicBoundingBox((Extent)this.areaOfInterest);
        if (bbox == null) {
            bbox = Extents.intersection((GeographicBoundingBox)CRS.getGeographicBoundingBox(sourceCRS), (GeographicBoundingBox)CRS.getGeographicBoundingBox(targetCRS));
            this.areaOfInterest = CoordinateOperationContext.setGeographicBoundingBox(DefaultExtent.castOrCopy((Extent)this.areaOfInterest), bbox);
        }
        if (this.registry != null && !(authoritatives = super.createOperations(sourceCRS, targetCRS)).isEmpty()) {
            return authoritatives;
        }
        if (sourceCRS instanceof GeneralDerivedCRS) {
            source = (GeneralDerivedCRS)sourceCRS;
            if (targetCRS instanceof GeneralDerivedCRS) {
                return this.createOperationStep(source, (GeneralDerivedCRS)targetCRS);
            }
            if (targetCRS instanceof SingleCRS) {
                return this.createOperationStep(source, (SingleCRS)targetCRS);
            }
        }
        if (targetCRS instanceof GeneralDerivedCRS) {
            GeneralDerivedCRS target = (GeneralDerivedCRS)targetCRS;
            if (sourceCRS instanceof SingleCRS) {
                return this.createOperationStep((SingleCRS)sourceCRS, target);
            }
        }
        if (sourceCRS instanceof GeodeticCRS) {
            source = (GeodeticCRS)sourceCRS;
            if (targetCRS instanceof GeodeticCRS) {
                return this.createOperationStep((GeodeticCRS)source, (GeodeticCRS)targetCRS);
            }
            if (targetCRS instanceof VerticalCRS) {
                return this.createOperationStep((GeodeticCRS)source, (VerticalCRS)targetCRS);
            }
        }
        if (sourceCRS instanceof VerticalCRS) {
            source = (VerticalCRS)sourceCRS;
            if (targetCRS instanceof VerticalCRS) {
                return this.createOperationStep((VerticalCRS)source, (VerticalCRS)targetCRS);
            }
        }
        if (sourceCRS instanceof TemporalCRS) {
            source = (TemporalCRS)sourceCRS;
            if (targetCRS instanceof TemporalCRS) {
                return this.createOperationStep((TemporalCRS)source, (TemporalCRS)targetCRS);
            }
        }
        if (sourceCRS instanceof SingleCRS && targetCRS instanceof SingleCRS) {
            return this.createOperationStepFallback((SingleCRS)sourceCRS, (SingleCRS)targetCRS);
        }
        if (sourceCRS instanceof CompoundCRS || targetCRS instanceof CompoundCRS) {
            return this.createOperationStep(sourceCRS, CRS.getSingleComponents(sourceCRS), targetCRS, CRS.getSingleComponents(targetCRS));
        }
        throw new OperationNotFoundException(this.notFoundMessage(sourceCRS, targetCRS));
    }

    protected List<CoordinateOperation> createOperationStep(SingleCRS sourceCRS, GeneralDerivedCRS targetCRS) throws FactoryException {
        List<CoordinateOperation> operations = this.createOperations((CoordinateReferenceSystem)sourceCRS, targetCRS.getBaseCRS());
        ListIterator<CoordinateOperation> it = operations.listIterator();
        if (it.hasNext()) {
            Conversion step2 = targetCRS.getConversionFromBase();
            do {
                CoordinateOperation step1 = it.next();
                it.set(this.concatenate(step1, (CoordinateOperation)step2));
            } while (it.hasNext());
        }
        return operations;
    }

    protected List<CoordinateOperation> createOperationStep(GeneralDerivedCRS sourceCRS, SingleCRS targetCRS) throws FactoryException {
        List<CoordinateOperation> operations = this.createOperations(sourceCRS.getBaseCRS(), (CoordinateReferenceSystem)targetCRS);
        ListIterator<CoordinateOperation> it = operations.listIterator();
        if (it.hasNext()) {
            CoordinateOperation step1;
            try {
                step1 = this.inverse((SingleOperation)sourceCRS.getConversionFromBase());
            }
            catch (OperationNotFoundException exception) {
                throw exception;
            }
            catch (NoninvertibleTransformException | FactoryException exception) {
                throw new OperationNotFoundException(this.canNotInvert(sourceCRS), exception);
            }
            do {
                CoordinateOperation step2 = it.next();
                it.set(this.concatenate(step1, step2));
            } while (it.hasNext());
        }
        return operations;
    }

    protected List<CoordinateOperation> createOperationStep(GeneralDerivedCRS sourceCRS, GeneralDerivedCRS targetCRS) throws FactoryException {
        List<CoordinateOperation> operations = this.createOperations(sourceCRS.getBaseCRS(), targetCRS.getBaseCRS());
        ListIterator<CoordinateOperation> it = operations.listIterator();
        if (it.hasNext()) {
            CoordinateOperation step1;
            Conversion step3 = targetCRS.getConversionFromBase();
            try {
                step1 = this.inverse((SingleOperation)sourceCRS.getConversionFromBase());
            }
            catch (OperationNotFoundException exception) {
                throw exception;
            }
            catch (NoninvertibleTransformException | FactoryException exception) {
                throw new OperationNotFoundException(this.canNotInvert(sourceCRS), exception);
            }
            do {
                CoordinateOperation step2 = it.next();
                it.set(this.concatenate(step1, step2, (CoordinateOperation)step3));
            } while (it.hasNext());
        }
        return operations;
    }

    protected List<CoordinateOperation> createOperationStep(GeodeticCRS sourceCRS, GeodeticCRS targetCRS) throws FactoryException {
        Class<Transformation> type;
        Matrix datumShift;
        ParameterValueGroup parameters;
        Optional<OperationMethod> method;
        MathTransform transform;
        MathTransformBuilder builder;
        Identifier typeOfChange;
        boolean sameDatumOrEnsemble;
        Optional<Object> finalDatum;
        GeodeticDatum targetDatum;
        CoordinateSystem sourceCS = sourceCRS.getCoordinateSystem();
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        GeodeticDatum sourceDatum = DatumOrEnsemble.asDatum(sourceCRS);
        if (Utilities.equalsIgnoreMetadata((Object)sourceDatum, (Object)(targetDatum = DatumOrEnsemble.asDatum(targetCRS)))) {
            finalDatum = Optional.empty();
            sameDatumOrEnsemble = true;
            typeOfChange = sourceCS instanceof EllipsoidalCS == targetCS instanceof EllipsoidalCS ? AXIS_CHANGES : GEOCENTRIC_CONVERSION;
        } else {
            finalDatum = DatumOrEnsemble.asTargetDatum(sourceCRS, targetCRS);
            sameDatumOrEnsemble = finalDatum.isPresent();
            Identifier identifier = typeOfChange = sameDatumOrEnsemble ? SAME_DATUM_ENSEMBLE : UNSPECIFIED_DATUM_CHANGE;
        }
        if (sameDatumOrEnsemble) {
            builder = CoordinateOperations.builder(this.factorySIS.getMathTransformFactory(), "Coordinate system conversion");
            builder.setSourceAxes(sourceCS, sourceDatum.getEllipsoid());
            builder.setTargetAxes(targetCS, targetDatum.getEllipsoid());
            transform = builder.create();
            method = builder.getMethod();
            parameters = builder.parameters();
            datumShift = null;
        } else {
            DefaultGeodeticDatum impl;
            if (sourceDatum instanceof DefaultGeodeticDatum) {
                impl = (DefaultGeodeticDatum)sourceDatum;
                datumShift = impl.getPositionVectorTransformation(targetDatum, this.areaOfInterest);
                if (datumShift != null) {
                    typeOfChange = DATUM_SHIFT;
                }
            } else if (targetDatum instanceof DefaultGeodeticDatum) {
                impl = (DefaultGeodeticDatum)targetDatum;
                Matrix matrix = impl.getPositionVectorTransformation(sourceDatum, this.areaOfInterest);
                if (matrix != null) {
                    try {
                        matrix = Matrices.inverse(matrix);
                        typeOfChange = DATUM_SHIFT;
                    }
                    catch (NoninvertibleMatrixException e) {
                        this.recoverableException("createOperationStep", (Exception)((Object)e));
                        matrix = null;
                    }
                }
                datumShift = matrix;
            } else {
                datumShift = null;
            }
            builder = new MathTransformContext(this.factorySIS.getMathTransformFactory(), sourceDatum, targetDatum);
            ((ParameterizedTransformBuilder)builder).setSourceAxes(sourceCS, sourceDatum.getEllipsoid());
            ((ParameterizedTransformBuilder)builder).setTargetAxes(targetCS, targetDatum.getEllipsoid());
            parameters = GeocentricAffine.createParameters(sourceCS, targetCS, datumShift, DatumShiftMethod.forAccuracy(this.desiredAccuracy));
            if (parameters != null) {
                ((ParameterizedTransformBuilder)builder).setParameters(parameters, false);
                transform = ((ParameterizedTransformBuilder)builder).create();
            } else {
                transform = ((MathTransformContext)builder).createAffineGeocentric(datumShift);
            }
            method = builder.getMethod();
            parameters = ((MathTransformContext)builder).parametersForMetadata();
        }
        Map<String, Object> properties = CoordinateOperationFinder.properties(typeOfChange);
        PositionalAccuracy accuracy = finalDatum.flatMap(DatumOrEnsemble::getAccuracy).orElseGet(() -> datumShift instanceof AnnotatedMatrix ? ((AnnotatedMatrix)datumShift).accuracy : null);
        if (CoordinateOperationFinder.isDatumChange(typeOfChange)) {
            type = Transformation.class;
            if (accuracy == null) {
                accuracy = typeOfChange == UNSPECIFIED_DATUM_CHANGE ? PositionalAccuracyConstant.DATUM_SHIFT_OMITTED : PositionalAccuracyConstant.DATUM_SHIFT_APPLIED;
            }
        } else {
            type = Conversion.class;
        }
        properties.put("coordinateOperationAccuracy", accuracy);
        return CoordinateOperationFinder.asList(this.createFromMathTransform(properties, (CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, transform, method.orElse(null), parameters, type));
    }

    protected List<CoordinateOperation> createOperationStep(GeodeticCRS sourceCRS, VerticalCRS targetCRS) throws FactoryException {
        boolean isEllipsoidalHeight;
        int i;
        EllipsoidalCS cs;
        CoordinateOperation step1 = null;
        CoordinateOperation step3 = null;
        GeodeticCRS interpolationCRS = sourceCRS;
        CoordinateSystem interpolationCS = interpolationCRS.getCoordinateSystem();
        if (!(interpolationCS instanceof EllipsoidalCS) && !Utilities.equalsIgnoreMetadata((Object)interpolationCS, (Object)(cs = CommonCRS.WGS84.geographic3D().getCoordinateSystem()))) {
            GeographicCRS stepCRS = this.factorySIS.crsFactory.createGeographicCRS(this.derivedFrom((IdentifiedObject)sourceCRS), DatumOrEnsemble.asDatum(sourceCRS), cs);
            step1 = this.createOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)this.toAuthorityDefinition(GeographicCRS.class, stepCRS));
            interpolationCRS = step1.getTargetCRS();
            interpolationCS = interpolationCRS.getCoordinateSystem();
        }
        if ((i = AxisDirections.indexOfColinear(interpolationCS, AxisDirection.UP)) < 0) {
            throw new OperationNotFoundException(this.notFoundMessage((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS));
        }
        CoordinateSystemAxis expectedAxis = interpolationCS.getAxis(i);
        VerticalCRS heightCRS = targetCRS;
        VerticalCS heightCS = heightCRS.getCoordinateSystem();
        if (Utilities.equalsIgnoreMetadata((Object)heightCS.getAxis(0), (Object)expectedAxis)) {
            isEllipsoidalHeight = ReferencingUtilities.isEllipsoidalHeight(DatumOrEnsemble.asDatum(heightCRS));
        } else {
            heightCRS = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            heightCS = heightCRS.getCoordinateSystem();
            isEllipsoidalHeight = Utilities.equalsIgnoreMetadata((Object)heightCS.getAxis(0), (Object)expectedAxis);
            if (!isEllipsoidalHeight) {
                heightCS = this.toAuthorityDefinition(VerticalCS.class, this.factorySIS.csFactory.createVerticalCS(this.derivedFrom((IdentifiedObject)heightCS), expectedAxis));
            }
        }
        if (!isEllipsoidalHeight) {
            heightCRS = this.toAuthorityDefinition(VerticalCRS.class, this.factorySIS.crsFactory.createVerticalCRS(this.derivedFrom((IdentifiedObject)heightCRS), CommonCRS.Vertical.ELLIPSOIDAL.datum(), heightCS));
        }
        if (heightCRS != targetCRS) {
            step3 = this.createOperation((CoordinateReferenceSystem)heightCRS, (CoordinateReferenceSystem)targetCRS);
            heightCRS = (VerticalCRS)step3.getSourceCRS();
            heightCS = heightCRS.getCoordinateSystem();
        }
        int srcDim = interpolationCS.getDimension();
        int tgtDim = heightCS.getDimension();
        MatrixSIS matrix = Matrices.createZero(tgtDim + 1, srcDim + 1);
        matrix.setElement(0, i, 1.0);
        matrix.setElement(tgtDim, srcDim, 1.0);
        CoordinateOperation step2 = this.createFromAffineTransform(AXIS_CHANGES, (CoordinateReferenceSystem)interpolationCRS, (CoordinateReferenceSystem)heightCRS, null, matrix);
        return CoordinateOperationFinder.asList(this.concatenate(step1, step2, step3));
    }

    protected List<CoordinateOperation> createOperationStep(VerticalCRS sourceCRS, VerticalCRS targetCRS) throws FactoryException {
        Matrix matrix;
        Identifier typeOfChange;
        Optional<Object> finalDatum;
        VerticalDatum targetDatum;
        VerticalDatum sourceDatum = DatumOrEnsemble.asDatum(sourceCRS);
        if (Utilities.equalsIgnoreMetadata((Object)sourceDatum, (Object)(targetDatum = DatumOrEnsemble.asDatum(targetCRS)))) {
            finalDatum = Optional.empty();
            typeOfChange = AXIS_CHANGES;
        } else {
            finalDatum = DatumOrEnsemble.asTargetDatum(sourceCRS, targetCRS);
            if (finalDatum.isEmpty()) {
                throw new OperationNotFoundException(this.datumChangeNotFound((IdentifiedObject)sourceDatum, (IdentifiedObject)targetDatum));
            }
            typeOfChange = SAME_DATUM_ENSEMBLE;
        }
        VerticalCS sourceCS = sourceCRS.getCoordinateSystem();
        VerticalCS targetCS = targetCRS.getCoordinateSystem();
        try {
            matrix = CoordinateSystems.swapAndScaleAxes((CoordinateSystem)sourceCS, (CoordinateSystem)targetCS);
        }
        catch (UnderdeterminedMatrixException exception) {
            throw new MissingSourceDimensionsException(this.notFoundMessage((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS), exception);
        }
        catch (IllegalArgumentException | IncommensurableException exception) {
            throw new OperationNotFoundException(this.notFoundMessage((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS), exception);
        }
        return CoordinateOperationFinder.asList(this.createFromAffineTransform(typeOfChange, (CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, finalDatum, matrix));
    }

    protected List<CoordinateOperation> createOperationStep(TemporalCRS sourceCRS, TemporalCRS targetCRS) throws FactoryException {
        MatrixSIS matrix;
        Identifier typeOfChange;
        Optional<Object> finalDatum;
        TemporalDatum targetDatum;
        TemporalDatum sourceDatum = DatumOrEnsemble.asDatum(sourceCRS);
        if (Utilities.equalsIgnoreMetadata((Object)sourceDatum, (Object)(targetDatum = DatumOrEnsemble.asDatum(targetCRS)))) {
            finalDatum = Optional.empty();
            typeOfChange = AXIS_CHANGES;
        } else {
            finalDatum = DatumOrEnsemble.asTargetDatum(sourceCRS, targetCRS);
            typeOfChange = finalDatum.isPresent() ? SAME_DATUM_ENSEMBLE : DATUM_SHIFT;
        }
        TimeCS sourceCS = sourceCRS.getCoordinateSystem();
        TimeCS targetCS = targetCRS.getCoordinateSystem();
        Unit targetUnit = targetCS.getAxis(0).getUnit().asType(Time.class);
        DoubleDouble epochShift = DoubleDouble.of((Duration)Duration.between(TemporalDate.toTemporal((Date)targetDatum.getOrigin()), TemporalDate.toTemporal((Date)sourceDatum.getOrigin())));
        epochShift = DoubleDouble.of((Number)Units.NANOSECOND.getConverterTo(targetUnit).convert((Number)epochShift), (boolean)true);
        try {
            matrix = MatrixSIS.castOrCopy(CoordinateSystems.swapAndScaleAxes((CoordinateSystem)sourceCS, (CoordinateSystem)targetCS));
        }
        catch (UnderdeterminedMatrixException exception) {
            throw new MissingSourceDimensionsException(this.notFoundMessage((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS), exception);
        }
        catch (IllegalArgumentException | IncommensurableException exception) {
            throw new OperationNotFoundException(this.notFoundMessage((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS), exception);
        }
        int translationColumn = matrix.getNumCol() - 1;
        DoubleDouble translation = DoubleDouble.of((Number)matrix.getNumber(0, translationColumn), (boolean)true);
        matrix.setNumber(0, translationColumn, (Number)translation.add(epochShift));
        return CoordinateOperationFinder.asList(this.createFromAffineTransform(typeOfChange, (CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, finalDatum, matrix));
    }

    private List<CoordinateOperation> createOperationStepFallback(SingleCRS sourceCRS, SingleCRS targetCRS) throws FactoryException {
        Matrix matrix;
        Identifier typeOfChange;
        Optional<Object> finalDatum;
        IdentifiedObject targetDatum;
        IdentifiedObject sourceDatum = DatumOrEnsemble.of(sourceCRS);
        if (Utilities.equalsIgnoreMetadata((Object)sourceDatum, (Object)(targetDatum = DatumOrEnsemble.of(targetCRS)))) {
            finalDatum = Optional.empty();
            typeOfChange = AXIS_CHANGES;
        } else {
            finalDatum = DatumOrEnsemble.ofTarget(sourceCRS, targetCRS);
            if (finalDatum.isEmpty()) {
                throw new OperationNotFoundException(this.datumChangeNotFound(sourceDatum, targetDatum));
            }
            typeOfChange = SAME_DATUM_ENSEMBLE;
        }
        CoordinateSystem sourceCS = sourceCRS.getCoordinateSystem();
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        try {
            matrix = CoordinateSystems.swapAndScaleAxes(sourceCS, targetCS);
        }
        catch (UnderdeterminedMatrixException exception) {
            throw new MissingSourceDimensionsException(this.notFoundMessage((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS), exception);
        }
        catch (IllegalArgumentException | IncommensurableException exception) {
            throw new OperationNotFoundException(this.notFoundMessage((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS), exception);
        }
        return CoordinateOperationFinder.asList(this.createFromAffineTransform(typeOfChange, (CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, finalDatum, matrix));
    }

    protected List<CoordinateOperation> createOperationStep(CoordinateReferenceSystem sourceCRS, List<? extends SingleCRS> sourceComponents, CoordinateReferenceSystem targetCRS, List<? extends SingleCRS> targetComponents) throws FactoryException {
        CoordinateOperation operation;
        CoordinateReferenceSystem stepSourceCRS;
        SubOperationInfo[] infos;
        try {
            infos = SubOperationInfo.createSteps(this, sourceCRS, sourceComponents, targetComponents);
        }
        catch (NoninvertibleTransformException e) {
            throw new OperationNotFoundException(this.notFoundMessage(sourceCRS, targetCRS), (Throwable)e);
        }
        catch (TransformException e) {
            throw new FactoryException(this.notFoundMessage(sourceCRS, targetCRS), (Throwable)e);
        }
        CoordinateReferenceSystem[] stepComponents = SubOperationInfo.getSourceCRS(infos);
        MatrixSIS select = SubOperationInfo.sourceToSelected(sourceCRS.getCoordinateSystem().getDimension(), infos);
        if (select.isIdentity()) {
            stepSourceCRS = sourceCRS;
            operation = null;
        } else {
            if (stepComponents.length == 1) {
                stepSourceCRS = stepComponents[0];
            } else {
                CompoundCRS crs = this.factorySIS.crsFactory.createCompoundCRS(this.derivedFrom((IdentifiedObject)sourceCRS), stepComponents);
                stepSourceCRS = (CoordinateReferenceSystem)this.toAuthorityDefinition(CoordinateReferenceSystem.class, crs);
            }
            operation = this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, stepSourceCRS, null, select);
        }
        int endAtDimension = 0;
        int remainingSourceDimensions = select.getNumRow() - 1;
        int indexOfFinal = SubOperationInfo.indexOfFinal(infos);
        for (int i = 0; i < stepComponents.length; ++i) {
            SubOperationInfo info = infos[i];
            CoordinateReferenceSystem source = stepComponents[i];
            SingleCRS target = info.targetComponent;
            this.canStoreInCache &= info.canStoreInCache();
            stepComponents[info.targetComponentIndex] = target;
            Object stepTargetCRS = i >= indexOfFinal ? targetCRS : (info.isIdentity() ? stepSourceCRS : (stepComponents.length == 1 ? target : this.createCompoundCRS((CoordinateReferenceSystem)target, stepComponents)));
            int delta = source.getCoordinateSystem().getDimension();
            int firstAffectedCoordinate = endAtDimension;
            int numTrailingCoordinates = remainingSourceDimensions - (endAtDimension += delta);
            CoordinateOperation subOperation = info.operation;
            if ((firstAffectedCoordinate | numTrailingCoordinates) != 0) {
                SingleOperation op;
                Map<String, ?> properties = IdentifiedObjects.getProperties((IdentifiedObject)subOperation, new String[0]);
                if (AbstractCoordinateOperation.isSingleOperation(subOperation)) {
                    op = (SingleOperation)subOperation;
                } else {
                    MathTransform subTransform = subOperation.getMathTransform();
                    op = this.factorySIS.createSingleOperation(properties, subOperation.getSourceCRS(), subOperation.getTargetCRS(), null, new DefaultOperationMethod(subTransform), subTransform);
                }
                subOperation = new DefaultPassThroughOperation(properties, stepSourceCRS, (CoordinateReferenceSystem)stepTargetCRS, op, firstAffectedCoordinate, numTrailingCoordinates);
            }
            operation = this.concatenate(operation, subOperation);
            stepSourceCRS = stepTargetCRS;
            endAtDimension -= (delta -= target.getCoordinateSystem().getDimension());
            remainingSourceDimensions -= delta;
        }
        if (stepComponents.length < infos.length) {
            MatrixSIS m = SubOperationInfo.createConstantOperation(this.context, infos, stepSourceCRS.getCoordinateSystem().getDimension(), targetCRS.getCoordinateSystem().getDimension());
            operation = this.concatenate(operation, this.createFromAffineTransform(CONSTANTS, stepSourceCRS, targetCRS, null, m));
            for (int i = stepComponents.length; i < infos.length; ++i) {
                this.canStoreInCache &= infos[i].canStoreInCache();
            }
        }
        return CoordinateOperationFinder.asList(operation);
    }

    private CoordinateOperation createFromAffineTransform(Identifier typeOfChange, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Optional<? extends IdentifiedObject> finalDatum, Matrix matrix) throws FactoryException {
        MathTransform transform = this.factorySIS.getMathTransformFactory().createAffineTransform(matrix);
        Map<String, Object> properties = CoordinateOperationFinder.properties(typeOfChange);
        if (finalDatum != null) {
            finalDatum.flatMap(DatumOrEnsemble::getAccuracy).ifPresent(accuracy -> properties.put("coordinateOperationAccuracy", accuracy));
        }
        Class<Conversion> type = Conversion.class;
        if (CoordinateOperationFinder.isDatumChange(typeOfChange)) {
            type = Transformation.class;
        }
        return this.createFromMathTransform(properties, sourceCRS, targetCRS, transform, null, null, type);
    }

    private CoordinateReferenceSystem createCompoundCRS(CoordinateReferenceSystem template, CoordinateReferenceSystem[] components) throws FactoryException {
        EllipsoidalHeightCombiner c = new EllipsoidalHeightCombiner(this.factorySIS.crsFactory, this.factorySIS.csFactory, this.factory);
        CoordinateReferenceSystem crs = c.createCompoundCRS(this.derivedFrom((IdentifiedObject)template), components);
        return this.toAuthorityDefinition(CoordinateReferenceSystem.class, crs);
    }

    private CoordinateOperation concatenate(CoordinateOperation step1, CoordinateOperation step2) throws FactoryException {
        if (CoordinateOperationFinder.isIdentity(step1)) {
            return step2;
        }
        if (CoordinateOperationFinder.isIdentity(step2)) {
            return step1;
        }
        MathTransform mt1 = step1.getMathTransform();
        MathTransform mt2 = step2.getMathTransform();
        CoordinateReferenceSystem sourceCRS = step1.getSourceCRS();
        CoordinateReferenceSystem targetCRS = step2.getTargetCRS();
        CoordinateOperation main = null;
        boolean isAxisChange1 = CoordinateOperationFinder.canHide((Identifier)step1.getName());
        boolean isAxisChange2 = CoordinateOperationFinder.canHide((Identifier)step2.getName());
        if (isAxisChange1 && isAxisChange2 && CoordinateOperationFinder.isAffine(step1) && CoordinateOperationFinder.isAffine(step2)) {
            main = step2;
            if (main.getName() == IDENTITY && step1.getName() != IDENTITY) {
                main = step1;
            }
        } else {
            if (isAxisChange1 && mt1.getSourceDimensions() == mt1.getTargetDimensions()) {
                main = step2;
            }
            if (isAxisChange2 && mt2.getSourceDimensions() == mt2.getTargetDimensions()) {
                main = step1;
            }
        }
        if (AbstractCoordinateOperation.isSingleOperation(main)) {
            SingleOperation op = (SingleOperation)main;
            main = this.createFromMathTransform(new HashMap<String, Object>(IdentifiedObjects.getProperties((IdentifiedObject)main, new String[0])), sourceCRS, targetCRS, this.factorySIS.getMathTransformFactory().createConcatenatedTransform(mt1, mt2), op.getMethod(), op.getParameterValues(), CoordinateOperationFinder.typeOf((CoordinateOperation)op));
        } else {
            main = this.factorySIS.createConcatenatedOperation(CoordinateOperationFinder.defaultName(sourceCRS, targetCRS), sourceCRS, targetCRS, step1, step2);
        }
        if (main instanceof ConcatenatedOperation && main.getMathTransform().isIdentity()) {
            Class<Transformation> type = null;
            for (CoordinateOperation component : ((ConcatenatedOperation)main).getOperations()) {
                if (!(component instanceof Transformation)) continue;
                type = Transformation.class;
                break;
            }
            main = this.createFromMathTransform(new HashMap<String, Object>(IdentifiedObjects.getProperties((IdentifiedObject)main, new String[0])), main.getSourceCRS(), main.getTargetCRS(), main.getMathTransform(), null, null, type);
        }
        return main;
    }

    private CoordinateOperation concatenate(CoordinateOperation step1, CoordinateOperation step2, CoordinateOperation step3) throws FactoryException {
        if (CoordinateOperationFinder.isIdentity(step1)) {
            return this.concatenate(step2, step3);
        }
        if (CoordinateOperationFinder.isIdentity(step2)) {
            return this.concatenate(step1, step3);
        }
        if (CoordinateOperationFinder.isIdentity(step3)) {
            return this.concatenate(step1, step2);
        }
        if (CoordinateOperationFinder.canHide((Identifier)step1.getName())) {
            return this.concatenate(this.concatenate(step1, step2), step3);
        }
        if (CoordinateOperationFinder.canHide((Identifier)step3.getName())) {
            return this.concatenate(step1, this.concatenate(step2, step3));
        }
        Map<String, ?> properties = CoordinateOperationFinder.defaultName(step1.getSourceCRS(), step3.getTargetCRS());
        return this.factory.createConcatenatedOperation(properties, new CoordinateOperation[]{step1, step2, step3});
    }

    private static boolean isAffine(CoordinateOperation operation) {
        return IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)CoordinateOperations.getMethod(operation), "Affine");
    }

    private static boolean isIdentity(CoordinateOperation operation) {
        if (operation == null) {
            return true;
        }
        if (operation instanceof Conversion && operation.getMathTransform().isIdentity()) {
            return CoordinateOperations.wrapAroundChanges(operation).isEmpty();
        }
        return false;
    }

    private static boolean canHide(Identifier id) {
        return id == AXIS_CHANGES || id == IDENTITY;
    }

    private static Map<String, ?> properties(String name) {
        return Map.of("name", name);
    }

    private Map<String, ?> derivedFrom(IdentifiedObject object) {
        ReferenceIdentifier oldID = object.getName();
        Object p = this.identifierOfStepCRS.get(oldID);
        if (p instanceof Identifier) {
            oldID = (Identifier)p;
            p = this.identifierOfStepCRS.get(oldID);
        }
        int count = p != null ? (Integer)p + 1 : 1;
        NamedIdentifier newID = new NamedIdentifier(Citations.SIS, oldID.getCode() + " (step " + count + ")");
        this.identifierOfStepCRS.put((Identifier)newID, oldID);
        this.identifierOfStepCRS.put((Identifier)oldID, count);
        Map<String, Object> properties = CoordinateOperationFinder.properties((Identifier)newID);
        properties.put("remarks", Vocabulary.formatInternational((short)58, (Object)this.label(object)));
        return properties;
    }

    private static Map<String, ?> defaultName(CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        return CoordinateOperationFinder.properties(new CRSPair(source, target).toString());
    }

    private static List<CoordinateOperation> asList(CoordinateOperation operation) {
        ArrayList<CoordinateOperation> operations = new ArrayList<CoordinateOperation>(1);
        operations.add(operation);
        return operations;
    }

    final String notFoundMessage(CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        Locale locale = this.getLocale();
        return Resources.forLocale(locale).getString((short)13, CRSPair.label((IdentifiedObject)source, locale), CRSPair.label((IdentifiedObject)target, locale));
    }

    private String canNotInvert(GeneralDerivedCRS crs) {
        Locale locale = this.getLocale();
        return Resources.forLocale(locale).getString((short)52, CRSPair.label((IdentifiedObject)crs.getConversionFromBase(), locale));
    }

    final boolean canStoreInCache() {
        return this.canStoreInCache;
    }
}

