/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Iterator;
import java.util.Map;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.PropertyMap;
import org.apache.sis.metadata.ValueExistencePolicy;

final class ValueMap
extends PropertyMap<Object> {
    final Object metadata;
    final ValueExistencePolicy valuePolicy;

    ValueMap(Object metadata, PropertyAccessor accessor, KeyNamePolicy keyPolicy, ValueExistencePolicy valuePolicy) {
        super(accessor, keyPolicy);
        this.metadata = metadata;
        this.valuePolicy = valuePolicy;
    }

    @Override
    public boolean isEmpty() {
        return this.accessor.count(this.metadata, this.valuePolicy, 0) == 0;
    }

    @Override
    public int size() {
        return this.accessor.count(this.metadata, this.valuePolicy, 1);
    }

    @Override
    final boolean contains(int index) {
        if (this.valuePolicy == ValueExistencePolicy.ALL) {
            return super.contains(index);
        }
        return !this.valuePolicy.isSkipped(this.accessor.get(index, this.metadata));
    }

    @Override
    final Object getReflectively(int index) {
        Object value = this.accessor.get(index, this.metadata);
        return this.valuePolicy.isSkipped(value) ? null : value;
    }

    @Override
    final Object setReflectively(int index, Object value) {
        Object old = this.accessor.set(index, this.metadata, value, 1);
        return this.valuePolicy.isSkipped(old) ? null : old;
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        int index = this.accessor.indexOf(key, true);
        Object old = this.accessor.get(index, this.metadata);
        if (old == null || this.valuePolicy.isSkipped(old)) {
            return this.accessor.set(index, this.metadata, value, 0);
        }
        return old;
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        for (Map.Entry<String, ?> e : map.entrySet()) {
            this.accessor.set(this.accessor.indexOf(e.getKey(), true), this.metadata, e.getValue(), 0);
        }
    }

    @Override
    final Iterator<Map.Entry<String, Object>> iterator() {
        return new PropertyMap.ReflectiveIterator();
    }
}

