/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.processing.isoline;

import java.awt.Shape;
import java.util.AbstractList;
import java.util.NavigableMap;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.sis.image.processing.isoline.Isolines;
import org.apache.sis.util.resources.Errors;

final class Result
extends AbstractList<NavigableMap<Double, Shape>> {
    private Future<Isolines[]> task;
    private NavigableMap<Double, Shape>[] isolines;

    Result(Future<Isolines[]> task) {
        this.task = task;
    }

    private NavigableMap<Double, Shape>[] isolines() {
        if (this.isolines == null) {
            if (this.task == null) {
                throw new CompletionException(Errors.format((short)3), null);
            }
            try {
                this.isolines = Isolines.toArray(this.task.get());
                this.task = null;
            }
            catch (InterruptedException e) {
                throw new CompletionException(Errors.format((short)92), e);
            }
            catch (ExecutionException e) {
                this.task = null;
                throw new CompletionException(Errors.format((short)3), e.getCause());
            }
        }
        return this.isolines;
    }

    @Override
    public int size() {
        return this.isolines().length;
    }

    @Override
    public NavigableMap<Double, Shape> get(int band) {
        return this.isolines()[band];
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.isolines().clone();
    }
}

