/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.internal.shared;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import org.apache.sis.image.DataType;
import org.apache.sis.image.internal.shared.ColorModelFactory;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

public final class ColorModelBuilder {
    private static final int UNSPECIFIED_ALPHA = -2;
    private final ColorSpace colorSpace;
    private DataType dataType;
    private int[] bitsPerSample;
    private int defaultBitsPerSample;
    private int[] componentMasks;
    private int visibleBand;
    private int alphaBand;
    private boolean isAlphaPremultiplied;
    private NumberRange<?> sampleValuesRange;

    public ColorModelBuilder() {
        this(true);
    }

    public ColorModelBuilder(boolean isRGB) {
        this.colorSpace = ColorSpace.getInstance(isRGB ? 1000 : 1003);
        this.defaultBitsPerSample = 8;
        this.alphaBand = -2;
    }

    public ColorModelBuilder dataType(DataType type) {
        this.dataType = type;
        return this;
    }

    public ColorModelBuilder bitsPerSample(int[] numBits) {
        this.defaultBitsPerSample = 8;
        this.bitsPerSample = null;
        if (numBits != null) {
            for (int n : numBits) {
                if (n == 8) continue;
                this.bitsPerSample = numBits;
                break;
            }
        }
        return this;
    }

    public ColorModelBuilder bitsPerSample(int numBits) {
        ArgumentChecks.ensureBetween((String)"bitsPerSample", (int)1, (int)32, (int)numBits);
        this.defaultBitsPerSample = numBits;
        this.bitsPerSample = null;
        return this;
    }

    private int getBitsPerSample(int band, int max) {
        int numBits;
        if (this.bitsPerSample != null && band < this.bitsPerSample.length && (numBits = this.bitsPerSample[band]) != 0) {
            ArgumentChecks.ensureBetween((String)"bitsPerSample", (int)1, (int)max, (int)numBits);
            return numBits;
        }
        return this.defaultBitsPerSample;
    }

    public ColorModelBuilder componentMasks(int ... masks) {
        if (masks != null) {
            int i = masks.length;
            while (--i >= 0) {
                if (masks[i] == 0) continue;
                masks = ArraysExt.resize((int[])masks, (int)(i + 1));
                break;
            }
        }
        this.componentMasks = masks;
        return this;
    }

    public ColorModelBuilder visibleBand(int index, NumberRange<?> range) {
        ArgumentChecks.ensurePositive((String)"visibleBand", (int)index);
        this.visibleBand = index;
        this.sampleValuesRange = range;
        return this;
    }

    public ColorModelBuilder alphaBand(int index) {
        this.alphaBand = Math.max(index, -1);
        return this;
    }

    public ColorModelBuilder alphaPremultiplied(boolean p) {
        this.isAlphaPremultiplied = p;
        return this;
    }

    private static int[] orEmpty(int[] numBits) {
        return numBits != null ? numBits : ArraysExt.EMPTY_INT;
    }

    private int numBands() {
        int numBands = Math.max(ColorModelBuilder.orEmpty(this.bitsPerSample).length, ColorModelBuilder.orEmpty(this.componentMasks).length);
        if (numBands == 0) {
            numBands = this.colorSpace.getNumComponents();
            if (this.alphaBand >= 0) {
                ArgumentChecks.ensureBetween((String)"alphaBand", (int)0, (int)numBands, (int)this.alphaBand);
                ++numBands;
            }
        }
        return numBands;
    }

    private int dataType(int numBits) {
        if (this.dataType != null) {
            return this.dataType.toDataBufferType();
        }
        return numBits <= 8 ? 0 : (numBits <= 16 ? 1 : 3);
    }

    public ColorModel createPackedRGB() {
        int numBits = 0;
        int[] masks = this.componentMasks;
        if (masks == null) {
            int numBands = this.numBands();
            if (numBands == 4 && this.alphaBand == 3 && !this.isAlphaPremultiplied) {
                return ColorModel.getRGBdefault();
            }
            masks = new int[numBands];
            int i = numBands;
            while (--i >= -1) {
                if (i == this.alphaBand) continue;
                int band = i;
                if (band >= 0 || (band = this.alphaBand) >= 0) {
                    int n = this.getBitsPerSample(band, Math.min(8, 32 - numBits));
                    masks[i] = (1 << n) - 1 << numBits;
                    numBits += n;
                    continue;
                }
                break;
            }
        } else {
            int i = masks.length;
            while (--i >= 0) {
                numBits |= masks[i];
            }
            numBits = 32 - Integer.numberOfLeadingZeros(numBits);
        }
        return ColorModelFactory.unique(new DirectColorModel(this.colorSpace, numBits, masks[0], masks[1], masks[2], masks[3], this.isAlphaPremultiplied, this.dataType(numBits)));
    }

    public ColorModel createBandedRGB() {
        boolean hasAlpha;
        int numBands = this.numBands();
        boolean bl = hasAlpha = this.alphaBand >= 0;
        if (hasAlpha && this.alphaBand != numBands - 1) {
            throw new IllegalArgumentException("Alpha channel must be after the color components.");
        }
        int[] numBits = ArraysExt.resize((int[])ColorModelBuilder.orEmpty(this.bitsPerSample), (int)numBands);
        int maxSize = 0;
        for (int i = 0; i < numBands; ++i) {
            if (numBits[i] == 0) {
                if (numBits == this.bitsPerSample) {
                    numBits = (int[])numBits.clone();
                }
                numBits[i] = this.defaultBitsPerSample;
            }
            maxSize = Math.max(maxSize, numBits[i]);
        }
        return ColorModelFactory.unique(new ComponentColorModel(this.colorSpace, numBits, hasAlpha, this.isAlphaPremultiplied, hasAlpha ? 3 : 1, this.dataType(maxSize)));
    }

    public ColorModel createRGB(SampleModel targetModel) {
        block11: {
            if (DataType.isInteger(targetModel) && this.colorSpace.getType() == 5) {
                int numBands = targetModel.getNumBands();
                if (this.alphaBand == -2) {
                    switch (numBands) {
                        case 3: {
                            this.alphaBand = -1;
                            break;
                        }
                        case 4: {
                            this.alphaBand = 3;
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                } else {
                    if (this.bitsPerSample == null) {
                        this.bitsPerSample(targetModel.getSampleSize());
                    }
                    if (targetModel.getNumDataElements() != 1) {
                        return this.createBandedRGB();
                    }
                    for (int i = 0; i < numBands; ++i) {
                        if (this.getBitsPerSample(i, 32) <= 8) {
                            continue;
                        }
                        break block11;
                    }
                    return this.createPackedRGB();
                }
            }
        }
        return ColorModelFactory.createGrayScale(targetModel, this.visibleBand, this.sampleValuesRange);
    }
}

