/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.base;

import java.lang.reflect.Field;
import java.util.function.Supplier;
import javax.imageio.plugins.tiff.BaselineTIFFTagSet;
import javax.imageio.plugins.tiff.ExifGPSTagSet;
import javax.imageio.plugins.tiff.ExifInteroperabilityTagSet;
import javax.imageio.plugins.tiff.ExifParentTIFFTagSet;
import javax.imageio.plugins.tiff.ExifTIFFTagSet;
import javax.imageio.plugins.tiff.FaxTIFFTagSet;
import javax.imageio.plugins.tiff.GeoTIFFTagSet;
import javax.imageio.plugins.tiff.TIFFTag;
import javax.imageio.plugins.tiff.TIFFTagSet;

public final class Tags {
    public static final short XML_Packet = 700;
    public static final short PhotoshopImageResources = -31159;
    public static final short GEO_METADATA = -14627;
    public static final short GDAL_METADATA = -23424;
    public static final short GDAL_NODATA = -23423;
    private static final Supplier<TIFFTagSet>[] TAG_SETS = new Supplier[]{BaselineTIFFTagSet::getInstance, GeoTIFFTagSet::getInstance, ExifGPSTagSet::getInstance, ExifParentTIFFTagSet::getInstance, ExifTIFFTagSet::getInstance, ExifInteroperabilityTagSet::getInstance, FaxTIFFTagSet::getInstance};

    private Tags() {
    }

    public static String name(short tag) {
        int ti = Short.toUnsignedInt(tag);
        for (Supplier<TIFFTagSet> s : TAG_SETS) {
            TIFFTag t = s.get().getTag(ti);
            if (t == null) continue;
            return t.getName();
        }
        try {
            for (Field field : Tags.class.getFields()) {
                if (field.getType() != Short.TYPE || field.getShort(null) != tag) continue;
                return field.getName();
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        return "Tag #" + Integer.toHexString(ti);
    }
}

