/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.SyncFailedException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.zip.CRC32;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.ScanHandle;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.log.LogScan;
import org.apache.derby.iapi.store.raw.log.Logger;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.store.replication.master.MasterFactory;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.raw.log.CheckpointOperation;
import org.apache.derby.impl.store.raw.log.FileLogger;
import org.apache.derby.impl.store.raw.log.FlushedScan;
import org.apache.derby.impl.store.raw.log.FlushedScanHandle;
import org.apache.derby.impl.store.raw.log.LogAccessFile;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.Scan;
import org.apache.derby.impl.store.raw.log.StreamLogScan;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.io.WritableStorageFactory;
import org.apache.derby.shared.common.error.ErrorStringBuilder;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.info.ProductVersionHolder;

public final class LogToFile
implements LogFactory,
ModuleControl,
ModuleSupportable,
Serviceable,
PrivilegedExceptionAction<Object> {
    private static final long INT_LENGTH = 4L;
    private static int fid = 128;
    public static final int LOG_FILE_HEADER_SIZE = 24;
    protected static final int LOG_FILE_HEADER_PREVIOUS_LOG_INSTANT_OFFSET = 16;
    public static final int LOG_RECORD_OVERHEAD = 16;
    public static final String DBG_FLAG = null;
    public static final String DUMP_LOG_ONLY = null;
    public static final String DUMP_LOG_FROM_LOG_FILE = null;
    protected static final String LOG_SYNC_STATISTICS = "LogSyncStatistics";
    private static final int OBSOLETE_LOG_VERSION_NUMBER = 9;
    private static final int DEFAULT_LOG_SWITCH_INTERVAL = 0x100000;
    private static final int LOG_SWITCH_INTERVAL_MIN = 100000;
    private static final int LOG_SWITCH_INTERVAL_MAX = 0x8000000;
    private static final int CHECKPOINT_INTERVAL_MIN = 100000;
    private static final int CHECKPOINT_INTERVAL_MAX = 0x8000000;
    private static final int DEFAULT_CHECKPOINT_INTERVAL = 0xA00000;
    private static final int DEFAULT_LOG_BUFFER_SIZE = 32768;
    private static final int LOG_BUFFER_SIZE_MIN = 8192;
    private static final int LOG_BUFFER_SIZE_MAX = 0x8000000;
    private int logBufferSize = 32768;
    private static final byte IS_BETA_FLAG = 1;
    private static final byte IS_DURABILITY_TESTMODE_NO_SYNC_FLAG = 2;
    private static boolean wasDBInDurabilityTestModeNoSync = false;
    private static final String DEFAULT_LOG_ARCHIVE_DIRECTORY = "DEFAULT";
    private int logSwitchInterval = 0x100000;
    private int checkpointInterval = 0xA00000;
    String dataDirectory;
    private WritableStorageFactory logStorageFactory;
    private boolean logBeingFlushed;
    protected LogAccessFile logOut;
    private StorageRandomAccessFile firstLog = null;
    protected long endPosition = -1L;
    long lastFlush = 0L;
    long logFileNumber = -1L;
    long bootTimeLogFileNumber = -1L;
    long firstLogFileNumber = -1L;
    private long maxLogFileNumber = Integer.MAX_VALUE;
    private CheckpointOperation currentCheckpoint;
    long checkpointInstant;
    private DaemonService checkpointDaemon;
    private int myClientNumber;
    private volatile boolean checkpointDaemonCalled;
    private long logWrittenFromLastCheckPoint = 0L;
    private RawStoreFactory rawStoreFactory;
    protected DataFactory dataFactory;
    protected boolean ReadOnlyDB;
    private MasterFactory masterFactory;
    private boolean inReplicationMasterMode = false;
    private boolean inReplicationSlaveMode = false;
    private volatile StandardException replicationSlaveException = null;
    private boolean inReplicationSlavePreMode = false;
    private Object slaveRecoveryMonitor;
    private long allowedToReadFileNumber = -1L;
    private boolean keepAllLogs;
    private boolean databaseEncrypted;
    private boolean recoveryNeeded = true;
    private boolean inCheckpoint = false;
    private boolean inRedo = false;
    private boolean inLogSwitch = false;
    private boolean stopped = false;
    String logDevice;
    private boolean logNotSynced = false;
    private volatile boolean logArchived = false;
    private boolean logSwitchRequired = false;
    int test_logWritten = 0;
    int test_numRecordToFillLog = -1;
    private int mon_flushCalls;
    private int mon_syncCalls;
    private int mon_numLogFlushWaits;
    private boolean mon_LogSyncStatistics;
    private int mon_numBytesToLog;
    protected volatile StandardException corrupt;
    private boolean isFrozen;
    ProductVersionHolder jbmsVersion;
    private int onDiskMajorVersion;
    private int onDiskMinorVersion;
    private boolean onDiskBeta;
    private CRC32 checksum = new CRC32();
    private boolean isWriteSynced = false;
    private boolean jvmSyncErrorChecked = false;
    private volatile long logFileToBackup;
    private volatile boolean backupInProgress = false;
    public static final String TEST_LOG_SWITCH_LOG = null;
    public static final String TEST_LOG_INCOMPLETE_LOG_WRITE = null;
    public static final String TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES = null;
    public static final String TEST_LOG_FULL = null;
    public static final String TEST_SWITCH_LOG_FAIL1 = null;
    public static final String TEST_SWITCH_LOG_FAIL2 = null;
    public static final String TEST_RECORD_TO_FILL_LOG = null;
    public static final String TEST_MAX_LOGFILE_NUMBER = null;
    private int action;
    private StorageFile activeFile;
    private File toFile;
    private String activePerms;

    public int getTypeFormatId() {
        return 128;
    }

    public LogToFile() {
        this.keepAllLogs = PropertyUtil.getSystemBoolean("derby.storage.keepTransactionLog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StandardException markCorrupt(StandardException standardException) {
        boolean bl = false;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.corrupt == null && standardException != null) {
                this.corrupt = standardException;
                bl = true;
            }
        }
        if (this.corrupt == standardException) {
            this.logErrMsg(this.corrupt);
        }
        if (bl) {
            logToFile = this;
            synchronized (logToFile) {
                this.stopped = true;
                if (this.logOut != null) {
                    try {
                        this.logOut.corrupt();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.logOut = null;
            }
            if (this.dataFactory != null) {
                this.dataFactory.markCorrupt(null);
            }
        }
        return standardException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCorrupt() throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.corrupt != null) {
                throw StandardException.newException((String)"XSLAA.D", (Throwable)this.corrupt, (Object[])new Object[0]);
            }
        }
    }

    @Override
    public Logger getLogger() {
        if (this.ReadOnlyDB) {
            return null;
        }
        return new FileLogger(this);
    }

    @Override
    public void setRawStoreFactory(RawStoreFactory rawStoreFactory) {
        this.rawStoreFactory = rawStoreFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(DataFactory dataFactory, TransactionFactory transactionFactory) throws StandardException {
        Object object;
        this.checkCorrupt();
        this.dataFactory = dataFactory;
        if (this.firstLog != null) {
            this.logOut = new LogAccessFile(this, this.firstLog, this.logBufferSize);
        }
        if (this.inReplicationSlaveMode) {
            object = this.slaveRecoveryMonitor;
            synchronized (object) {
                while (this.inReplicationSlaveMode && this.allowedToReadFileNumber < this.bootTimeLogFileNumber) {
                    if (this.replicationSlaveException != null) {
                        throw this.replicationSlaveException;
                    }
                    try {
                        this.slaveRecoveryMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
            }
        }
        if (this.recoveryNeeded) {
            try {
                StorageFile storageFile;
                RawTransaction rawTransaction;
                object = (FileLogger)this.getLogger();
                if (this.checkpointInstant != 0L) {
                    this.currentCheckpoint = this.findCheckpoint(this.checkpointInstant, (FileLogger)object);
                }
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                StreamLogScan streamLogScan = null;
                if (this.currentCheckpoint != null) {
                    rawTransaction = null;
                    transactionFactory.useTransactionTable((Formatable)((Object)rawTransaction));
                    l = this.currentCheckpoint.redoLWM();
                    l2 = this.currentCheckpoint.undoLWM();
                    if (rawTransaction != null) {
                        l3 = this.checkpointInstant;
                    }
                    this.firstLogFileNumber = LogCounter.getLogFileNumber(l);
                    if (LogCounter.getLogFileNumber(l2) < this.firstLogFileNumber) {
                        this.firstLogFileNumber = LogCounter.getLogFileNumber(l2);
                    }
                    streamLogScan = (StreamLogScan)this.openForwardsScan(l2, (LogInstant)null);
                } else {
                    transactionFactory.useTransactionTable(null);
                    long l4 = LogCounter.makeLogInstantAsLong(this.bootTimeLogFileNumber, 24L);
                    this.firstLogFileNumber = this.bootTimeLogFileNumber;
                    streamLogScan = (StreamLogScan)this.openForwardsScan(l4, (LogInstant)null);
                }
                rawTransaction = transactionFactory.startTransaction(this.rawStoreFactory, LogToFile.getContextService().getCurrentContextManager(), "UserTransaction");
                rawTransaction.recoveryTransaction();
                this.inRedo = true;
                long l5 = ((FileLogger)object).redo(rawTransaction, transactionFactory, streamLogScan, l, l3);
                this.inRedo = false;
                this.logFileNumber = this.bootTimeLogFileNumber;
                StorageRandomAccessFile storageRandomAccessFile = null;
                if (l5 == 0L) {
                    Monitor.logTextMessage("L007", new Object[0]);
                    storageFile = this.getLogFileName(this.logFileNumber);
                    if (this.privExists(storageFile) && !this.privDelete(storageFile)) {
                        storageFile = this.getLogFileName(++this.logFileNumber);
                    }
                    IOException iOException = null;
                    try {
                        storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rw");
                    }
                    catch (IOException iOException2) {
                        storageRandomAccessFile = null;
                        iOException = iOException2;
                    }
                    if (storageRandomAccessFile == null || !this.privCanWrite(storageFile)) {
                        if (storageRandomAccessFile != null) {
                            storageRandomAccessFile.close();
                        }
                        storageRandomAccessFile = null;
                        Monitor.logTextMessage("L022", new Object[0]);
                        if (iOException != null) {
                            Monitor.logThrowable(iOException);
                        }
                        this.ReadOnlyDB = true;
                    } else {
                        try {
                            if (!this.initLogFile(storageRandomAccessFile, this.logFileNumber, 0L)) {
                                throw this.markCorrupt(StandardException.newException((String)"XSLAQ.D", (Object[])new Object[]{storageFile.getPath()}));
                            }
                        }
                        catch (IOException iOException3) {
                            throw this.markCorrupt(StandardException.newException((String)"XSLA2.D", (Throwable)iOException3, (Object[])new Object[0]));
                        }
                        this.setEndPosition(storageRandomAccessFile.getFilePointer());
                        this.lastFlush = this.endPosition;
                        if (this.isWriteSynced) {
                            this.preAllocateNewLogFile(storageRandomAccessFile);
                            storageRandomAccessFile.close();
                            storageRandomAccessFile = this.openLogFileInWriteMode(storageFile);
                            storageRandomAccessFile.seek(this.endPosition);
                        }
                        this.logSwitchRequired = false;
                    }
                } else {
                    this.logFileNumber = LogCounter.getLogFileNumber(l5);
                    this.ReadOnlyDB = dataFactory.isReadOnly();
                    storageFile = this.getLogFileName(this.logFileNumber);
                    if (!this.ReadOnlyDB) {
                        IOException iOException = null;
                        try {
                            storageRandomAccessFile = this.isWriteSynced ? this.openLogFileInWriteMode(storageFile) : this.privRandomAccessFile(storageFile, "rw");
                        }
                        catch (IOException iOException4) {
                            storageRandomAccessFile = null;
                            iOException = iOException4;
                        }
                        if (storageRandomAccessFile == null || !this.privCanWrite(storageFile)) {
                            if (storageRandomAccessFile != null) {
                                storageRandomAccessFile.close();
                            }
                            storageRandomAccessFile = null;
                            Monitor.logTextMessage("L022", new Object[0]);
                            if (iOException != null) {
                                Monitor.logThrowable(iOException);
                            }
                            this.ReadOnlyDB = true;
                        }
                    }
                    if (!this.ReadOnlyDB) {
                        this.setEndPosition(LogCounter.getLogFilePosition(l5));
                        if (streamLogScan.isLogEndFuzzy()) {
                            storageRandomAccessFile.seek(this.endPosition);
                            long l6 = storageRandomAccessFile.length();
                            Monitor.logTextMessage("L010", storageFile, this.endPosition, l6);
                            long l7 = (l6 - this.endPosition) / (long)this.logBufferSize;
                            int n = (int)((l6 - this.endPosition) % (long)this.logBufferSize);
                            byte[] byArray = new byte[this.logBufferSize];
                            while (l7-- > 0L) {
                                storageRandomAccessFile.write(byArray);
                            }
                            if (n != 0) {
                                storageRandomAccessFile.write(byArray, 0, n);
                            }
                            if (!this.isWriteSynced) {
                                this.syncFile(storageRandomAccessFile);
                            }
                        }
                        this.lastFlush = this.endPosition;
                        storageRandomAccessFile.seek(this.endPosition);
                    }
                }
                if (storageRandomAccessFile != null) {
                    if (this.logOut != null) {
                        this.logOut.close();
                    }
                    this.logOut = new LogAccessFile(this, storageRandomAccessFile, this.logBufferSize);
                }
                if (this.logSwitchRequired) {
                    this.switchLogFile();
                }
                boolean bl = transactionFactory.noActiveUpdateTransaction();
                if (this.ReadOnlyDB && !bl) {
                    throw StandardException.newException((String)"XSLAF.D", (Object[])new Object[0]);
                }
                if (!bl) {
                    transactionFactory.rollbackAllTransactions(rawTransaction, this.rawStoreFactory);
                }
                transactionFactory.handlePreparedXacts(this.rawStoreFactory);
                rawTransaction.close();
                this.dataFactory.postRecovery();
                transactionFactory.resetTranId();
                if (!this.ReadOnlyDB) {
                    boolean bl2 = true;
                    if (this.currentCheckpoint != null && bl && l != 0L && l2 != 0L && this.logFileNumber == LogCounter.getLogFileNumber(l) && this.logFileNumber == LogCounter.getLogFileNumber(l2) && this.endPosition < LogCounter.getLogFilePosition(l) + 1000L) {
                        bl2 = false;
                    }
                    if (bl2 && !this.checkpoint(this.rawStoreFactory, dataFactory, transactionFactory, false)) {
                        this.flush(this.logFileNumber, this.endPosition);
                    }
                }
                ((FileLogger)object).close();
                this.recoveryNeeded = false;
            }
            catch (IOException iOException) {
                throw this.markCorrupt(StandardException.newException((String)"XSLA2.D", (Throwable)iOException, (Object[])new Object[0]));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw this.markCorrupt(StandardException.newException((String)"XSLA3.D", (Throwable)classNotFoundException, (Object[])new Object[0]));
            }
            catch (StandardException standardException) {
                throw this.markCorrupt(standardException);
            }
            catch (Throwable throwable) {
                throw this.markCorrupt(StandardException.newException((String)"XSLA6.D", (Throwable)throwable, (Object[])new Object[0]));
            }
        }
        transactionFactory.useTransactionTable(null);
        transactionFactory.resetTranId();
        this.checkpointDaemon = this.rawStoreFactory.getDaemon();
        if (this.checkpointDaemon != null) {
            this.myClientNumber = this.checkpointDaemon.subscribe(this, true);
            this.dataFactory.setupCacheCleaner(this.checkpointDaemon);
        }
    }

    @Override
    public boolean checkpoint(RawStoreFactory rawStoreFactory, DataFactory dataFactory, TransactionFactory transactionFactory, boolean bl) throws StandardException {
        if (this.inReplicationSlavePreMode) {
            return true;
        }
        boolean bl2 = this.checkpointWithTran(null, rawStoreFactory, dataFactory, transactionFactory, bl);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkpointWithTran(RawTransaction rawTransaction, RawStoreFactory rawStoreFactory, DataFactory dataFactory, TransactionFactory transactionFactory, boolean bl) throws StandardException {
        long l;
        if (this.logOut == null) {
            return false;
        }
        boolean bl2 = true;
        do {
            LogToFile logToFile = this;
            synchronized (logToFile) {
                if (this.corrupt != null) {
                    throw StandardException.newException((String)"XSLAA.D", (Throwable)this.corrupt, (Object[])new Object[0]);
                }
                l = this.endPosition;
                if (!this.inCheckpoint) {
                    this.inCheckpoint = true;
                    break;
                }
                if (bl) {
                    while (this.inCheckpoint) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            InterruptStatus.setInterrupted();
                        }
                    }
                } else {
                    bl2 = false;
                }
            }
        } while (bl2);
        if (!bl2) {
            return false;
        }
        boolean bl3 = rawTransaction == null;
        try {
            long l2;
            Formatable formatable;
            LogCounter logCounter;
            long l3;
            if (l > (long)this.logSwitchInterval) {
                this.switchLogFile();
                this.logWrittenFromLastCheckPoint = 0L;
            } else {
                this.logWrittenFromLastCheckPoint = -this.endPosition;
            }
            if (bl3) {
                rawTransaction = transactionFactory.startInternalTransaction(rawStoreFactory, LogToFile.getContextService().getCurrentContextManager());
            }
            Object object = this;
            synchronized (object) {
                l3 = this.currentInstant();
                logCounter = new LogCounter(l3);
                formatable = (LogCounter)transactionFactory.firstUpdateInstant();
                l2 = formatable == null ? l3 : formatable.getValueAsLong();
            }
            dataFactory.checkpoint();
            object = transactionFactory.getTransactionTable();
            formatable = new CheckpointOperation(l3, l2, (Formatable)object);
            rawTransaction.logAndDo((Loggable)formatable);
            LogCounter logCounter2 = (LogCounter)rawTransaction.getLastLogInstant();
            if (logCounter2 == null) {
                throw StandardException.newException((String)"XSLAI.D", (Object[])new Object[0]);
            }
            this.flush(logCounter2);
            rawTransaction.commit();
            if (bl3) {
                rawTransaction.close();
                rawTransaction = null;
            }
            if (!this.writeControlFile(this.getControlFileName(), logCounter2.getValueAsLong())) {
                throw StandardException.newException((String)"XSLAE.D", (Object[])new Object[]{this.getControlFileName()});
            }
            this.currentCheckpoint = formatable;
            if (!this.logArchived()) {
                this.truncateLog(this.currentCheckpoint);
            }
            if (!this.backupInProgress) {
                dataFactory.removeDroppedContainerFileStubs(logCounter);
            }
        }
        catch (IOException iOException) {
            throw this.markCorrupt(StandardException.newException((String)"XSLA2.D", (Throwable)iOException, (Object[])new Object[0]));
        }
        finally {
            LogToFile logToFile = this;
            synchronized (logToFile) {
                this.inCheckpoint = false;
                this.notifyAll();
            }
            if (rawTransaction != null && bl3) {
                try {
                    rawTransaction.commit();
                    rawTransaction.close();
                }
                catch (StandardException standardException) {
                    throw this.markCorrupt(StandardException.newException((String)"XSLA3.D", (Throwable)standardException, (Object[])new Object[0]));
                }
            }
        }
        return true;
    }

    @Override
    public void flush(LogInstant logInstant) throws StandardException {
        long l;
        long l2;
        if (logInstant == null) {
            l2 = 0L;
            l = 0L;
        } else {
            LogCounter logCounter = (LogCounter)logInstant;
            l2 = logCounter.getLogFileNumber();
            l = logCounter.getLogFilePosition();
        }
        this.flush(l2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() throws StandardException {
        long l;
        long l2;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            l2 = this.logFileNumber;
            l = this.endPosition;
        }
        this.flush(l2, l);
    }

    private boolean verifyLogFormat(StorageFile storageFile, long l) throws StandardException {
        boolean bl = false;
        try {
            StorageRandomAccessFile storageRandomAccessFile = this.privRandomAccessFile(storageFile, "r");
            bl = this.verifyLogFormat(storageRandomAccessFile, l);
            storageRandomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private boolean verifyLogFormat(StorageRandomAccessFile storageRandomAccessFile, long l) throws StandardException {
        try {
            storageRandomAccessFile.seek(0L);
            int n = storageRandomAccessFile.readInt();
            int n2 = storageRandomAccessFile.readInt();
            long l2 = storageRandomAccessFile.readLong();
            if (n != fid || l2 != l) {
                throw StandardException.newException((String)"XSLAC.D", (Object[])new Object[]{this.dataDirectory});
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException((String)"XSLAM.D", (Throwable)iOException, (Object[])new Object[]{this.dataDirectory});
        }
        return true;
    }

    private boolean initLogFile(StorageRandomAccessFile storageRandomAccessFile, long l, long l2) throws IOException, StandardException {
        if (storageRandomAccessFile.length() != 0L) {
            return false;
        }
        storageRandomAccessFile.seek(0L);
        storageRandomAccessFile.writeInt(fid);
        storageRandomAccessFile.writeInt(9);
        storageRandomAccessFile.writeLong(l);
        storageRandomAccessFile.writeLong(l2);
        this.syncFile(storageRandomAccessFile);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchLogFile() throws StandardException {
        boolean bl = false;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            block27: {
                while (this.logBeingFlushed | this.isFrozen) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
                if (this.endPosition == 24L) {
                    return;
                }
                StorageFile storageFile = this.getLogFileName(this.logFileNumber + 1L);
                if (this.logFileNumber + 1L >= this.maxLogFileNumber) {
                    throw StandardException.newException((String)"XSLAK.D", (Object[])new Object[]{this.maxLogFileNumber});
                }
                StorageRandomAccessFile storageRandomAccessFile = null;
                try {
                    if (this.privExists(storageFile) && !this.privDelete(storageFile)) {
                        this.logErrMsg(MessageService.getTextMessage((String)"L015", (Object[])new Object[]{storageFile.getPath()}));
                        return;
                    }
                    try {
                        storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rw");
                    }
                    catch (IOException iOException) {
                        storageRandomAccessFile = null;
                    }
                    if (storageRandomAccessFile == null || !this.privCanWrite(storageFile)) {
                        if (storageRandomAccessFile != null) {
                            storageRandomAccessFile.close();
                        }
                        storageRandomAccessFile = null;
                        return;
                    }
                    if (this.initLogFile(storageRandomAccessFile, this.logFileNumber + 1L, LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition))) {
                        bl = true;
                        this.logOut.writeEndMarker(0);
                        this.setEndPosition(this.endPosition + 4L);
                        this.inLogSwitch = true;
                        this.flush(this.logFileNumber, this.endPosition);
                        this.logOut.close();
                        this.logWrittenFromLastCheckPoint += this.endPosition;
                        this.setEndPosition(storageRandomAccessFile.getFilePointer());
                        this.lastFlush = this.endPosition;
                        if (this.isWriteSynced) {
                            this.preAllocateNewLogFile(storageRandomAccessFile);
                            storageRandomAccessFile.close();
                            storageRandomAccessFile = this.openLogFileInWriteMode(storageFile);
                            storageRandomAccessFile.seek(this.endPosition);
                        }
                        this.logOut = new LogAccessFile(this, storageRandomAccessFile, this.logBufferSize);
                        storageRandomAccessFile = null;
                        ++this.logFileNumber;
                    } else {
                        storageRandomAccessFile.close();
                        storageRandomAccessFile = null;
                        if (this.privExists(storageFile)) {
                            this.privDelete(storageFile);
                        }
                        this.logErrMsg(MessageService.getTextMessage((String)"L016", (Object[])new Object[]{storageFile.getPath()}));
                        storageFile = null;
                    }
                }
                catch (IOException iOException) {
                    this.inLogSwitch = false;
                    this.logErrMsg(MessageService.getTextMessage((String)"L017", (Object[])new Object[]{storageFile.getPath(), iOException.toString()}));
                    try {
                        if (storageRandomAccessFile != null) {
                            storageRandomAccessFile.close();
                            storageRandomAccessFile = null;
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    if (storageFile != null && this.privExists(storageFile)) {
                        this.privDelete(storageFile);
                        storageFile = null;
                    }
                    if (!bl) break block27;
                    this.logOut = null;
                    throw this.markCorrupt(StandardException.newException((String)"XSLA2.D", (Throwable)iOException, (Object[])new Object[0]));
                }
            }
            if (this.inReplicationSlaveMode) {
                this.allowedToReadFileNumber = this.logFileNumber - 1L;
                Object object = this.slaveRecoveryMonitor;
                synchronized (object) {
                    this.slaveRecoveryMonitor.notify();
                }
            }
            this.inLogSwitch = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer(long l, long l2) throws IOException, StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (l < this.logFileNumber) {
                return;
            }
            if (l2 < this.lastFlush) {
                return;
            }
            this.logOut.flushLogAccessFile();
        }
    }

    private void truncateLog(CheckpointOperation checkpointOperation) {
        long l = this.getFirstLogNeeded(checkpointOperation);
        if (l == -1L) {
            return;
        }
        this.truncateLog(l);
    }

    private void truncateLog(long l) {
        long l2;
        if (this.keepAllLogs) {
            return;
        }
        if (this.backupInProgress && (l2 = this.logFileToBackup) < l) {
            l = l2;
        }
        this.firstLogFileNumber = l;
        for (long i = this.firstLogFileNumber; i < l; ++i) {
            StorageFile storageFile = null;
            try {
                storageFile = this.getLogFileName(i);
                if (!this.privDelete(storageFile)) continue;
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getFirstLogNeeded(CheckpointOperation checkpointOperation) {
        long l;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            l = checkpointOperation != null ? LogCounter.getLogFileNumber(checkpointOperation.undoLWM()) : -1L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeControlFile(StorageFile storageFile, long l) throws IOException, StandardException {
        StorageRandomAccessFile storageRandomAccessFile = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(fid);
        dataOutputStream.writeInt(9);
        dataOutputStream.writeLong(l);
        if (this.onDiskMajorVersion == 0) {
            this.onDiskMajorVersion = this.jbmsVersion.getMajorVersion();
            this.onDiskMinorVersion = this.jbmsVersion.getMinorVersion();
            this.onDiskBeta = this.jbmsVersion.isBeta();
        }
        dataOutputStream.writeInt(this.onDiskMajorVersion);
        dataOutputStream.writeInt(this.onDiskMinorVersion);
        dataOutputStream.writeInt(this.jbmsVersion.getBuildNumberAsInt());
        byte by = 0;
        if (this.onDiskBeta) {
            by = (byte)(by | 1);
        }
        if (this.logNotSynced || wasDBInDurabilityTestModeNoSync) {
            by = (byte)(by | 2);
        }
        dataOutputStream.writeByte(by);
        long l2 = 0L;
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeLong(l2);
        dataOutputStream.flush();
        this.checksum.reset();
        this.checksum.update(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
        dataOutputStream.writeLong(this.checksum.getValue());
        dataOutputStream.flush();
        try {
            this.checkCorrupt();
            try {
                storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rw");
            }
            catch (IOException iOException) {
                storageRandomAccessFile = null;
                boolean bl = false;
                if (storageRandomAccessFile != null) {
                    storageRandomAccessFile.close();
                }
                return bl;
            }
            if (!this.privCanWrite(storageFile)) {
                boolean bl = false;
                return bl;
            }
            storageRandomAccessFile.seek(0L);
            storageRandomAccessFile.write(byteArrayOutputStream.toByteArray());
            this.syncFile(storageRandomAccessFile);
            storageRandomAccessFile.close();
            try {
                storageRandomAccessFile = this.privRandomAccessFile(this.getMirrorControlFileName(), "rw");
            }
            catch (IOException iOException) {
                storageRandomAccessFile = null;
                boolean bl = false;
                if (storageRandomAccessFile != null) {
                    storageRandomAccessFile.close();
                }
                return bl;
            }
            storageRandomAccessFile.seek(0L);
            storageRandomAccessFile.write(byteArrayOutputStream.toByteArray());
            this.syncFile(storageRandomAccessFile);
        }
        finally {
            if (storageRandomAccessFile != null) {
                storageRandomAccessFile.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readControlFile(StorageFile storageFile, Properties properties) throws IOException, StandardException {
        StorageRandomAccessFile storageRandomAccessFile = null;
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        storageRandomAccessFile = this.privRandomAccessFile(storageFile, "r");
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        long l3 = storageRandomAccessFile.length();
        byte[] byArray = null;
        try {
            if (l3 < 16L) {
                l2 = -1L;
            } else if (l3 == 16L) {
                byArray = new byte[16];
                storageRandomAccessFile.readFully(byArray);
            } else if (l3 > 16L) {
                byArray = new byte[(int)storageRandomAccessFile.length() - 8];
                storageRandomAccessFile.readFully(byArray);
                l2 = storageRandomAccessFile.readLong();
                if (l2 != 0L) {
                    this.checksum.reset();
                    this.checksum.update(byArray, 0, byArray.length);
                }
            }
            if (l2 == this.checksum.getValue() || l2 == 0L) {
                boolean bl2;
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                filterInputStream = new DataInputStream(byteArrayInputStream);
                if (((DataInputStream)filterInputStream).readInt() != fid) {
                    throw StandardException.newException((String)"XSLAC.D", (Object[])new Object[]{this.dataDirectory});
                }
                int n = ((DataInputStream)filterInputStream).readInt();
                l = ((DataInputStream)filterInputStream).readLong();
                this.onDiskMajorVersion = ((DataInputStream)filterInputStream).readInt();
                this.onDiskMinorVersion = ((DataInputStream)filterInputStream).readInt();
                int n2 = ((DataInputStream)filterInputStream).readInt();
                byte by = ((DataInputStream)filterInputStream).readByte();
                wasDBInDurabilityTestModeNoSync = (by & 2) != 0;
                boolean bl3 = this.onDiskBeta = (by & 1) != 0;
                if (!(!this.onDiskBeta || this.jbmsVersion.isBeta() && this.onDiskMajorVersion == this.jbmsVersion.getMajorVersion() && this.onDiskMinorVersion == this.jbmsVersion.getMinorVersion() || (bl2 = false))) {
                    throw StandardException.newException((String)"XSLAP.D", (Object[])new Object[]{this.dataDirectory, ProductVersionHolder.simpleVersionString((int)this.onDiskMajorVersion, (int)this.onDiskMinorVersion, (boolean)this.onDiskBeta)});
                }
                if (this.onDiskMajorVersion > this.jbmsVersion.getMajorVersion() || this.onDiskMajorVersion == this.jbmsVersion.getMajorVersion() && this.onDiskMinorVersion > this.jbmsVersion.getMinorVersion()) {
                    throw StandardException.newException((String)"XSLAN.D", (Object[])new Object[]{this.dataDirectory, ProductVersionHolder.simpleVersionString((int)this.onDiskMajorVersion, (int)this.onDiskMinorVersion, (boolean)this.onDiskBeta)});
                }
                if (this.onDiskMajorVersion != this.jbmsVersion.getMajorVersion() || this.onDiskMinorVersion != this.jbmsVersion.getMinorVersion()) {
                    bl = true;
                }
                if (l2 == 0L && (this.onDiskMajorVersion > 3 || this.onDiskMinorVersion > 5 || this.onDiskMajorVersion == 0)) {
                    l = 0L;
                }
            }
        }
        finally {
            if (storageRandomAccessFile != null) {
                storageRandomAccessFile.close();
            }
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
        if (bl && LogToFile.isFullUpgrade(properties, ProductVersionHolder.simpleVersionString((int)this.onDiskMajorVersion, (int)this.onDiskMinorVersion, (boolean)this.onDiskBeta))) {
            this.onDiskMajorVersion = this.jbmsVersion.getMajorVersion();
            this.onDiskMinorVersion = this.jbmsVersion.getMinorVersion();
            this.onDiskBeta = this.jbmsVersion.isBeta();
            if (!this.writeControlFile(storageFile, l)) {
                throw StandardException.newException((String)"XSLAE.D", (Object[])new Object[]{storageFile});
            }
        }
        return l;
    }

    private void createLogDirectory() throws StandardException {
        StorageFile storageFile = this.logStorageFactory.newStorageFile("log");
        if (this.privExists(storageFile)) {
            String[] stringArray = this.privList(storageFile);
            if (stringArray != null && stringArray.length != 0) {
                throw StandardException.newException((String)"XSLAT.D", (Object[])new Object[]{storageFile.getPath()});
            }
        } else {
            IOException iOException = null;
            boolean bl = false;
            try {
                bl = this.privMkdirs(storageFile);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (!bl) {
                throw StandardException.newException((String)"XSLAQ.D", (Throwable)iOException, (Object[])new Object[]{storageFile.getPath()});
            }
            this.createDataWarningFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDataWarningFile() throws StandardException {
        StorageFile storageFile = this.logStorageFactory.newStorageFile("log", "README_DO_NOT_TOUCH_FILES.txt");
        if (!this.privExists(storageFile)) {
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = this.privGetOutputStreamWriter(storageFile);
                outputStreamWriter.write(MessageService.getTextMessage((String)"M006", (Object[])new Object[0]));
            }
            catch (IOException iOException) {
            }
            finally {
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public StorageFile getLogDirectory() throws StandardException {
        StorageFile storageFile = null;
        storageFile = this.logStorageFactory.newStorageFile("log");
        if (!this.privExists(storageFile)) {
            throw StandardException.newException((String)"XSLAQ.D", (Object[])new Object[]{storageFile.getPath()});
        }
        return storageFile;
    }

    @Override
    public String getCanonicalLogPath() {
        if (this.logDevice == null) {
            return null;
        }
        try {
            return this.logStorageFactory.getCanonicalName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private StorageFile getControlFileName() throws StandardException {
        return this.logStorageFactory.newStorageFile(this.getLogDirectory(), "log.ctrl");
    }

    private StorageFile getMirrorControlFileName() throws StandardException {
        return this.logStorageFactory.newStorageFile(this.getLogDirectory(), "logmirror.ctrl");
    }

    private StorageFile getLogFileName(long l) throws StandardException {
        return this.logStorageFactory.newStorageFile(this.getLogDirectory(), "log" + l + ".dat");
    }

    private CheckpointOperation findCheckpoint(long l, FileLogger fileLogger) throws IOException, StandardException, ClassNotFoundException {
        StreamLogScan streamLogScan = (StreamLogScan)this.openForwardsScan(l, (LogInstant)null);
        Loggable loggable = fileLogger.readLogRecord(streamLogScan, 100);
        streamLogScan.close();
        if (loggable instanceof CheckpointOperation) {
            return (CheckpointOperation)loggable;
        }
        return null;
    }

    protected LogScan openBackwardsScan(long l, LogInstant logInstant) throws IOException, StandardException {
        this.checkCorrupt();
        if (l == 0L) {
            return this.openBackwardsScan(logInstant);
        }
        this.flushBuffer(LogCounter.getLogFileNumber(l), LogCounter.getLogFilePosition(l));
        return new Scan(this, l, logInstant, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogScan openBackwardsScan(LogInstant logInstant) throws IOException, StandardException {
        long l;
        this.checkCorrupt();
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.logOut.flushLogAccessFile();
            l = this.currentInstant();
        }
        return new Scan(this, l, logInstant, 4);
    }

    @Override
    public ScanHandle openFlushedScan(DatabaseInstant databaseInstant, int n) throws StandardException {
        return new FlushedScanHandle(this, databaseInstant, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogScan openForwardsScan(long l, LogInstant logInstant) throws IOException, StandardException {
        this.checkCorrupt();
        if (l == 0L) {
            l = this.firstLogInstant();
        }
        if (logInstant != null) {
            LogCounter logCounter = (LogCounter)logInstant;
            this.flushBuffer(logCounter.getLogFileNumber(), logCounter.getLogFilePosition());
        } else {
            LogToFile logToFile = this;
            synchronized (logToFile) {
                if (this.logOut != null) {
                    this.logOut.flushLogAccessFile();
                }
            }
        }
        return new Scan(this, l, logInstant, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StorageRandomAccessFile getLogFileAtBeginning(long l) throws IOException, StandardException {
        if (this.inReplicationSlaveMode && this.allowedToReadFileNumber != -1L) {
            Object object = this.slaveRecoveryMonitor;
            synchronized (object) {
                while (this.inReplicationSlaveMode && l > this.allowedToReadFileNumber) {
                    if (this.replicationSlaveException != null) {
                        throw this.replicationSlaveException;
                    }
                    try {
                        this.slaveRecoveryMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
            }
        }
        long l2 = LogCounter.makeLogInstantAsLong(l, 24L);
        return this.getLogFileAtPosition(l2);
    }

    protected StorageRandomAccessFile getLogFileAtPosition(long l) throws IOException, StandardException {
        this.checkCorrupt();
        long l2 = LogCounter.getLogFileNumber(l);
        long l3 = LogCounter.getLogFilePosition(l);
        StorageFile storageFile = this.getLogFileName(l2);
        if (!this.privExists(storageFile)) {
            return null;
        }
        StorageRandomAccessFile storageRandomAccessFile = null;
        try {
            storageRandomAccessFile = this.privRandomAccessFile(storageFile, "r");
            if (!this.verifyLogFormat(storageRandomAccessFile, l2)) {
                storageRandomAccessFile.close();
                storageRandomAccessFile = null;
            } else {
                storageRandomAccessFile.seek(l3);
            }
        }
        catch (IOException iOException) {
            try {
                if (storageRandomAccessFile != null) {
                    storageRandomAccessFile.close();
                    storageRandomAccessFile = null;
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        return storageRandomAccessFile;
    }

    @Override
    public boolean canSupport(Properties properties) {
        String string = properties.getProperty("derby.__rt.storage.log");
        return string == null || !string.equals("readonly");
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        Object object;
        String string = properties.getProperty("replication.slave.mode");
        if (string != null && string.equals("slavemode")) {
            this.inReplicationSlaveMode = true;
            this.slaveRecoveryMonitor = new Object();
        } else if (string != null && string.equals("slavepremode")) {
            this.inReplicationSlavePreMode = true;
        }
        this.dataDirectory = properties.getProperty("derby.__rt.serviceDirectory");
        this.logDevice = properties.getProperty("logDevice");
        if (this.logDevice != null) {
            object = null;
            try {
                URL uRL = new URL(this.logDevice);
                object = uRL.getFile();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (object != null) {
                this.logDevice = object;
            }
        }
        if (bl) {
            this.getLogStorageFactory();
            this.createLogDirectory();
        } else if (!this.restoreLogs(properties)) {
            this.getLogStorageFactory();
            if (this.logDevice != null && !this.privExists((StorageFile)(object = this.logStorageFactory.newStorageFile("log")))) {
                throw StandardException.newException((String)"XSLAB.D", (Object[])new Object[]{object.getPath()});
            }
        }
        this.logBufferSize = PropertyUtil.getSystemInt("derby.storage.logBufferSize", 8192, 0x8000000, 32768);
        this.jbmsVersion = LogToFile.getMonitor().getEngineVersion();
        object = properties.getProperty("derby.storage.logArchiveMode");
        this.logArchived = Boolean.valueOf((String)object);
        this.getLogFactoryProperties(null);
        this.isWriteSynced = this.logStorageFactory.supportsWriteSync() ? !PropertyUtil.getSystemBoolean("derby.storage.fileSyncTransactionLog") : false;
        if ("test".equalsIgnoreCase(PropertyUtil.getSystemProperty("derby.system.durability"))) {
            this.logNotSynced = true;
            this.isWriteSynced = false;
        }
        boolean bl2 = bl;
        this.checkpointInstant = 0L;
        try {
            StorageFile storageFile;
            StorageFile storageFile2 = this.getControlFileName();
            if (!bl2) {
                if (this.privExists(storageFile2)) {
                    this.checkpointInstant = this.readControlFile(storageFile2, properties);
                    if (wasDBInDurabilityTestModeNoSync) {
                        Monitor.logMessage(MessageService.getTextMessage((String)"L020", (Object[])new Object[]{"derby.system.durability", "test"}));
                    }
                    if (this.checkpointInstant == 0L && this.privExists(this.getMirrorControlFileName())) {
                        this.checkpointInstant = this.readControlFile(this.getMirrorControlFileName(), properties);
                    }
                } else if (this.logDevice != null) {
                    throw StandardException.newException((String)"XSLAB.D", (Object[])new Object[]{storageFile2.getPath()});
                }
                this.logFileNumber = this.checkpointInstant != 0L ? LogCounter.getLogFileNumber(this.checkpointInstant) : 1L;
                storageFile = this.getLogFileName(this.logFileNumber);
                if (!this.privExists(storageFile)) {
                    if (this.logDevice != null) {
                        throw StandardException.newException((String)"XSLAB.D", (Object[])new Object[]{storageFile2.getPath()});
                    }
                    this.logErrMsg(MessageService.getTextMessage((String)"L018", (Object[])new Object[]{storageFile.getPath()}));
                    bl2 = true;
                } else if (!this.verifyLogFormat(storageFile, this.logFileNumber)) {
                    Monitor.logTextMessage("L008", storageFile);
                    if (!this.privDelete(storageFile) && this.logFileNumber == 1L) {
                        this.logErrMsgForDurabilityTestModeNoSync();
                        throw StandardException.newException((String)"XSLAC.D", (Object[])new Object[]{this.dataDirectory});
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                if (this.writeControlFile(storageFile2, 0L)) {
                    this.firstLogFileNumber = 1L;
                    this.logFileNumber = 1L;
                    storageFile = this.getLogFileName(this.logFileNumber);
                    if (this.privExists(storageFile)) {
                        Monitor.logTextMessage("L009", storageFile);
                        if (!this.privDelete(storageFile)) {
                            this.logErrMsgForDurabilityTestModeNoSync();
                            throw StandardException.newException((String)"XSLAC.D", (Object[])new Object[]{this.dataDirectory});
                        }
                    }
                    this.firstLog = this.privRandomAccessFile(storageFile, "rw");
                    if (!this.initLogFile(this.firstLog, this.logFileNumber, 0L)) {
                        throw StandardException.newException((String)"XSLAQ.D", (Object[])new Object[]{storageFile.getPath()});
                    }
                    this.setEndPosition(this.firstLog.getFilePointer());
                    this.lastFlush = this.firstLog.getFilePointer();
                    if (this.isWriteSynced) {
                        this.preAllocateNewLogFile(this.firstLog);
                        this.firstLog.close();
                        this.firstLog = this.openLogFileInWriteMode(storageFile);
                        this.firstLog.seek(this.endPosition);
                    }
                } else {
                    Monitor.logTextMessage("L022", new Object[0]);
                    Monitor.logThrowable(new Exception("Error writing control file"));
                    this.ReadOnlyDB = true;
                    this.logOut = null;
                    this.firstLog = null;
                }
                this.recoveryNeeded = false;
            } else {
                this.recoveryNeeded = true;
            }
        }
        catch (IOException iOException) {
            throw Monitor.exceptionStartingModule(iOException);
        }
        if (!this.checkVersion(10, 1)) {
            this.maxLogFileNumber = 0x3FFFFFL;
        }
        this.bootTimeLogFileNumber = this.logFileNumber;
    }

    private void getLogStorageFactory() throws StandardException {
        if (this.logDevice == null) {
            DataFactory dataFactory = (DataFactory)LogToFile.findServiceModule(this, "org.apache.derby.iapi.store.raw.data.DataFactory");
            this.logStorageFactory = (WritableStorageFactory)dataFactory.getStorageFactory();
        } else {
            try {
                PersistentService persistentService = LogToFile.getMonitor().getServiceType(this);
                this.logStorageFactory = (WritableStorageFactory)persistentService.getStorageFactoryInstance(false, this.logDevice, null, null);
            }
            catch (IOException iOException) {
                throw StandardException.newException((String)"XSLAB.D", (Throwable)iOException, (Object[])new Object[]{this.logDevice});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.checkpointDaemon != null) {
            this.checkpointDaemon.unsubscribe(this.myClientNumber);
            this.checkpointDaemon.stop();
        }
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.stopped = true;
            if (this.logOut != null) {
                try {
                    this.logOut.flushLogAccessFile();
                    this.logOut.close();
                }
                catch (IOException iOException) {
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
                this.logOut = null;
            }
        }
        if (!(this.corrupt != null || this.logArchived() || this.keepAllLogs || this.ReadOnlyDB)) {
            this.deleteObsoleteLogfiles();
        }
        if (this.logDevice != null) {
            this.logStorageFactory.shutdown();
        }
        this.logStorageFactory = null;
    }

    private void deleteObsoleteLogfiles() {
        StorageFile storageFile;
        long l;
        long l2 = this.getFirstLogNeeded(this.currentCheckpoint);
        if (l2 == -1L) {
            return;
        }
        if (this.backupInProgress && (l = this.logFileToBackup) < l2) {
            l2 = l;
        }
        try {
            storageFile = this.getLogDirectory();
        }
        catch (StandardException standardException) {
            return;
        }
        String[] stringArray = this.privList(storageFile);
        if (stringArray != null) {
            StorageFile storageFile2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                long l3;
                if (stringArray[i].startsWith("log") && stringArray[i].endsWith(".dat") && (l3 = Long.parseLong(stringArray[i].substring(3, stringArray[i].length() - 4))) < l2 && !this.privDelete(storageFile2 = this.logStorageFactory.newStorageFile(storageFile, stringArray[i]))) continue;
            }
        }
    }

    @Override
    public boolean serviceASAP() {
        return false;
    }

    @Override
    public boolean serviceImmediately() {
        return false;
    }

    @Override
    public void getLogFactoryProperties(PersistentSet persistentSet) throws StandardException {
        String string;
        String string2;
        if (persistentSet == null) {
            string2 = PropertyUtil.getSystemProperty("derby.storage.logSwitchInterval");
            string = PropertyUtil.getSystemProperty("derby.storage.checkpointInterval");
        } else {
            string2 = PropertyUtil.getServiceProperty(persistentSet, "derby.storage.logSwitchInterval");
            string = PropertyUtil.getServiceProperty(persistentSet, "derby.storage.checkpointInterval");
        }
        if (string2 != null) {
            this.logSwitchInterval = Integer.parseInt(string2);
            if (this.logSwitchInterval < 100000) {
                this.logSwitchInterval = 100000;
            } else if (this.logSwitchInterval > 0x8000000) {
                this.logSwitchInterval = 0x8000000;
            }
        }
        if (string != null) {
            this.checkpointInterval = Integer.parseInt(string);
            if (this.checkpointInterval < 100000) {
                this.checkpointInterval = 100000;
            } else if (this.checkpointInterval > 0x8000000) {
                this.checkpointInterval = 0x8000000;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performWork(ContextManager contextManager) {
        Object object = this;
        synchronized (object) {
            if (this.corrupt != null) {
                return 1;
            }
        }
        object = (AccessFactory)LogToFile.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        try {
            if (object != null) {
                TransactionController transactionController = null;
                try {
                    transactionController = object.getAndNameTransaction(contextManager, "SystemTransaction");
                    this.getLogFactoryProperties(transactionController);
                }
                finally {
                    if (transactionController != null) {
                        transactionController.commit();
                    }
                }
            }
            this.rawStoreFactory.checkpoint();
        }
        catch (StandardException standardException) {
            Monitor.logTextMessage("L011", new Object[0]);
            this.logErrMsg(standardException);
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        this.checkpointDaemonCalled = false;
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long appendLogRecord(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws StandardException {
        long l;
        if (this.inReplicationSlavePreMode) {
            return LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition);
        }
        boolean bl = false;
        if (this.ReadOnlyDB) {
            throw StandardException.newException((String)"XSLAH.D", (Object[])new Object[0]);
        }
        if (n2 <= 0) {
            throw StandardException.newException((String)"XSLB6.S", (Object[])new Object[0]);
        }
        try {
            LogToFile logToFile = this;
            synchronized (logToFile) {
                if (this.corrupt != null) {
                    throw StandardException.newException((String)"XSLAA.D", (Throwable)this.corrupt, (Object[])new Object[0]);
                }
                if (this.logOut == null) {
                    throw StandardException.newException((String)"XSLAJ.D", (Object[])new Object[0]);
                }
                int n5 = this.logOut.getChecksumLogRecordSize();
                if (this.endPosition + 16L + (long)n2 + 4L + (long)n5 >= 0xFFFFFFFL) {
                    this.switchLogFile();
                    if (this.endPosition + 16L + (long)n2 + 4L + (long)n5 >= 0xFFFFFFFL) {
                        throw StandardException.newException((String)"XSLAL.D", (Object[])new Object[]{this.logFileNumber, this.endPosition, n2, 0xFFFFFFFL});
                    }
                }
                this.setEndPosition(this.endPosition + this.logOut.reserveSpaceForChecksum(n2, this.logFileNumber, this.endPosition));
                l = LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition);
                this.logOut.writeLogRecord(n2, l, byArray, n, byArray2, n3, n4);
                if (n4 != 0) {
                    // empty if block
                }
                this.setEndPosition(this.endPosition + (long)(n2 + 16));
            }
        }
        catch (IOException iOException) {
            throw this.markCorrupt(StandardException.newException((String)"XSLA4.D", (Throwable)iOException, (Object[])new Object[0]));
        }
        return l;
    }

    protected synchronized long currentInstant() {
        return LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition);
    }

    protected synchronized long endPosition() {
        return this.endPosition;
    }

    private synchronized long getLogFileNumber() {
        return this.logFileNumber;
    }

    private synchronized long firstLogInstant() {
        return LogCounter.makeLogInstantAsLong(this.firstLogFileNumber, 24L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(long l, long l2) throws StandardException {
        LogToFile logToFile;
        long l3 = 0L;
        LogToFile logToFile2 = this;
        synchronized (logToFile2) {
            try {
                boolean bl;
                do {
                    if (this.corrupt != null) {
                        throw StandardException.newException((String)"XSLAA.D", (Throwable)this.corrupt, (Object[])new Object[0]);
                    }
                    while (this.isFrozen) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            InterruptStatus.setInterrupted();
                        }
                    }
                    if (l2 == 0L || l < this.logFileNumber || l2 < this.lastFlush) {
                        return;
                    }
                    if (this.recoveryNeeded && this.inRedo && !this.inReplicationSlaveMode) {
                        return;
                    }
                    if (this.logBeingFlushed) {
                        bl = true;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            InterruptStatus.setInterrupted();
                        }
                        continue;
                    }
                    bl = false;
                    if (!this.isWriteSynced) {
                        this.logOut.flushLogAccessFile();
                    } else {
                        this.logOut.switchLogBuffer();
                    }
                    l3 = this.endPosition;
                    this.logBeingFlushed = true;
                    if (!this.inReplicationMasterMode) continue;
                    this.masterFactory.flushedTo(LogCounter.makeLogInstantAsLong(l, l2));
                } while (bl);
            }
            catch (IOException iOException) {
                throw this.markCorrupt(StandardException.newException((String)"XSLA0.D", (Throwable)iOException, (Object[])new Object[]{this.getLogFileName(this.logFileNumber).getPath()}));
            }
            catch (NullPointerException nullPointerException) {
                throw nullPointerException;
            }
        }
        boolean bl = false;
        try {
            if (this.isWriteSynced) {
                this.logOut.flushDirtyBuffers();
            } else if (!this.logNotSynced) {
                this.logOut.syncLogAccessFile();
            }
            bl = true;
        }
        catch (SyncFailedException syncFailedException) {
            throw this.markCorrupt(StandardException.newException((String)"XSLA0.D", (Throwable)syncFailedException, (Object[])new Object[]{this.getLogFileName(this.logFileNumber).getPath()}));
        }
        catch (IOException iOException) {
            throw this.markCorrupt(StandardException.newException((String)"XSLA0.D", (Throwable)iOException, (Object[])new Object[]{this.getLogFileName(this.logFileNumber).getPath()}));
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        finally {
            LogToFile logToFile3 = this;
            synchronized (logToFile3) {
                this.logBeingFlushed = false;
                if (bl) {
                    this.lastFlush = l3;
                }
                this.notifyAll();
            }
        }
        if (this.logWrittenFromLastCheckPoint + l3 > (long)this.checkpointInterval && this.checkpointDaemon != null && !this.checkpointDaemonCalled && !this.inLogSwitch) {
            logToFile = this;
            synchronized (logToFile) {
                if (this.logWrittenFromLastCheckPoint + l3 > (long)this.checkpointInterval && this.checkpointDaemon != null && !this.checkpointDaemonCalled && !this.inLogSwitch) {
                    this.checkpointDaemonCalled = true;
                    this.checkpointDaemon.serviceNow(this.myClientNumber);
                }
            }
        }
        if (l3 > (long)this.logSwitchInterval && !this.checkpointDaemonCalled && !this.inLogSwitch) {
            logToFile = this;
            synchronized (logToFile) {
                if (l3 > (long)this.logSwitchInterval && !this.checkpointDaemonCalled && !this.inLogSwitch) {
                    this.inLogSwitch = true;
                    this.switchLogFile();
                }
            }
        }
    }

    private void syncFile(StorageRandomAccessFile storageRandomAccessFile) throws StandardException {
        int n = 0;
        while (true) {
            try {
                storageRandomAccessFile.sync();
            }
            catch (IOException iOException) {
                ++n;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
                if (n <= 20) continue;
                throw StandardException.newException((String)"XSLA4.D", (Throwable)iOException, (Object[])new Object[0]);
            }
            break;
        }
    }

    @Override
    public LogScan openForwardsFlushedScan(LogInstant logInstant) throws StandardException {
        this.checkCorrupt();
        return new FlushedScan(this, ((LogCounter)logInstant).getValueAsLong());
    }

    @Override
    public LogScan openForwardsScan(LogInstant logInstant, LogInstant logInstant2) throws StandardException {
        try {
            long l = logInstant == null ? 0L : ((LogCounter)logInstant).getValueAsLong();
            return this.openForwardsScan(l, logInstant2);
        }
        catch (IOException iOException) {
            throw this.markCorrupt(StandardException.newException((String)"XSLA2.D", (Throwable)iOException, (Object[])new Object[0]));
        }
    }

    public final boolean databaseEncrypted() {
        return this.databaseEncrypted;
    }

    @Override
    public void setDatabaseEncrypted(boolean bl, boolean bl2) throws StandardException {
        if (bl2) {
            this.flushAll();
        }
        this.databaseEncrypted = bl;
    }

    @Override
    public void startNewLogFile() throws StandardException {
        this.switchLogFile();
    }

    @Override
    public boolean isCheckpointInLastLogFile() throws StandardException {
        long l = LogCounter.getLogFileNumber(this.checkpointInstant) + 1L;
        StorageFile storageFile = this.getLogFileName(l);
        return !this.privExists(storageFile);
    }

    @Override
    public void deleteLogFileAfterCheckpointLogFile() throws StandardException {
        long l = LogCounter.getLogFileNumber(this.checkpointInstant) + 1L;
        StorageFile storageFile = this.getLogFileName(l);
        if (this.privExists(storageFile) && !this.privDelete(storageFile)) {
            throw StandardException.newException((String)"XBM0R.D", (Object[])new Object[]{storageFile});
        }
    }

    public int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        return this.rawStoreFactory.encrypt(byArray, n, n2, byArray2, n3, false);
    }

    public int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        return this.rawStoreFactory.decrypt(byArray, n, n2, byArray2, n3);
    }

    public int getEncryptionBlockSize() {
        return this.rawStoreFactory.getEncryptionBlockSize();
    }

    public int getEncryptedDataLength(int n) {
        if (n % this.getEncryptionBlockSize() != 0) {
            return n + this.getEncryptionBlockSize() - n % this.getEncryptionBlockSize();
        }
        return n;
    }

    @Override
    public synchronized LogInstant getFirstUnflushedInstant() {
        return new LogCounter(this.logFileNumber, this.lastFlush);
    }

    @Override
    public synchronized long getFirstUnflushedInstantAsLong() {
        return LogCounter.makeLogInstantAsLong(this.logFileNumber, this.lastFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezePersistentStore() throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.isFrozen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unfreezePersistentStore() throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.isFrozen = false;
            this.notifyAll();
        }
    }

    @Override
    public boolean logArchived() {
        return this.logArchived;
    }

    boolean checkVersion(int n, int n2) {
        if (this.onDiskMajorVersion > n) {
            return true;
        }
        return this.onDiskMajorVersion == n && this.onDiskMinorVersion >= n2;
    }

    @Override
    public boolean checkVersion(int n, int n2, String string) throws StandardException {
        boolean bl = this.checkVersion(n, n2);
        if (!bl && string != null) {
            throw StandardException.newException((String)"XCL47.S", (Object[])new Object[]{string, ProductVersionHolder.simpleVersionString((int)this.onDiskMajorVersion, (int)this.onDiskMinorVersion, (boolean)this.onDiskBeta), ProductVersionHolder.simpleVersionString((int)n, (int)n2, (boolean)false)});
        }
        return bl;
    }

    protected void logErrMsg(String string) {
        this.logErrMsgForDurabilityTestModeNoSync();
        Monitor.logTextMessage("L001", new Object[0]);
        Monitor.logMessage(string);
        Monitor.logTextMessage("L002", new Object[0]);
    }

    protected void logErrMsg(Throwable throwable) {
        this.logErrMsgForDurabilityTestModeNoSync();
        if (this.corrupt != null) {
            Monitor.logTextMessage("L003", new Object[0]);
            this.printErrorStack(this.corrupt);
            Monitor.logTextMessage("L004", new Object[0]);
        }
        if (throwable != this.corrupt) {
            Monitor.logTextMessage("L005", new Object[0]);
            this.printErrorStack(throwable);
            Monitor.logTextMessage("L006", new Object[0]);
        }
    }

    private void logErrMsgForDurabilityTestModeNoSync() {
        if (this.logNotSynced || wasDBInDurabilityTestModeNoSync) {
            Monitor.logTextMessage("L021", "derby.system.durability", "test");
        }
    }

    private void printErrorStack(Throwable throwable) {
        ErrorStringBuilder errorStringBuilder = new ErrorStringBuilder(Monitor.getStream().getHeader());
        errorStringBuilder.stackTrace(throwable);
        Monitor.logMessage(errorStringBuilder.get().toString());
        errorStringBuilder.reset();
    }

    private long logtest_appendPartialLogRecord(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws StandardException {
        return 0L;
    }

    protected void testLogFull() throws IOException {
    }

    public StorageRandomAccessFile getLogFileToSimulateCorruption(long l) throws IOException, StandardException {
        return null;
    }

    @Override
    public boolean inReplicationMasterMode() {
        return this.inReplicationMasterMode;
    }

    @Override
    public void enableLogArchiveMode() throws StandardException {
        if (!this.logArchived) {
            this.logArchived = true;
            AccessFactory accessFactory = (AccessFactory)LogToFile.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
            if (accessFactory != null) {
                TransactionController transactionController = null;
                transactionController = accessFactory.getTransaction(LogToFile.getContextService().getCurrentContextManager());
                transactionController.setProperty("derby.storage.logArchiveMode", (Serializable)((Object)"true"), true);
            }
        }
    }

    @Override
    public void disableLogArchiveMode() throws StandardException {
        AccessFactory accessFactory = (AccessFactory)LogToFile.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        if (accessFactory != null) {
            TransactionController transactionController = null;
            transactionController = accessFactory.getTransaction(LogToFile.getContextService().getCurrentContextManager());
            transactionController.setProperty("derby.storage.logArchiveMode", (Serializable)((Object)"false"), true);
        }
        this.logArchived = false;
    }

    @Override
    public void deleteOnlineArchivedLogFiles() {
        this.deleteObsoleteLogfiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLogBackup(File file) throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            File file2;
            while (this.inCheckpoint) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
            this.backupInProgress = true;
            StorageFile storageFile = this.getControlFileName();
            if (!this.privCopyFile(storageFile, file2 = new File(file, storageFile.getName()))) {
                throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{storageFile, file2});
            }
            storageFile = this.getMirrorControlFileName();
            if (!this.privCopyFile(storageFile, file2 = new File(file, storageFile.getName()))) {
                throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{storageFile, file2});
            }
            this.logFileToBackup = this.getFirstLogNeeded(this.currentCheckpoint);
        }
        this.backupLogFiles(file, this.getLogFileNumber() - 1L);
    }

    private void backupLogFiles(File file, long l) throws StandardException {
        while (this.logFileToBackup <= l) {
            File file2;
            StorageFile storageFile = this.getLogFileName(this.logFileToBackup);
            if (!this.privCopyFile(storageFile, file2 = new File(file, storageFile.getName()))) {
                throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{storageFile, file2});
            }
            ++this.logFileToBackup;
        }
    }

    @Override
    public void endLogBackup(File file) throws StandardException {
        long l;
        this.flush(this.logFileNumber, this.endPosition);
        if (this.logArchived) {
            this.switchLogFile();
            l = this.getLogFileNumber() - 1L;
        } else {
            l = this.getLogFileNumber();
        }
        this.backupLogFiles(file, l);
        this.backupInProgress = false;
    }

    @Override
    public void abortLogBackup() {
        this.backupInProgress = false;
    }

    @Override
    public boolean inRFR() {
        if (this.recoveryNeeded) {
            boolean bl = false;
            try {
                bl = !this.privCanWrite(this.getControlFileName());
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            bl = bl || this.dataFactory != null && this.dataFactory.isReadOnly();
            return !bl;
        }
        return false;
    }

    @Override
    public void checkpointInRFR(LogInstant logInstant, long l, long l2, DataFactory dataFactory) throws StandardException {
        dataFactory.checkpoint();
        try {
            if (!this.writeControlFile(this.getControlFileName(), ((LogCounter)logInstant).getValueAsLong())) {
                throw StandardException.newException((String)"XSLAE.D", (Object[])new Object[]{this.getControlFileName()});
            }
        }
        catch (IOException iOException) {
            throw this.markCorrupt(StandardException.newException((String)"XSLA2.D", (Throwable)iOException, (Object[])new Object[0]));
        }
        dataFactory.removeDroppedContainerFileStubs(new LogCounter(l));
        if (this.inReplicationSlaveMode) {
            this.truncateLog(LogCounter.getLogFileNumber(l2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReplicationMasterRole(MasterFactory masterFactory) throws StandardException {
        this.masterFactory = masterFactory;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.inReplicationMasterMode = true;
            this.logOut.setReplicationMasterRole(masterFactory);
        }
    }

    @Override
    public void stopReplicationMasterRole() {
        this.inReplicationMasterMode = false;
        this.masterFactory = null;
        if (this.logOut != null) {
            this.logOut.stopReplicationMasterRole();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReplicationSlaveRole() throws StandardException {
        if (!this.stopped) {
            this.flushAll();
        }
        this.replicationSlaveException = StandardException.newException((String)"08006.D", (Object[])new Object[0]);
        Object object = this.slaveRecoveryMonitor;
        synchronized (object) {
            this.slaveRecoveryMonitor.notify();
        }
    }

    protected void checkForReplication(LogAccessFile logAccessFile) {
        if (this.inReplicationMasterMode) {
            logAccessFile.setReplicationMasterRole(this.masterFactory);
        } else if (this.inReplicationSlaveMode) {
            logAccessFile.setReplicationSlaveRole();
        }
    }

    public void initializeReplicationSlaveRole() throws StandardException {
        try {
            while (this.getLogFileAtBeginning(this.logFileNumber + 1L) != null) {
                ++this.logFileNumber;
            }
            long l = LogCounter.makeLogInstantAsLong(this.logFileNumber, 24L);
            long l2 = 24L;
            StreamLogScan streamLogScan = (StreamLogScan)this.openForwardsScan(l, (LogInstant)null);
            ArrayInputStream arrayInputStream = new ArrayInputStream();
            while (streamLogScan.getNextRecord(arrayInputStream, null, 0) != null) {
                l2 = streamLogScan.getLogRecordEnd();
            }
            this.setEndPosition(LogCounter.getLogFilePosition(l2));
            StorageRandomAccessFile storageRandomAccessFile = null;
            storageRandomAccessFile = this.isWriteSynced ? this.openLogFileInWriteMode(this.getLogFileName(this.logFileNumber)) : this.privRandomAccessFile(this.getLogFileName(this.logFileNumber), "rw");
            this.logOut = new LogAccessFile(this, storageRandomAccessFile, this.logBufferSize);
            this.lastFlush = this.endPosition;
            storageRandomAccessFile.seek(this.endPosition);
        }
        catch (IOException iOException) {
            throw StandardException.newException((String)"XRE03", (Throwable)iOException, (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failoverSlave() {
        if (!this.stopped) {
            try {
                this.flushAll();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        this.inReplicationSlaveMode = false;
        Object object = this.slaveRecoveryMonitor;
        synchronized (object) {
            this.slaveRecoveryMonitor.notify();
        }
    }

    private boolean restoreLogs(Properties properties) throws StandardException {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        string = properties.getProperty("createFrom");
        if (string != null) {
            bl = true;
        } else {
            string = properties.getProperty("restoreFrom");
            if (string != null) {
                bl2 = true;
            } else {
                string = properties.getProperty("rollForwardRecoveryFrom");
            }
        }
        if (string != null) {
            File file;
            String[] stringArray;
            if (!bl && this.logDevice == null) {
                this.logDevice = properties.getProperty("derby.storage.logDeviceWhenBackedUp");
            }
            this.getLogStorageFactory();
            StorageFile storageFile = this.logStorageFactory.newStorageFile("log");
            if (bl2 && this.logDevice != null && !this.privRemoveDirectory(storageFile) && !this.privDelete(storageFile)) {
                throw StandardException.newException((String)"XSDG7.D", (Object[])new Object[]{this.getLogDirPath(storageFile)});
            }
            if (bl || bl2) {
                this.createLogDirectory();
            }
            if ((stringArray = this.privList(file = new File(string, "log"))) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    File file2 = new File(file, stringArray[i]);
                    StorageFile storageFile2 = this.logStorageFactory.newStorageFile(storageFile, stringArray[i]);
                    if (this.privCopyFile(file2, storageFile2)) continue;
                    throw StandardException.newException((String)"XSLAR.D", (Object[])new Object[]{file2, storageFile2});
                }
            } else {
                throw StandardException.newException((String)"XSLAS.D", (Object[])new Object[]{file});
            }
            this.logSwitchRequired = true;
            return true;
        }
        return false;
    }

    private void preAllocateNewLogFile(StorageRandomAccessFile storageRandomAccessFile) throws IOException, StandardException {
        int n = this.logSwitchInterval - 24;
        int n2 = this.logBufferSize * 2;
        byte[] byArray = new byte[n2];
        int n3 = n / n2;
        int n4 = n % n2;
        try {
            while (n3-- > 0) {
                storageRandomAccessFile.write(byArray);
            }
            if (n4 != 0) {
                storageRandomAccessFile.write(byArray, 0, n4);
            }
            this.syncFile(storageRandomAccessFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private StorageRandomAccessFile openLogFileInWriteMode(StorageFile storageFile) throws IOException {
        if (!this.jvmSyncErrorChecked && this.checkJvmSyncError(storageFile)) {
            this.isWriteSynced = false;
            return this.privRandomAccessFile(storageFile, "rw");
        }
        StorageRandomAccessFile storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rwd");
        return storageRandomAccessFile;
    }

    private String getLogDirPath(StorageFile storageFile) {
        if (this.logDevice == null) {
            return storageFile.toString();
        }
        return this.logDevice + this.logStorageFactory.getSeparator() + storageFile.toString();
    }

    private boolean checkJvmSyncError(StorageFile storageFile) throws IOException {
        boolean bl = false;
        StorageRandomAccessFile storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rw");
        storageRandomAccessFile.close();
        try {
            storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rws");
            storageRandomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logErrMsg("LogToFile.checkJvmSyncError: Your JVM seems to have a problem with implicit syncing of log files. Will use explicit syncing instead.");
            bl = true;
        }
        this.jvmSyncErrorChecked = true;
        return bl;
    }

    protected boolean privExists(StorageFile storageFile) {
        return this.runBooleanAction(0, storageFile);
    }

    protected boolean privDelete(StorageFile storageFile) {
        return this.runBooleanAction(1, storageFile);
    }

    private synchronized StorageRandomAccessFile privRandomAccessFile(StorageFile storageFile, String string) throws IOException {
        this.action = 2;
        this.activeFile = storageFile;
        this.activePerms = string;
        try {
            return (StorageRandomAccessFile)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private synchronized OutputStreamWriter privGetOutputStreamWriter(StorageFile storageFile) throws IOException {
        this.action = 10;
        this.activeFile = storageFile;
        try {
            return (OutputStreamWriter)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    protected boolean privCanWrite(StorageFile storageFile) {
        return this.runBooleanAction(3, storageFile);
    }

    protected boolean privMkdirs(StorageFile storageFile) throws IOException {
        this.action = 4;
        this.activeFile = storageFile;
        try {
            return (Boolean)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    private synchronized String[] privList(File file) {
        this.action = 8;
        this.toFile = file;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    private synchronized String[] privList(StorageFile storageFile) {
        this.action = 5;
        this.activeFile = storageFile;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    private synchronized boolean privCopyFile(StorageFile storageFile, File file) throws StandardException {
        this.action = 6;
        this.activeFile = storageFile;
        this.toFile = file;
        try {
            return (Boolean)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getCause() instanceof StandardException) {
                throw (StandardException)privilegedActionException.getCause();
            }
            return false;
        }
    }

    private synchronized boolean privCopyFile(File file, StorageFile storageFile) {
        this.action = 9;
        this.activeFile = storageFile;
        this.toFile = file;
        try {
            return (Boolean)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return false;
        }
    }

    private boolean privRemoveDirectory(StorageFile storageFile) {
        return this.runBooleanAction(7, storageFile);
    }

    private synchronized boolean runBooleanAction(int n, StorageFile storageFile) {
        this.action = n;
        this.activeFile = storageFile;
        try {
            return (Boolean)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return false;
        }
    }

    private void setEndPosition(long l) {
        this.endPosition = l;
    }

    @Override
    public final Object run() throws IOException, StandardException {
        switch (this.action) {
            case 0: {
                return this.activeFile.exists();
            }
            case 1: {
                return this.activeFile.delete();
            }
            case 2: {
                boolean bl = this.activeFile.exists();
                StorageRandomAccessFile storageRandomAccessFile = this.activeFile.getRandomAccessFile(this.activePerms);
                if (!bl) {
                    this.activeFile.limitAccessToOwner();
                }
                return storageRandomAccessFile;
            }
            case 3: {
                return this.activeFile.canWrite();
            }
            case 4: {
                boolean bl = this.activeFile.mkdirs();
                if (bl) {
                    this.activeFile.limitAccessToOwner();
                }
                return bl;
            }
            case 5: {
                return this.activeFile.list();
            }
            case 6: {
                return FileUtil.copyFile((StorageFactory)this.logStorageFactory, this.activeFile, this.toFile);
            }
            case 7: {
                return !this.activeFile.exists() || this.activeFile.deleteAll();
            }
            case 8: {
                return this.toFile.list();
            }
            case 9: {
                return FileUtil.copyFile(this.logStorageFactory, this.toFile, this.activeFile);
            }
            case 10: {
                return new OutputStreamWriter(this.activeFile.getOutputStream(), "UTF8");
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.toString();
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static Object findServiceModule(final Object object, final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(object, string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }

    private static Object getServiceModule(final Object object, final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.getServiceModule(object, string);
            }
        });
    }

    private static boolean isFullUpgrade(final Properties properties, final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws StandardException {
                    return Monitor.isFullUpgrade(properties, string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }
}

