/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.ui.domain;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="TASK_RESULT_STATISTICS")
public class TaskResultStatistics {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="success_count", length=11)
    private Long successCount;
    @Column(name="failed_count", length=11)
    private Long failedCount;
    @Column(name="statistic_interval", length=10)
    private String statisticInterval;
    @Column(name="statistics_time", nullable=false)
    private Date statisticsTime;
    @Column(name="creation_time", nullable=false)
    private Date creationTime = new Date();

    public TaskResultStatistics(Long successCount, Long failedCount) {
        this.successCount = successCount;
        this.failedCount = failedCount;
    }

    public TaskResultStatistics(Long successCount, Long failedCount, String statisticInterval, Date statisticsTime) {
        this.successCount = successCount;
        this.failedCount = failedCount;
        this.statisticInterval = statisticInterval;
        this.statisticsTime = statisticsTime;
    }

    public TaskResultStatistics() {
    }

    public TaskResultStatistics(Long id, Long successCount, Long failedCount, String statisticInterval, Date statisticsTime, Date creationTime) {
        this.id = id;
        this.successCount = successCount;
        this.failedCount = failedCount;
        this.statisticInterval = statisticInterval;
        this.statisticsTime = statisticsTime;
        this.creationTime = creationTime;
    }

    public Long getId() {
        return this.id;
    }

    public Long getSuccessCount() {
        return this.successCount;
    }

    public Long getFailedCount() {
        return this.failedCount;
    }

    public String getStatisticInterval() {
        return this.statisticInterval;
    }

    public Date getStatisticsTime() {
        return this.statisticsTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }
}

