/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.http.pojo;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.kernel.infra.exception.JobConfigurationException;

public final class HttpParam {
    private final String url;
    private final String method;
    private final String contentType;
    private final String data;
    private final int connectTimeoutMilliseconds;
    private final int readTimeoutMilliseconds;

    public HttpParam(Properties props) {
        this.url = props.getProperty("http.uri");
        if (Strings.isNullOrEmpty((String)this.url)) {
            throw new JobConfigurationException("Cannot find HTTP URL, job is not executed.", new Object[0]);
        }
        this.method = props.getProperty("http.method");
        if (Strings.isNullOrEmpty((String)this.method)) {
            throw new JobConfigurationException("Cannot find HTTP method, job is not executed.", new Object[0]);
        }
        this.contentType = props.getProperty("http.content.type");
        this.data = props.getProperty("http.data");
        this.connectTimeoutMilliseconds = Integer.parseInt(props.getProperty("http.connect.timeout.milliseconds", "3000"));
        this.readTimeoutMilliseconds = Integer.parseInt(props.getProperty("http.read.timeout.milliseconds", "5000"));
    }

    public boolean isWriteMethod() {
        return Arrays.asList("POST", "PUT", "DELETE").contains(this.method.toUpperCase());
    }

    @Generated
    public HttpParam(String url, String method, String contentType, String data, int connectTimeoutMilliseconds, int readTimeoutMilliseconds) {
        this.url = url;
        this.method = method;
        this.contentType = contentType;
        this.data = data;
        this.connectTimeoutMilliseconds = connectTimeoutMilliseconds;
        this.readTimeoutMilliseconds = readTimeoutMilliseconds;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public int getConnectTimeoutMilliseconds() {
        return this.connectTimeoutMilliseconds;
    }

    @Generated
    public int getReadTimeoutMilliseconds() {
        return this.readTimeoutMilliseconds;
    }
}

