/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.pipeline;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.restful.deserializer.RequestBodyDeserializer;
import org.apache.shardingsphere.elasticjob.restful.deserializer.RequestBodyDeserializerFactory;
import org.apache.shardingsphere.elasticjob.restful.handler.HandleContext;
import org.apache.shardingsphere.elasticjob.restful.handler.Handler;
import org.apache.shardingsphere.elasticjob.restful.handler.HandlerParameter;
import org.apache.shardingsphere.elasticjob.restful.mapping.MappingContext;
import org.apache.shardingsphere.elasticjob.restful.mapping.PathMatcher;
import org.apache.shardingsphere.elasticjob.restful.mapping.RegexPathMatcher;
import org.apache.shardingsphere.elasticjob.restful.wrapper.QueryParameterMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class HandlerParameterDecoder
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HandlerParameterDecoder.class);
    private final PathMatcher pathMatcher = new RegexPathMatcher();

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        HandleContext handleContext = (HandleContext)msg;
        FullHttpRequest httpRequest = handleContext.getHttpRequest();
        MappingContext<Handler> mappingContext = handleContext.getMappingContext();
        Object[] arguments = this.prepareArguments(httpRequest, mappingContext);
        handleContext.setArgs(arguments);
        ctx.fireChannelRead((Object)handleContext);
    }

    private Object[] prepareArguments(FullHttpRequest httpRequest, MappingContext<Handler> mappingContext) {
        Handler handler = mappingContext.payload();
        List<HandlerParameter> handlerParameters = handler.getHandlerParameters();
        Map<String, List<String>> queryParameters = this.parseQuery(httpRequest.uri());
        Map<String, String> templateVariables = this.pathMatcher.captureVariables(mappingContext.pattern(), httpRequest.uri());
        Object[] result = new Object[handlerParameters.size()];
        boolean requestBodyAlreadyParsed = false;
        for (int i = 0; i < handlerParameters.size(); ++i) {
            HandlerParameter handlerParameter = handlerParameters.get(i);
            Object parsedValue = null;
            String parameterName = handlerParameter.getName();
            Class<?> targetType = handlerParameter.getType();
            boolean nullable = !handlerParameter.isRequired();
            switch (handlerParameter.getParamSource()) {
                case PATH: {
                    String rawPathValue = templateVariables.get(parameterName);
                    Object parsedPathValue = this.deserializeBuiltInType(targetType, rawPathValue);
                    Preconditions.checkArgument((nullable || null != parsedPathValue ? 1 : 0) != 0, (String)"Missing path variable [%s].", (Object)parameterName);
                    parsedValue = parsedPathValue;
                    break;
                }
                case QUERY: {
                    List<String> rawQueryValues = queryParameters.get(parameterName);
                    Object parsedQueryValue = this.deserializeQueryParameter(targetType, rawQueryValues);
                    Preconditions.checkArgument((nullable || null != parsedQueryValue ? 1 : 0) != 0, (String)"Missing query parameter [%s].", (Object)parameterName);
                    parsedValue = parsedQueryValue;
                    break;
                }
                case HEADER: {
                    String rawHeaderValue = httpRequest.headers().get(parameterName);
                    Object parsedHeaderValue = this.deserializeBuiltInType(targetType, rawHeaderValue);
                    Preconditions.checkArgument((nullable || null != parsedHeaderValue ? 1 : 0) != 0, (String)"Missing header value [%s].", (Object)parameterName);
                    parsedValue = parsedHeaderValue;
                    break;
                }
                case BODY: {
                    Preconditions.checkState((!requestBodyAlreadyParsed ? 1 : 0) != 0, (Object)"@RequestBody duplicated on handle method.");
                    byte[] bytes = ByteBufUtil.getBytes((ByteBuf)httpRequest.content());
                    String mimeType = Optional.ofNullable(HttpUtil.getMimeType((HttpMessage)httpRequest)).orElseGet(() -> HttpUtil.getMimeType((CharSequence)"application/json; charset=utf-8")).toString();
                    RequestBodyDeserializer deserializer = RequestBodyDeserializerFactory.getRequestBodyDeserializer(mimeType);
                    Object parsedBodyValue = deserializer.deserialize(targetType, bytes);
                    parsedValue = parsedBodyValue;
                    Preconditions.checkArgument((nullable || null != parsedBodyValue ? 1 : 0) != 0, (Object)"Missing request body");
                    requestBodyAlreadyParsed = true;
                    break;
                }
                case UNKNOWN: {
                    if (QueryParameterMap.class.isAssignableFrom(targetType)) {
                        parsedValue = new QueryParameterMap(queryParameters);
                        break;
                    }
                    log.warn("Unknown source argument [{}] on index [{}].", (Object)parameterName, (Object)handlerParameter.getIndex());
                    break;
                }
            }
            result[i] = parsedValue;
        }
        return result;
    }

    private Map<String, List<String>> parseQuery(String uri) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri);
        return queryStringDecoder.parameters();
    }

    private Object deserializeQueryParameter(Class<?> targetType, List<String> queryValues) {
        if (null == queryValues || queryValues.isEmpty()) {
            return null;
        }
        if (1 == queryValues.size()) {
            return this.deserializeBuiltInType(targetType, queryValues.get(0));
        }
        throw new UnsupportedOperationException("Multi value query doesn't support yet.");
    }

    private Object deserializeBuiltInType(Class<?> targetType, String value) {
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"Cannot deserialize empty value.");
        if (String.class.equals(targetType)) {
            return value;
        }
        if (Boolean.class.equals(targetType) || Boolean.TYPE.equals(targetType)) {
            return Boolean.parseBoolean(value);
        }
        if (Character.class.equals(targetType) || Character.TYPE.equals(targetType)) {
            Preconditions.checkArgument((1 >= value.length() ? 1 : 0) != 0, (Object)MessageFormat.format("Cannot set value [{0}] into a char.", value));
            return Character.valueOf(value.charAt(0));
        }
        if (Byte.class.equals(targetType) || Byte.TYPE.equals(targetType)) {
            return Byte.parseByte(value);
        }
        if (Short.class.equals(targetType) || Short.TYPE.equals(targetType)) {
            return Short.parseShort(value);
        }
        if (Integer.class.equals(targetType) || Integer.TYPE.equals(targetType)) {
            return Integer.parseInt(value);
        }
        if (Long.class.equals(targetType) || Long.TYPE.equals(targetType)) {
            return Long.parseLong(value);
        }
        if (Float.class.equals(targetType) || Float.TYPE.equals(targetType)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class.equals(targetType) || Double.TYPE.equals(targetType)) {
            return Double.parseDouble(value);
        }
        throw new IllegalArgumentException(MessageFormat.format("Cannot deserialize path variable [{0}] into [{1}]", value, targetType.getName()));
    }
}

