/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.AssignableVMs;
import com.netflix.fenzo.AssignmentFailure;
import com.netflix.fenzo.ConstraintEvaluator;
import com.netflix.fenzo.ConstraintFailure;
import com.netflix.fenzo.PreferentialNamedConsumableResourceSet;
import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTracker;
import com.netflix.fenzo.TaskTrackerState;
import com.netflix.fenzo.VMAssignmentResult;
import com.netflix.fenzo.VMResource;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.functions.Action1;
import com.netflix.fenzo.plugins.ExclusiveHostConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AssignableVirtualMachine
implements Comparable<AssignableVirtualMachine> {
    static final String PseuoHostNamePrefix = "FenzoPsueodHost-";
    private final Map<String, VirtualMachineLease> leasesMap;
    private final BlockingQueue<String> workersToUnAssign;
    private final BlockingQueue<String> leasesToExpire;
    private final AtomicBoolean expireAllLeasesNow;
    private final Action1<VirtualMachineLease> leaseRejectAction;
    private final long leaseOfferExpirySecs;
    private final String hostname;
    private final Map<String, Double> currTotalScalars = new HashMap<String, Double>();
    private final Map<String, Double> currUsedScalars = new HashMap<String, Double>();
    private double currTotalCpus = 0.0;
    private double currUsedCpus = 0.0;
    private double currTotalMemory = 0.0;
    private double currUsedMemory = 0.0;
    private double currTotalNetworkMbps = 0.0;
    private double currUsedNetworkMbps = 0.0;
    private double currTotalDisk = 0.0;
    private double currUsedDisk = 0.0;
    private VirtualMachineLease currTotalLease = null;
    private PortRanges currPortRanges = new PortRanges();
    private volatile Map<String, Protos.Attribute> currAttributesMap = Collections.emptyMap();
    private final Map<String, PreferentialNamedConsumableResourceSet> resourceSets = new HashMap<String, PreferentialNamedConsumableResourceSet>();
    private final Map<String, TaskRequest> previouslyAssignedTasksMap;
    private final Map<TaskRequest, TaskAssignmentResult> assignmentResults;
    private static final Logger logger = LoggerFactory.getLogger(AssignableVirtualMachine.class);
    private final ConcurrentMap<String, String> leaseIdToHostnameMap;
    private final ConcurrentMap<String, String> vmIdToHostnameMap;
    private String currVMId = null;
    private final TaskTracker taskTracker;
    private volatile long disabledUntil = 0L;
    private static double softConstraintFitnessWeightPercentage = 50.0;
    private static double rSetsFitnessWeightPercentage = 15.0;
    private String exclusiveTaskId = null;
    private final boolean singleLeaseMode;
    private boolean firstLeaseAdded = false;
    private final List<TaskRequest> consumedResourcesToAssign = new ArrayList<TaskRequest>();

    public AssignableVirtualMachine(ConcurrentMap<String, String> vmIdToHostnameMap, ConcurrentMap<String, String> leaseIdToHostnameMap, String hostname, Action1<VirtualMachineLease> leaseRejectAction, long leaseOfferExpirySecs, TaskTracker taskTracker) {
        this(vmIdToHostnameMap, leaseIdToHostnameMap, hostname, leaseRejectAction, leaseOfferExpirySecs, taskTracker, false);
    }

    public AssignableVirtualMachine(ConcurrentMap<String, String> vmIdToHostnameMap, ConcurrentMap<String, String> leaseIdToHostnameMap, String hostname, Action1<VirtualMachineLease> leaseRejectAction, long leaseOfferExpirySecs, TaskTracker taskTracker, boolean singleLeaseMode) {
        this.vmIdToHostnameMap = vmIdToHostnameMap;
        this.leaseIdToHostnameMap = leaseIdToHostnameMap;
        this.hostname = hostname;
        this.leaseRejectAction = this.getWrappedLeaseRejectAction(leaseRejectAction);
        this.leaseOfferExpirySecs = leaseOfferExpirySecs;
        this.taskTracker = taskTracker;
        this.leasesMap = new HashMap<String, VirtualMachineLease>();
        this.leasesToExpire = new LinkedBlockingQueue<String>();
        this.expireAllLeasesNow = new AtomicBoolean(false);
        this.workersToUnAssign = new LinkedBlockingQueue<String>();
        this.previouslyAssignedTasksMap = new HashMap<String, TaskRequest>();
        this.assignmentResults = new HashMap<TaskRequest, TaskAssignmentResult>();
        this.singleLeaseMode = singleLeaseMode;
    }

    private Action1<VirtualMachineLease> getWrappedLeaseRejectAction(Action1<VirtualMachineLease> leaseRejectAction) {
        return leaseRejectAction == null ? lease -> logger.warn("No lease reject action registered to reject lease id " + lease.getId() + " on host " + lease.hostname()) : lease -> {
            if (this.isRejectable((VirtualMachineLease)lease)) {
                leaseRejectAction.call((VirtualMachineLease)lease);
            }
        };
    }

    private boolean isRejectable(VirtualMachineLease l) {
        return l != null && l.getOffer() != null;
    }

    private void addToAvailableResources(VirtualMachineLease l) {
        if (this.singleLeaseMode && this.firstLeaseAdded) {
            return;
        }
        this.firstLeaseAdded = true;
        Map<String, Double> scalars = l.getScalarValues();
        if (scalars != null && !scalars.isEmpty()) {
            for (Map.Entry<String, Double> entry : scalars.entrySet()) {
                Double currVal = this.currTotalScalars.get(entry.getKey());
                if (currVal == null) {
                    currVal = 0.0;
                }
                this.currTotalScalars.put(entry.getKey(), currVal + entry.getValue());
            }
        }
        this.currTotalCpus += l.cpuCores();
        this.currTotalMemory += l.memoryMB();
        this.currTotalNetworkMbps += l.networkMbps();
        this.currTotalDisk += l.diskMB();
        if (l.portRanges() != null) {
            this.currPortRanges.addRanges(l.portRanges());
        }
        if (l.getAttributeMap() != null) {
            this.currAttributesMap = Collections.unmodifiableMap(new HashMap<String, Protos.Attribute>(l.getAttributeMap()));
        }
        block15: for (Map.Entry<String, Double> entry : this.currAttributesMap.entrySet()) {
            block4 : switch (entry.getKey()) {
                case "res": {
                    String resName;
                    String val = ((Protos.Attribute)entry.getValue()).getText().getValue();
                    if (val == null) break;
                    StringTokenizer tokenizer = new StringTokenizer(val, "-");
                    switch (resName = tokenizer.nextToken()) {
                        case "ResourceSet": {
                            if (tokenizer.countTokens() == 3) {
                                String name = tokenizer.nextToken();
                                String val0Str = tokenizer.nextToken();
                                String val1Str = tokenizer.nextToken();
                                if (this.resourceSets.containsKey(name)) continue block15;
                                try {
                                    int val0 = Integer.parseInt(val0Str);
                                    int val1 = Integer.parseInt(val1Str);
                                    PreferentialNamedConsumableResourceSet crs = new PreferentialNamedConsumableResourceSet(name, val0, val1);
                                    Iterator<TaskRequest> iterator = this.consumedResourcesToAssign.iterator();
                                    while (iterator.hasNext()) {
                                        TaskRequest request = iterator.next();
                                        crs.assign(request);
                                        iterator.remove();
                                    }
                                    this.resourceSets.put(name, crs);
                                }
                                catch (NumberFormatException e) {
                                    logger.warn(this.hostname + ": invalid resource spec (" + val + ") in attributes, ignoring: " + e.getMessage());
                                }
                                break block4;
                            }
                            logger.warn("Invalid res spec (expected 4 tokens with delimiter '-', ignoring: " + val);
                            break block4;
                        }
                        default: {
                            logger.warn("Unknown resource in attributes, ignoring: " + val);
                        }
                    }
                }
            }
        }
        if (!this.consumedResourcesToAssign.isEmpty()) {
            throw new IllegalStateException(this.hostname + ": Some assigned tasks have no resource sets in offers: " + this.consumedResourcesToAssign);
        }
    }

    void updateCurrTotalLease() {
        this.currTotalLease = this.createTotaledLease();
    }

    void resetResources() {
        if (!this.singleLeaseMode) {
            this.currTotalCpus = 0.0;
            this.currTotalMemory = 0.0;
            this.currTotalNetworkMbps = 0.0;
            this.currTotalDisk = 0.0;
            this.currPortRanges.clear();
            this.currTotalScalars.clear();
        }
        this.currUsedCpus = 0.0;
        this.currUsedMemory = 0.0;
        this.currUsedNetworkMbps = 0.0;
        this.currUsedDisk = 0.0;
        this.currUsedScalars.clear();
        for (VirtualMachineLease l : this.leasesMap.values()) {
            this.addToAvailableResources(l);
        }
    }

    VirtualMachineLease getCurrTotalLease() {
        return this.currTotalLease;
    }

    private VirtualMachineLease createTotaledLease() {
        return new VirtualMachineLease(){

            @Override
            public String getId() {
                return "InternalVMLeaseObject";
            }

            @Override
            public long getOfferedTime() {
                return System.currentTimeMillis();
            }

            @Override
            public String hostname() {
                return AssignableVirtualMachine.this.hostname;
            }

            @Override
            public String getVMID() {
                return "NoVMID-InternalVMLease";
            }

            @Override
            public double cpuCores() {
                return AssignableVirtualMachine.this.currTotalCpus;
            }

            @Override
            public double memoryMB() {
                return AssignableVirtualMachine.this.currTotalMemory;
            }

            @Override
            public double networkMbps() {
                return AssignableVirtualMachine.this.currTotalNetworkMbps;
            }

            @Override
            public double diskMB() {
                return AssignableVirtualMachine.this.currTotalDisk;
            }

            @Override
            public List<VirtualMachineLease.Range> portRanges() {
                return Collections.unmodifiableList(AssignableVirtualMachine.this.currPortRanges.getRanges());
            }

            @Override
            public Protos.Offer getOffer() {
                return null;
            }

            @Override
            public Map<String, Protos.Attribute> getAttributeMap() {
                return AssignableVirtualMachine.this.currAttributesMap;
            }

            @Override
            public Double getScalarValue(String name) {
                return (Double)AssignableVirtualMachine.this.currTotalScalars.get(name);
            }

            @Override
            public Map<String, Double> getScalarValues() {
                return Collections.unmodifiableMap(AssignableVirtualMachine.this.currTotalScalars);
            }
        };
    }

    void removeExpiredLeases(boolean all) {
        this.removeExpiredLeases(all, true);
    }

    void removeExpiredLeases(boolean all, boolean doRejectCallback) {
        boolean expireAll;
        HashSet leasesToExpireIds = new HashSet();
        this.leasesToExpire.drainTo(leasesToExpireIds);
        Iterator<Map.Entry<String, VirtualMachineLease>> iterator = this.leasesMap.entrySet().iterator();
        boolean bl = expireAll = this.expireAllLeasesNow.getAndSet(false) || all;
        while (iterator.hasNext()) {
            VirtualMachineLease l = iterator.next().getValue();
            if (!expireAll && !leasesToExpireIds.contains(l.getId())) continue;
            this.leaseIdToHostnameMap.remove(l.getId());
            if (expireAll) {
                if (logger.isDebugEnabled()) {
                    logger.debug(this.hostname + ": expiring lease offer id " + l.getId());
                }
                if (doRejectCallback) {
                    this.leaseRejectAction.call(l);
                }
            }
            iterator.remove();
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Removed lease on {}, all={}", (Object)this.hostname, (Object)all);
        }
        if (expireAll && !this.hasPreviouslyAssignedTasks()) {
            this.resourceSets.clear();
        }
    }

    int expireLimitedLeases(AssignableVMs.VMRejectLimiter vmRejectLimiter) {
        if (this.singleLeaseMode) {
            return 0;
        }
        long now = System.currentTimeMillis();
        for (VirtualMachineLease l : this.leasesMap.values()) {
            if (!this.isRejectable(l) || l.getOfferedTime() >= now - this.leaseOfferExpirySecs * 1000L || !vmRejectLimiter.reject()) continue;
            for (VirtualMachineLease vml : this.leasesMap.values()) {
                this.leaseIdToHostnameMap.remove(vml.getId());
                if (logger.isDebugEnabled()) {
                    logger.debug(this.getHostname() + ": expiring lease offer id " + l.getId());
                }
                this.leaseRejectAction.call(vml);
            }
            int size = this.leasesMap.values().size();
            this.leasesMap.clear();
            if (logger.isDebugEnabled()) {
                logger.debug(this.hostname + ": cleared leases");
            }
            return size;
        }
        return 0;
    }

    String getCurrVMId() {
        return this.currVMId;
    }

    boolean addLease(VirtualMachineLease lease) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: adding lease id {}", (Object)this.hostname, (Object)lease.getId());
        }
        if (this.singleLeaseMode && this.firstLeaseAdded) {
            return false;
        }
        if (!Objects.equals(this.currVMId, lease.getVMID())) {
            this.currVMId = lease.getVMID();
            this.vmIdToHostnameMap.put(lease.getVMID(), this.hostname);
        }
        if (System.currentTimeMillis() < this.disabledUntil) {
            this.leaseRejectAction.call(lease);
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.hostname + ": adding to internal leases map");
        }
        if (this.leasesMap.get(lease.getId()) != null) {
            throw new IllegalStateException("Attempt to add duplicate lease with id=" + lease.getId());
        }
        if (this.leaseIdToHostnameMap.putIfAbsent(lease.getId(), this.hostname) != null) {
            logger.warn("Unexpected to add a lease that already exists for host " + this.hostname + ", lease ID: " + lease.getId());
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getHostname() + ": adding lease offer id " + lease.getId());
        }
        this.leasesMap.put(lease.getId(), lease);
        this.addToAvailableResources(lease);
        return true;
    }

    void setDisabledUntil(long disabledUntil) {
        this.disabledUntil = disabledUntil;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: disabling for {} mSecs", (Object)this.hostname, (Object)(disabledUntil - System.currentTimeMillis()));
        }
        Iterator<Map.Entry<String, VirtualMachineLease>> entriesIterator = this.leasesMap.entrySet().iterator();
        while (entriesIterator.hasNext()) {
            Map.Entry<String, VirtualMachineLease> entry = entriesIterator.next();
            this.leaseIdToHostnameMap.remove(entry.getValue().getId());
            this.leaseRejectAction.call(entry.getValue());
            entriesIterator.remove();
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Removed lease on " + this.hostname + " due to being disabled");
        }
    }

    public void enable() {
        this.disabledUntil = 0L;
    }

    long getDisabledUntil() {
        return this.disabledUntil;
    }

    boolean isActive() {
        return !this.leasesMap.isEmpty() || this.hasPreviouslyAssignedTasks() || !this.assignmentResults.isEmpty() || !this.leasesToExpire.isEmpty() || !this.workersToUnAssign.isEmpty() || System.currentTimeMillis() < this.disabledUntil;
    }

    boolean isAssignableNow() {
        return !this.isDisabled() && !this.leasesMap.isEmpty();
    }

    boolean isDisabled() {
        return System.currentTimeMillis() < this.disabledUntil;
    }

    void setAssignedTask(TaskRequest request) {
        boolean added;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: setting assigned task {}", (Object)this.hostname, (Object)request.getId());
        }
        if (added = this.taskTracker.addRunningTask(request, this)) {
            this.assignResourceSets(request);
        } else {
            logger.error("Unexpected to add duplicate task id=" + request.getId());
        }
        this.previouslyAssignedTasksMap.put(request.getId(), request);
        this.setIfExclusive(request);
        if (this.singleLeaseMode && added) {
            this.removeResourcesOf(request);
        }
    }

    private void assignResourceSets(TaskRequest request) {
        List<PreferentialNamedConsumableResourceSet.ConsumeResult> consumedNamedResources;
        if (request.getAssignedResources() != null && (consumedNamedResources = request.getAssignedResources().getConsumedNamedResources()) != null && !consumedNamedResources.isEmpty()) {
            for (PreferentialNamedConsumableResourceSet.ConsumeResult cr : consumedNamedResources) {
                if (this.resourceSets.get(cr.getAttrName()) == null) {
                    this.consumedResourcesToAssign.add(request);
                    continue;
                }
                this.resourceSets.get(cr.getAttrName()).assign(request);
            }
        }
    }

    void expireLease(String leaseId) {
        logger.info("Got request to expire lease on " + this.hostname);
        this.leasesToExpire.offer(leaseId);
    }

    void expireAllLeases() {
        this.expireAllLeasesNow.set(true);
    }

    void markTaskForUnassigning(String taskId) {
        this.workersToUnAssign.offer(taskId);
    }

    private void setIfExclusive(TaskRequest request) {
        if (request.getHardConstraints() != null) {
            for (ConstraintEvaluator constraintEvaluator : request.getHardConstraints()) {
                if (!(constraintEvaluator instanceof ExclusiveHostConstraint)) continue;
                this.exclusiveTaskId = request.getId();
                return;
            }
        }
    }

    private void clearIfExclusive(String taskId) {
        if (taskId.equals(this.exclusiveTaskId)) {
            this.exclusiveTaskId = null;
        }
    }

    void prepareForScheduling() {
        ArrayList tasks = new ArrayList();
        this.workersToUnAssign.drainTo(tasks);
        for (String t : tasks) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: removing previously assigned task {}", (Object)this.hostname, (Object)t);
            }
            this.taskTracker.removeRunningTask(t);
            TaskRequest r = this.previouslyAssignedTasksMap.remove(t);
            if (this.singleLeaseMode && r != null) {
                this.addBackResourcesOf(r);
            }
            this.releaseResourceSets(r);
            this.clearIfExclusive(t);
        }
        this.assignmentResults.clear();
    }

    private void releaseResourceSets(TaskRequest r) {
        if (r == null) {
            logger.warn("Can't release resource sets for null task");
            return;
        }
        Map<String, TaskRequest.NamedResourceSetRequest> customNamedResources = r.getCustomNamedResources();
        for (Map.Entry<String, PreferentialNamedConsumableResourceSet> entry : this.resourceSets.entrySet()) {
            entry.getValue().release(r);
        }
    }

    private void removeResourcesOf(TaskRequest request) {
        this.currTotalCpus -= request.getCPUs();
        this.currTotalMemory -= request.getMemory();
        this.currTotalDisk -= request.getDisk();
        this.currTotalNetworkMbps -= request.getNetworkMbps();
        Map<String, Double> scalarRequests = request.getScalarRequests();
        if (scalarRequests != null && !scalarRequests.isEmpty()) {
            for (Map.Entry<String, Double> entry : scalarRequests.entrySet()) {
                Double oldVal = this.currTotalScalars.get(entry.getKey());
                if (oldVal == null) continue;
                double newVal = oldVal - entry.getValue();
                if (newVal < 0.0) {
                    logger.warn(this.hostname + ": Scalar resource " + entry.getKey() + " is " + newVal + " after removing " + entry.getValue() + " from task " + request.getId());
                    this.currTotalScalars.put(entry.getKey(), 0.0);
                    continue;
                }
                this.currTotalScalars.put(entry.getKey(), newVal);
            }
        }
    }

    private void addBackResourcesOf(TaskRequest r) {
        this.currTotalCpus += r.getCPUs();
        this.currTotalMemory += r.getMemory();
        this.currTotalNetworkMbps += r.getNetworkMbps();
        this.currTotalDisk += r.getDisk();
        Map<String, Double> scalarRequests = r.getScalarRequests();
        if (scalarRequests != null && !scalarRequests.isEmpty()) {
            for (Map.Entry<String, Double> entry : scalarRequests.entrySet()) {
                Double oldVal = this.currTotalScalars.get(entry.getKey());
                if (oldVal == null) {
                    oldVal = 0.0;
                }
                this.currTotalScalars.put(entry.getKey(), oldVal + entry.getValue());
            }
        }
    }

    String getAttrValue(String attrName) {
        if (this.getCurrTotalLease() == null) {
            return null;
        }
        Protos.Attribute attribute = this.getCurrTotalLease().getAttributeMap().get(attrName);
        if (attribute == null) {
            return null;
        }
        return attribute.getText().getValue();
    }

    Map<String, Double> getMaxScalars() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        if (this.currTotalScalars != null) {
            for (Map.Entry entry : this.currTotalScalars.entrySet()) {
                result.put((String)entry.getKey(), (Double)entry.getValue());
            }
        }
        if (this.hasPreviouslyAssignedTasks()) {
            for (TaskRequest taskRequest : this.previouslyAssignedTasksMap.values()) {
                Map<String, Double> scalarRequests = taskRequest.getScalarRequests();
                if (scalarRequests == null || scalarRequests.isEmpty()) continue;
                for (Map.Entry<String, Double> e : scalarRequests.entrySet()) {
                    if (result.get(e.getKey()) == null) {
                        result.put(e.getKey(), e.getValue());
                        continue;
                    }
                    result.put(e.getKey(), e.getValue() + (Double)result.get(e.getKey()));
                }
            }
        }
        return result;
    }

    Map<VMResource, Double> getMaxResources() {
        double cpus = 0.0;
        double memory = 0.0;
        double network = 0.0;
        double ports = 0.0;
        double disk = 0.0;
        for (TaskRequest taskRequest : this.previouslyAssignedTasksMap.values()) {
            cpus += taskRequest.getCPUs();
            memory += taskRequest.getMemory();
            network += taskRequest.getNetworkMbps();
            ports += (double)taskRequest.getPorts();
            disk += taskRequest.getDisk();
        }
        cpus += this.getCurrTotalLease().cpuCores();
        memory += this.getCurrTotalLease().memoryMB();
        network += this.getCurrTotalLease().networkMbps();
        List<VirtualMachineLease.Range> ranges = this.getCurrTotalLease().portRanges();
        for (VirtualMachineLease.Range r : ranges) {
            ports += (double)(r.getEnd() - r.getBeg());
        }
        disk += this.getCurrTotalLease().diskMB();
        HashMap<VMResource, Double> hashMap = new HashMap<VMResource, Double>();
        hashMap.put(VMResource.CPU, cpus);
        hashMap.put(VMResource.Memory, memory);
        hashMap.put(VMResource.Network, network);
        hashMap.put(VMResource.Ports, ports);
        hashMap.put(VMResource.Disk, disk);
        return hashMap;
    }

    TaskAssignmentResult tryRequest(TaskRequest request, VMTaskFitnessCalculator fitnessCalculator) {
        TaskTrackerState taskTrackerState;
        if (logger.isDebugEnabled()) {
            logger.debug("Host {} task {}: #leases: {}", new Object[]{this.getHostname(), request.getId(), this.leasesMap.size()});
        }
        if (this.leasesMap.isEmpty()) {
            return null;
        }
        if (this.exclusiveTaskId != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Host {}: can't assign task {}, already have task {} assigned with exclusive host constraint", new Object[]{this.hostname, request.getId(), this.exclusiveTaskId});
            }
            ConstraintFailure failure = new ConstraintFailure(ExclusiveHostConstraint.class.getName(), "Already has task " + this.exclusiveTaskId + " with exclusive host constraint");
            return new TaskAssignmentResult(this, request, false, null, failure, 0.0);
        }
        VirtualMachineCurrentState vmCurrentState = this.vmCurrentState();
        ConstraintFailure failedHardConstraint = this.findFailedHardConstraints(request, vmCurrentState, taskTrackerState = this.taskTrackerState());
        if (failedHardConstraint != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Host {}: task {} failed hard constraint: ", new Object[]{this.hostname, request.getId(), failedHardConstraint});
            }
            return new TaskAssignmentResult(this, request, false, null, failedHardConstraint, 0.0);
        }
        ResAsgmntResult resAsgmntResult = this.evalAndGetResourceAssignmentFailures(request);
        if (!resAsgmntResult.failures.isEmpty()) {
            if (logger.isDebugEnabled()) {
                StringBuilder b = new StringBuilder();
                for (AssignmentFailure f : resAsgmntResult.failures) {
                    b.append(f.toString()).append(" ; ");
                }
                logger.debug("{}: task {} failed assignment: {}", new Object[]{this.hostname, request.getId(), b.toString()});
            }
            return new TaskAssignmentResult(this, request, false, resAsgmntResult.failures, null, 0.0);
        }
        double resAsgmntFitness = resAsgmntResult.fitness;
        double fitness = fitnessCalculator.calculateFitness(request, vmCurrentState, taskTrackerState);
        if (fitness == 0.0) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: task {} fitness calculator returned 0.0", (Object)this.hostname, (Object)request.getId());
            }
            List<AssignmentFailure> failures = Collections.singletonList(new AssignmentFailure(VMResource.Fitness, 0.0, 0.0, 0.0, "fitnessCalculator: 0.0"));
            return new TaskAssignmentResult(this, request, false, failures, null, fitness);
        }
        List<? extends VMTaskFitnessCalculator> softConstraints = request.getSoftConstraints();
        double softConstraintFitness = 1.0;
        if (softConstraints != null && !softConstraints.isEmpty()) {
            softConstraintFitness = this.getSoftConstraintsFitness(request, vmCurrentState, taskTrackerState);
        }
        fitness = this.combineFitnessValues(resAsgmntFitness, fitness, softConstraintFitness);
        return new TaskAssignmentResult(this, request, true, null, null, fitness);
    }

    private double combineFitnessValues(double resAsgmntFitness, double fitness, double softConstraintFitness) {
        return (resAsgmntFitness * rSetsFitnessWeightPercentage + softConstraintFitness * softConstraintFitnessWeightPercentage + fitness * (100.0 - rSetsFitnessWeightPercentage - softConstraintFitnessWeightPercentage)) / 100.0;
    }

    private double getSoftConstraintsFitness(TaskRequest request, VirtualMachineCurrentState vmCurrentState, TaskTrackerState taskTrackerState) {
        List<? extends VMTaskFitnessCalculator> softConstraints = request.getSoftConstraints();
        int n = 0;
        double sum = 0.0;
        for (VMTaskFitnessCalculator vMTaskFitnessCalculator : softConstraints) {
            ++n;
            sum += vMTaskFitnessCalculator.calculateFitness(request, vmCurrentState, taskTrackerState);
        }
        return sum / (double)n;
    }

    private ResAsgmntResult evalAndGetResourceAssignmentFailures(TaskRequest request) {
        AssignmentFailure failure;
        ArrayList<AssignmentFailure> failures = new ArrayList<AssignmentFailure>();
        Map<String, Double> scalarRequests = request.getScalarRequests();
        if (scalarRequests != null && !scalarRequests.isEmpty()) {
            for (Map.Entry<String, Double> entry : scalarRequests.entrySet()) {
                Double t;
                if (entry.getValue() == null) continue;
                Double u = this.currUsedScalars.get(entry.getKey());
                if (u == null) {
                    u = 0.0;
                }
                if ((t = this.currTotalScalars.get(entry.getKey())) == null) {
                    t = 0.0;
                }
                if (!(u + entry.getValue() > t)) continue;
                failures.add(new AssignmentFailure(VMResource.Other, entry.getValue(), u, t, entry.getKey()));
            }
        }
        if (this.currUsedCpus + request.getCPUs() > this.currTotalCpus) {
            failure = new AssignmentFailure(VMResource.CPU, request.getCPUs(), this.currUsedCpus, this.currTotalCpus, "");
            failures.add(failure);
        }
        if (this.currUsedMemory + request.getMemory() > this.currTotalMemory) {
            failure = new AssignmentFailure(VMResource.Memory, request.getMemory(), this.currUsedMemory, this.currTotalMemory, "");
            failures.add(failure);
        }
        if (this.currUsedNetworkMbps + request.getNetworkMbps() > this.currTotalNetworkMbps) {
            failure = new AssignmentFailure(VMResource.Network, request.getNetworkMbps(), this.currUsedNetworkMbps, this.currTotalNetworkMbps, "");
            failures.add(failure);
        }
        if (this.currUsedDisk + request.getDisk() > this.currTotalDisk) {
            failure = new AssignmentFailure(VMResource.Disk, request.getDisk(), this.currUsedDisk, this.currTotalDisk, "");
            failures.add(failure);
        }
        if (!this.currPortRanges.hasPorts(request.getPorts())) {
            failure = new AssignmentFailure(VMResource.Ports, request.getPorts(), this.currPortRanges.currUsedPorts, this.currPortRanges.totalPorts, "");
            failures.add(failure);
        }
        double rSetFitness = 0.0;
        int numRSets = 0;
        HashSet requestedNamedResNames = new HashSet(request.getCustomNamedResources() == null ? Collections.emptySet() : request.getCustomNamedResources().keySet());
        if (failures.isEmpty()) {
            for (Map.Entry<String, PreferentialNamedConsumableResourceSet> entry : this.resourceSets.entrySet()) {
                double fitness;
                if (!requestedNamedResNames.isEmpty()) {
                    requestedNamedResNames.remove(entry.getKey());
                }
                if ((fitness = entry.getValue().getFitness(request)) == 0.0) {
                    AssignmentFailure failure2 = new AssignmentFailure(VMResource.ResourceSet, 0.0, 0.0, 0.0, "ResourceSet " + entry.getValue().getName() + " unavailable");
                    failures.add(failure2);
                    continue;
                }
                rSetFitness += fitness;
                ++numRSets;
            }
            if (!requestedNamedResNames.isEmpty()) {
                AssignmentFailure failure3 = new AssignmentFailure(VMResource.ResourceSet, 0.0, 0.0, 0.0, "UnavailableResourceSets: " + requestedNamedResNames);
                failures.add(failure3);
            } else if (!failures.isEmpty()) {
                rSetFitness = 0.0;
            } else if (numRSets > 1) {
                rSetFitness /= (double)numRSets;
            }
        }
        return new ResAsgmntResult(failures, rSetFitness);
    }

    private TaskTrackerState taskTrackerState() {
        return new TaskTrackerState(){

            @Override
            public Map<String, TaskTracker.ActiveTask> getAllRunningTasks() {
                return AssignableVirtualMachine.this.taskTracker.getAllRunningTasks();
            }

            @Override
            public Map<String, TaskTracker.ActiveTask> getAllCurrentlyAssignedTasks() {
                return AssignableVirtualMachine.this.taskTracker.getAllAssignedTasks();
            }
        };
    }

    VirtualMachineCurrentState getVmCurrentState() {
        final LinkedList<Protos.Offer> offers = new LinkedList<Protos.Offer>();
        for (VirtualMachineLease l : this.leasesMap.values()) {
            offers.add(l.getOffer());
        }
        return new VirtualMachineCurrentState(){

            @Override
            public String getHostname() {
                return AssignableVirtualMachine.this.hostname;
            }

            @Override
            public Map<String, PreferentialNamedConsumableResourceSet> getResourceSets() {
                return AssignableVirtualMachine.this.resourceSets;
            }

            @Override
            public VirtualMachineLease getCurrAvailableResources() {
                return AssignableVirtualMachine.this.currTotalLease;
            }

            @Override
            public Collection<Protos.Offer> getAllCurrentOffers() {
                System.out.println("****************************** ");
                return offers;
            }

            @Override
            public Collection<TaskAssignmentResult> getTasksCurrentlyAssigned() {
                return Collections.emptyList();
            }

            @Override
            public Collection<TaskRequest> getRunningTasks() {
                return Collections.unmodifiableCollection(AssignableVirtualMachine.this.previouslyAssignedTasksMap.values());
            }

            @Override
            public long getDisabledUntil() {
                return AssignableVirtualMachine.this.disabledUntil;
            }
        };
    }

    private VirtualMachineCurrentState vmCurrentState() {
        final LinkedList<Protos.Offer> offers = new LinkedList<Protos.Offer>();
        for (VirtualMachineLease l : this.leasesMap.values()) {
            offers.add(l.getOffer());
        }
        return new VirtualMachineCurrentState(){

            @Override
            public String getHostname() {
                return AssignableVirtualMachine.this.hostname;
            }

            @Override
            public Map<String, PreferentialNamedConsumableResourceSet> getResourceSets() {
                return AssignableVirtualMachine.this.resourceSets;
            }

            @Override
            public VirtualMachineLease getCurrAvailableResources() {
                return AssignableVirtualMachine.this.currTotalLease;
            }

            @Override
            public Collection<Protos.Offer> getAllCurrentOffers() {
                return offers;
            }

            @Override
            public Collection<TaskAssignmentResult> getTasksCurrentlyAssigned() {
                return Collections.unmodifiableCollection(AssignableVirtualMachine.this.assignmentResults.values());
            }

            @Override
            public Collection<TaskRequest> getRunningTasks() {
                return Collections.unmodifiableCollection(AssignableVirtualMachine.this.previouslyAssignedTasksMap.values());
            }

            @Override
            public long getDisabledUntil() {
                return AssignableVirtualMachine.this.disabledUntil;
            }
        };
    }

    private ConstraintFailure findFailedHardConstraints(TaskRequest request, VirtualMachineCurrentState vmCurrentState, TaskTrackerState taskTrackerState) {
        List<? extends ConstraintEvaluator> hardConstraints = request.getHardConstraints();
        if (hardConstraints == null || hardConstraints.isEmpty()) {
            return null;
        }
        for (ConstraintEvaluator constraintEvaluator : hardConstraints) {
            ConstraintEvaluator.Result r = constraintEvaluator.evaluate(request, vmCurrentState, taskTrackerState);
            if (r.isSuccessful()) continue;
            return new ConstraintFailure(constraintEvaluator.getName(), r.getFailureReason());
        }
        return null;
    }

    String getHostname() {
        return this.hostname;
    }

    boolean hasPreviouslyAssignedTasks() {
        return !this.previouslyAssignedTasksMap.isEmpty();
    }

    void assignResult(TaskAssignmentResult result) {
        Map<String, Double> scalarRequests = result.getRequest().getScalarRequests();
        if (scalarRequests != null && !scalarRequests.isEmpty()) {
            for (Map.Entry<String, Double> entry : scalarRequests.entrySet()) {
                if (entry.getValue() == null) continue;
                Double u = this.currUsedScalars.get(entry.getKey());
                if (u == null) {
                    u = 0.0;
                }
                this.currUsedScalars.put(entry.getKey(), u + entry.getValue());
            }
        }
        this.currUsedCpus += result.getRequest().getCPUs();
        this.currUsedMemory += result.getRequest().getMemory();
        this.currUsedNetworkMbps += result.getRequest().getNetworkMbps();
        this.currUsedDisk += result.getRequest().getDisk();
        for (int p = 0; p < result.getRequest().getPorts(); ++p) {
            result.addPort(this.currPortRanges.consumeNextPort());
        }
        for (Map.Entry<String, PreferentialNamedConsumableResourceSet> entry : this.resourceSets.entrySet()) {
            result.addResourceSet(entry.getValue().consume(result.getRequest()));
        }
        if (!this.taskTracker.addAssignedTask(result.getRequest(), this)) {
            logger.error("Unexpected to re-add task to assigned state, id=" + result.getRequest().getId());
        }
        this.assignmentResults.put(result.getRequest(), result);
    }

    VMAssignmentResult resetAndGetSuccessfullyAssignedRequests() {
        if (this.assignmentResults.isEmpty()) {
            return null;
        }
        HashSet<TaskAssignmentResult> result = new HashSet<TaskAssignmentResult>();
        for (Map.Entry<TaskRequest, TaskAssignmentResult> entry : this.assignmentResults.entrySet()) {
            if (!entry.getValue().isSuccessful()) continue;
            result.add(entry.getValue());
        }
        if (result.isEmpty()) {
            return null;
        }
        VMAssignmentResult vmar = new VMAssignmentResult(this.hostname, new ArrayList<VirtualMachineLease>(this.leasesMap.values()), result);
        if (!this.singleLeaseMode) {
            for (String l : this.leasesMap.keySet()) {
                this.leaseIdToHostnameMap.remove(l);
            }
            this.leasesMap.clear();
        }
        this.assignmentResults.clear();
        return vmar;
    }

    @Override
    public int compareTo(AssignableVirtualMachine o) {
        if (o == null) {
            return -1;
        }
        if (o.leasesMap.isEmpty()) {
            return -1;
        }
        if (this.leasesMap.isEmpty()) {
            return 1;
        }
        return Double.compare(o.currTotalCpus, this.currTotalCpus);
    }

    Map<VMResource, Double[]> getResourceStatus() {
        HashMap<VMResource, Double[]> resourceMap = new HashMap<VMResource, Double[]>();
        double cpusUsed = 0.0;
        double memUsed = 0.0;
        double portsUsed = 0.0;
        double networkUsed = 0.0;
        double diskUsed = 0.0;
        for (TaskRequest r : this.previouslyAssignedTasksMap.values()) {
            cpusUsed += r.getCPUs();
            memUsed += r.getMemory();
            portsUsed += (double)r.getPorts();
            networkUsed += r.getNetworkMbps();
            diskUsed += r.getDisk();
        }
        double cpusAvail = 0.0;
        double memAvail = 0.0;
        double portsAvail = 0.0;
        double networkAvail = 0.0;
        double diskAvail = 0.0;
        for (VirtualMachineLease l : this.leasesMap.values()) {
            cpusAvail += l.cpuCores();
            memAvail += l.memoryMB();
            for (VirtualMachineLease.Range range : l.portRanges()) {
                portsAvail += (double)(range.getEnd() - range.getBeg());
            }
            networkAvail += l.networkMbps();
            diskAvail += l.diskMB();
        }
        resourceMap.put(VMResource.CPU, new Double[]{cpusUsed, cpusAvail});
        resourceMap.put(VMResource.Memory, new Double[]{memUsed, memAvail});
        resourceMap.put(VMResource.Ports, new Double[]{portsUsed, portsAvail});
        resourceMap.put(VMResource.Network, new Double[]{networkUsed, networkAvail});
        resourceMap.put(VMResource.Disk, new Double[]{diskUsed, diskAvail});
        for (PreferentialNamedConsumableResourceSet rSet : this.resourceSets.values()) {
            String name = rSet.getName();
            List<Double> usedCounts = rSet.getUsedCounts();
            int used = 0;
            for (Double c : usedCounts) {
                if (!(c >= 0.0)) continue;
                ++used;
            }
            resourceMap.put(VMResource.ResourceSet, new Double[]{used, usedCounts.size() - used});
        }
        return resourceMap;
    }

    private static class ResAsgmntResult {
        private final List<AssignmentFailure> failures;
        private final double fitness;

        public ResAsgmntResult(List<AssignmentFailure> failures, double fitness) {
            this.failures = failures;
            this.fitness = fitness;
        }
    }

    private static class PortRanges {
        private List<VirtualMachineLease.Range> ranges = new ArrayList<VirtualMachineLease.Range>();
        private List<PortRange> portRanges = new ArrayList<PortRange>();
        private int totalPorts = 0;
        private int currUsedPorts = 0;

        private PortRanges() {
        }

        void addRanges(List<VirtualMachineLease.Range> ranges) {
            if (ranges != null) {
                this.ranges.addAll(ranges);
                for (VirtualMachineLease.Range range : ranges) {
                    PortRange pRange = new PortRange(range);
                    this.portRanges.add(pRange);
                    this.totalPorts += pRange.size();
                }
            }
        }

        void clear() {
            this.ranges.clear();
            this.portRanges.clear();
            this.currUsedPorts = 0;
            this.totalPorts = 0;
        }

        private List<VirtualMachineLease.Range> getRanges() {
            return this.ranges;
        }

        boolean hasPorts(int num) {
            return num + this.currUsedPorts <= this.totalPorts;
        }

        private int consumeNextPort() {
            int forward = 0;
            for (PortRange range : this.portRanges) {
                if (forward + range.size() > this.currUsedPorts) {
                    return range.range.getBeg() + (this.currUsedPorts++ - forward);
                }
                forward += range.size();
            }
            throw new IllegalStateException("All ports (" + this.totalPorts + ") already used up");
        }
    }

    private static class PortRange {
        private final VirtualMachineLease.Range range;

        private PortRange(VirtualMachineLease.Range range) {
            this.range = range;
        }

        int size() {
            return this.range.getEnd() - this.range.getBeg() + 1;
        }
    }
}

