/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.ActiveVmGroups;
import com.netflix.fenzo.AssignableVirtualMachine;
import com.netflix.fenzo.AssignmentFailure;
import com.netflix.fenzo.AutoScaleRule;
import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTracker;
import com.netflix.fenzo.VMCollection;
import com.netflix.fenzo.VMResource;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.functions.Action1;
import com.netflix.fenzo.functions.Func1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AssignableVMs {
    private final VMCollection vmCollection;
    private static final Logger logger = LoggerFactory.getLogger(AssignableVMs.class);
    private final ConcurrentMap<String, String> leaseIdToHostnameMap = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> vmIdToHostnameMap = new ConcurrentHashMap<String, String>();
    private final BlockingQueue<HostDisablePair> disableRequests = new LinkedBlockingQueue<HostDisablePair>();
    private final TaskTracker taskTracker;
    private final String attrNameToGroupMaxResources;
    private final Map<String, Map<VMResource, Double>> maxResourcesMap;
    private final Map<VMResource, Double> totalResourcesMap;
    private final VMRejectLimiter vmRejectLimiter;
    private final AssignableVirtualMachine dummyVM = new AssignableVirtualMachine(null, null, "", null, 0L, null){

        @Override
        void assignResult(TaskAssignmentResult result) {
            throw new UnsupportedOperationException();
        }
    };
    private final ActiveVmGroups activeVmGroups;
    private String activeVmGroupAttributeName = null;
    private final BlockingQueue<String> unknownLeaseIdsToExpire = new LinkedBlockingQueue<String>();

    AssignableVMs(TaskTracker taskTracker, Action1<VirtualMachineLease> leaseRejectAction, long leaseOfferExpirySecs, int maxOffersToReject, String attrNameToGroupMaxResources, boolean singleLeaseMode, String autoScaleByAttributeName) {
        this.taskTracker = taskTracker;
        this.vmCollection = new VMCollection(hostname -> new AssignableVirtualMachine(this.vmIdToHostnameMap, this.leaseIdToHostnameMap, (String)hostname, leaseRejectAction, leaseOfferExpirySecs, taskTracker, singleLeaseMode), autoScaleByAttributeName);
        this.attrNameToGroupMaxResources = attrNameToGroupMaxResources;
        this.maxResourcesMap = new HashMap<String, Map<VMResource, Double>>();
        this.totalResourcesMap = new HashMap<VMResource, Double>();
        this.vmRejectLimiter = new VMRejectLimiter(maxOffersToReject, leaseOfferExpirySecs);
        this.activeVmGroups = new ActiveVmGroups();
    }

    VMCollection getVmCollection() {
        return this.vmCollection;
    }

    Map<String, List<String>> createPseudoHosts(Map<String, Integer> groupCounts, Func1<String, AutoScaleRule> ruleGetter) {
        return this.vmCollection.clonePseudoVMsForGroups(groupCounts, ruleGetter, lease -> lease != null && (lease.getAttributeMap() == null || lease.getAttributeMap().get(this.activeVmGroupAttributeName) == null || this.isInActiveVmGroup(lease.getAttributeMap().get(this.activeVmGroupAttributeName).getText().getValue())));
    }

    void removePseudoHosts(Map<String, List<String>> hostsMap) {
        if (hostsMap != null && !hostsMap.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : hostsMap.entrySet()) {
                for (String h : entry.getValue()) {
                    AssignableVirtualMachine avm = this.vmCollection.unsafeRemoveVm(h, entry.getKey());
                    if (avm == null) continue;
                    avm.removeExpiredLeases(true, false);
                }
            }
        }
    }

    Map<String, Map<VMResource, Double[]>> getResourceStatus() {
        HashMap<String, Map<VMResource, Double[]>> result = new HashMap<String, Map<VMResource, Double[]>>();
        for (AssignableVirtualMachine avm : this.vmCollection.getAllVMs()) {
            result.put(avm.getHostname(), avm.getResourceStatus());
        }
        return result;
    }

    void setTaskAssigned(TaskRequest request, String host) {
        this.vmCollection.getOrCreate(host).setAssignedTask(request);
    }

    void unAssignTask(String taskId, String host) {
        Optional<AssignableVirtualMachine> vmByName = this.vmCollection.getVmByName(host);
        if (vmByName.isPresent()) {
            vmByName.get().markTaskForUnassigning(taskId);
        } else {
            logger.warn("No VM for host " + host + " to unassign task " + taskId);
        }
    }

    private int addLeases(List<VirtualMachineLease> leases) {
        if (logger.isDebugEnabled()) {
            logger.debug("Adding leases");
        }
        for (AssignableVirtualMachine avm : this.vmCollection.getAllVMs()) {
            avm.resetResources();
        }
        int rejected = 0;
        for (VirtualMachineLease l : leases) {
            if (!this.vmCollection.addLease(l)) continue;
            ++rejected;
        }
        for (AssignableVirtualMachine avm : this.vmCollection.getAllVMs()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Updating total lease on " + avm.getHostname());
            }
            avm.updateCurrTotalLease();
            VirtualMachineLease currTotalLease = avm.getCurrTotalLease();
            if (!logger.isDebugEnabled()) continue;
            if (currTotalLease == null) {
                logger.debug("Updated total lease is null for " + avm.getHostname());
                continue;
            }
            logger.debug("Updated total lease for {} has cpu={}, mem={}, disk={}, network={}", new Object[]{avm.getHostname(), currTotalLease.cpuCores(), currTotalLease.memoryMB(), currTotalLease.diskMB(), currTotalLease.networkMbps()});
        }
        return rejected;
    }

    void expireLease(String leaseId) {
        String hostname = (String)this.leaseIdToHostnameMap.get(leaseId);
        if (hostname == null) {
            logger.debug("Received expiry request for an unknown lease: {}", (Object)leaseId);
            this.unknownLeaseIdsToExpire.offer(leaseId);
            return;
        }
        this.internalExpireLease(leaseId, hostname);
    }

    private void internalExpireLease(String leaseId, String hostname) {
        Optional<AssignableVirtualMachine> vmByName = this.vmCollection.getVmByName(hostname);
        if (vmByName.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Expiring lease offer id " + leaseId + " on host " + hostname);
            }
            vmByName.get().expireLease(leaseId);
        }
    }

    void expireAllLeases(String hostname) {
        Optional<AssignableVirtualMachine> vmByName = this.vmCollection.getVmByName(hostname);
        if (vmByName.isPresent()) {
            vmByName.get().expireAllLeases();
        }
    }

    void expireAllLeases() {
        for (AssignableVirtualMachine avm : this.vmCollection.getAllVMs()) {
            avm.expireAllLeases();
        }
    }

    void disableUntil(String host, long until) {
        this.disableRequests.offer(new HostDisablePair(host, until));
    }

    private void disableVMs() {
        if (this.disableRequests.peek() == null) {
            return;
        }
        LinkedList disablePairs = new LinkedList();
        this.disableRequests.drainTo(disablePairs);
        for (HostDisablePair hostDisablePair : disablePairs) {
            Optional<AssignableVirtualMachine> vmByName = this.vmCollection.getVmByName(hostDisablePair.host);
            if (!vmByName.isPresent()) continue;
            vmByName.get().setDisabledUntil(hostDisablePair.until);
        }
    }

    void enableVM(String host) {
        Optional<AssignableVirtualMachine> vmByName = this.vmCollection.getVmByName(host);
        if (vmByName.isPresent()) {
            vmByName.get().enable();
        } else {
            logger.warn("Can't enable host " + host + ", no such host");
        }
    }

    String getHostnameFromVMId(String vmId) {
        return (String)this.vmIdToHostnameMap.get(vmId);
    }

    void setActiveVmGroupAttributeName(String attributeName) {
        this.activeVmGroupAttributeName = attributeName;
    }

    void setActiveVmGroups(List<String> vmGroups) {
        this.activeVmGroups.setActiveVmGroups(vmGroups);
    }

    private boolean isInActiveVmGroup(AssignableVirtualMachine avm) {
        String attrValue = avm.getAttrValue(this.activeVmGroupAttributeName);
        return this.isInActiveVmGroup(attrValue);
    }

    private boolean isInActiveVmGroup(String attrValue) {
        return this.activeVmGroups.isActiveVmGroup(attrValue, false);
    }

    private void expireAnyUnknownLeaseIds() {
        ArrayList unknownExpiredLeases = new ArrayList();
        this.unknownLeaseIdsToExpire.drainTo(unknownExpiredLeases);
        for (String leaseId : unknownExpiredLeases) {
            String hostname = (String)this.leaseIdToHostnameMap.get(leaseId);
            if (hostname == null) continue;
            this.internalExpireLease(leaseId, hostname);
        }
    }

    List<AssignableVirtualMachine> prepareAndGetOrderedVMs(List<VirtualMachineLease> newLeases, AtomicInteger rejectedCount) {
        this.disableVMs();
        this.removeExpiredLeases();
        rejectedCount.addAndGet(this.addLeases(newLeases));
        this.expireAnyUnknownLeaseIds();
        ArrayList<AssignableVirtualMachine> vms = new ArrayList<AssignableVirtualMachine>();
        this.taskTracker.clearAssignedTasks();
        this.vmRejectLimiter.reset();
        this.resetTotalResources();
        for (AssignableVirtualMachine avm : this.vmCollection.getAllVMs()) {
            avm.prepareForScheduling();
            if (this.isInActiveVmGroup(avm) && avm.isAssignableNow()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Host " + avm.getHostname() + " available for assignments");
                }
                vms.add(avm);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Host " + avm.getHostname() + " not available for assignments");
            }
            this.saveMaxResources(avm);
            if (!this.isInActiveVmGroup(avm) || avm.isDisabled()) continue;
            this.addTotalResources(avm);
        }
        this.taskTracker.setTotalResources(this.totalResourcesMap);
        return vms;
    }

    List<AssignableVirtualMachine> getInactiveVMs() {
        return this.vmCollection.getAllVMs().stream().filter(avm -> !this.isInActiveVmGroup((AssignableVirtualMachine)avm)).collect(Collectors.toList());
    }

    private void resetTotalResources() {
        this.totalResourcesMap.clear();
    }

    private void addTotalResources(AssignableVirtualMachine avm) {
        Map<VMResource, Double> maxResources = avm.getMaxResources();
        for (VMResource r : maxResources.keySet()) {
            Double v = maxResources.get((Object)r);
            if (v == null) continue;
            if (this.totalResourcesMap.get((Object)r) == null) {
                this.totalResourcesMap.put(r, v);
                continue;
            }
            this.totalResourcesMap.put(r, this.totalResourcesMap.get((Object)r) + v);
        }
    }

    private void removeExpiredLeases() {
        for (AssignableVirtualMachine avm : this.vmCollection.getAllVMs()) {
            avm.removeExpiredLeases(!this.isInActiveVmGroup(avm));
        }
    }

    int removeLimitedLeases(List<VirtualMachineLease> idleResourcesList) {
        int rejected = 0;
        ArrayList<VirtualMachineLease> randomized = new ArrayList<VirtualMachineLease>(idleResourcesList);
        Collections.shuffle(randomized);
        for (VirtualMachineLease lease : randomized) {
            if (this.vmRejectLimiter.limitReached()) break;
            Optional<AssignableVirtualMachine> vmByName = this.vmCollection.getVmByName(lease.hostname());
            if (!vmByName.isPresent()) continue;
            rejected += vmByName.get().expireLimitedLeases(this.vmRejectLimiter);
        }
        return rejected;
    }

    int getTotalNumVMs() {
        return this.vmCollection.size();
    }

    void purgeInactiveVMs(Set<String> excludeVms) {
        for (AssignableVirtualMachine avm : this.vmCollection.getAllVMs()) {
            if (avm == null || excludeVms.contains(avm.getHostname()) || avm.isActive()) continue;
            this.vmCollection.remove(avm);
            if (avm.getCurrVMId() != null) {
                this.vmIdToHostnameMap.remove(avm.getCurrVMId(), avm.getHostname());
            }
            logger.info("Removed inactive host " + avm.getHostname());
        }
    }

    private void saveMaxResources(AssignableVirtualMachine avm) {
        String attrValue;
        if (this.attrNameToGroupMaxResources != null && !this.attrNameToGroupMaxResources.isEmpty() && (attrValue = avm.getAttrValue(this.attrNameToGroupMaxResources)) != null) {
            Map<VMResource, Double> maxResources = avm.getMaxResources();
            Map<VMResource, Double> savedMaxResources = this.maxResourcesMap.get(attrValue);
            if (savedMaxResources == null) {
                savedMaxResources = new HashMap<VMResource, Double>();
                this.maxResourcesMap.put(attrValue, savedMaxResources);
            }
            for (VMResource r : VMResource.values()) {
                switch (r) {
                    case CPU: 
                    case Disk: 
                    case Memory: 
                    case Ports: 
                    case Network: {
                        Double savedVal = savedMaxResources.get((Object)r) == null ? Double.valueOf(0.0) : savedMaxResources.get((Object)r);
                        savedMaxResources.put(r, Math.max(savedVal, maxResources.get((Object)r)));
                    }
                }
            }
        }
    }

    Map<VMResource, Double> getMaxResources(String attrValue) {
        return this.maxResourcesMap.get(attrValue);
    }

    AssignmentFailure getFailedMaxResource(String attrValue, TaskRequest task) {
        AssignmentFailure savedFailure = null;
        for (Map.Entry<String, Map<VMResource, Double>> entry : this.maxResourcesMap.entrySet()) {
            if (attrValue != null && !attrValue.equals(entry.getKey())) continue;
            Map<VMResource, Double> maxResources = entry.getValue();
            AssignmentFailure failure = null;
            for (VMResource res : VMResource.values()) {
                switch (res) {
                    case CPU: {
                        if (!(maxResources.get((Object)VMResource.CPU) < task.getCPUs())) break;
                        failure = new AssignmentFailure(VMResource.CPU, task.getCPUs(), 0.0, maxResources.get((Object)VMResource.CPU), "");
                        break;
                    }
                    case Memory: {
                        if (!(maxResources.get((Object)VMResource.Memory) < task.getMemory())) break;
                        failure = new AssignmentFailure(VMResource.Memory, task.getMemory(), 0.0, maxResources.get((Object)VMResource.Memory), "");
                        break;
                    }
                    case Disk: {
                        if (!(maxResources.get((Object)VMResource.Disk) < task.getDisk())) break;
                        failure = new AssignmentFailure(VMResource.Disk, task.getDisk(), 0.0, maxResources.get((Object)VMResource.Disk), "");
                        break;
                    }
                    case Ports: {
                        if (!(maxResources.get((Object)VMResource.Ports) < (double)task.getPorts())) break;
                        failure = new AssignmentFailure(VMResource.Ports, task.getPorts(), 0.0, maxResources.get((Object)VMResource.Ports), "");
                        break;
                    }
                    case Network: {
                        if (!(maxResources.get((Object)VMResource.Network) < task.getNetworkMbps())) break;
                        failure = new AssignmentFailure(VMResource.Network, task.getNetworkMbps(), 0.0, maxResources.get((Object)VMResource.Network), "");
                        break;
                    }
                    case VirtualMachine: 
                    case Fitness: 
                    case ResAllocs: 
                    case ResourceSet: 
                    case Other: {
                        break;
                    }
                    default: {
                        logger.error("Unknown resource type: " + (Object)((Object)res));
                    }
                }
                if (failure != null) break;
            }
            if (failure == null) {
                return null;
            }
            savedFailure = failure;
        }
        return savedFailure;
    }

    ActiveVmGroups getActiveVmGroups() {
        return this.activeVmGroups;
    }

    List<VirtualMachineCurrentState> getVmCurrentStates() {
        ArrayList<VirtualMachineCurrentState> result = new ArrayList<VirtualMachineCurrentState>();
        for (AssignableVirtualMachine avm : this.vmCollection.getAllVMs()) {
            result.add(avm.getVmCurrentState());
        }
        return result;
    }

    AssignableVirtualMachine getDummyVM() {
        return this.dummyVM;
    }

    private static class HostDisablePair {
        private final String host;
        private final Long until;

        HostDisablePair(String host, Long until) {
            this.host = host;
            this.until = until;
        }
    }

    static class VMRejectLimiter {
        private long lastRejectAt = 0L;
        private int rejectedCount;
        private final int limit;
        private final long rejectDelay;

        VMRejectLimiter(int limit, long leaseOfferExpirySecs) {
            this.limit = limit;
            this.rejectDelay = leaseOfferExpirySecs * 1000L;
        }

        synchronized boolean reject() {
            if (this.rejectedCount == this.limit) {
                return false;
            }
            ++this.rejectedCount;
            this.lastRejectAt = System.currentTimeMillis();
            return true;
        }

        boolean limitReached() {
            return this.rejectedCount == this.limit;
        }

        private void reset() {
            if (System.currentTimeMillis() > this.lastRejectAt + this.rejectDelay) {
                this.rejectedCount = 0;
            }
        }
    }
}

