/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.factory.schema;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.SystemSchemaManager;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseMetaDataExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.factory.schema.MySQLSpecialTableQueryExecutorFactory;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.factory.schema.type.MySQLSchemataQueryExecutorFactory;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class MySQLSystemSchemaQueryExecutorFactory {
    private static final Collection<MySQLSpecialTableQueryExecutorFactory> SPECIAL_TABLE_EXECUTOR_FACTORIES = new HashSet<MySQLSpecialTableQueryExecutorFactory>();

    public static Optional<DatabaseAdminExecutor> newInstance(SelectStatementContext selectStatementContext, String sql, List<Object> parameters, String schemaName) {
        SelectStatement sqlStatement = selectStatementContext.getSqlStatement();
        if (!sqlStatement.getFrom().isPresent() || !(sqlStatement.getFrom().get() instanceof SimpleTableSegment)) {
            return Optional.empty();
        }
        String tableName = ((SimpleTableSegment)sqlStatement.getFrom().get()).getTableName().getIdentifier().getValue();
        Optional<DatabaseAdminExecutor> specialTableExecutor = MySQLSystemSchemaQueryExecutorFactory.findSpecialTableExecutor(selectStatementContext, sql, parameters, schemaName, tableName);
        if (specialTableExecutor.isPresent()) {
            return specialTableExecutor;
        }
        if (SystemSchemaManager.isSystemTable((String)"mysql", (String)schemaName, (String)tableName)) {
            return Optional.of(new DatabaseMetaDataExecutor(sql, parameters));
        }
        return Optional.empty();
    }

    private static Optional<DatabaseAdminExecutor> findSpecialTableExecutor(SelectStatementContext selectStatementContext, String sql, List<Object> parameters, String schemaName, String tableName) {
        for (MySQLSpecialTableQueryExecutorFactory each : SPECIAL_TABLE_EXECUTOR_FACTORIES) {
            Optional<DatabaseAdminExecutor> specialTableExecutor;
            if (!each.accept(schemaName, tableName) || !(specialTableExecutor = each.newInstance(selectStatementContext, sql, parameters, tableName)).isPresent()) continue;
            return specialTableExecutor;
        }
        return Optional.empty();
    }

    @Generated
    private MySQLSystemSchemaQueryExecutorFactory() {
    }

    static {
        SPECIAL_TABLE_EXECUTOR_FACTORIES.add(new MySQLSchemataQueryExecutorFactory());
    }
}

