/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.Portal;

public final class PortalContext {
    private final Map<String, Portal> portals = new LinkedHashMap<String, Portal>();

    public void add(Portal portal) throws SQLException {
        boolean isNamedPortal = !portal.getName().isEmpty();
        Preconditions.checkState((!isNamedPortal || !this.portals.containsKey(portal.getName()) ? 1 : 0) != 0, (String)"Named portal `%s` must be explicitly closed", (Object)portal.getName());
        Portal previousPortal = this.portals.put(portal.getName(), portal);
        if (null != previousPortal) {
            previousPortal.close();
        }
    }

    public Portal get(String portalName) {
        return this.portals.get(portalName);
    }

    public void close(String portalName) throws SQLException {
        Portal result = this.portals.remove(portalName);
        if (null != result) {
            result.close();
        }
    }

    public void closeAll() throws SQLException {
        for (Portal portal : this.portals.values()) {
            portal.close();
        }
        this.portals.clear();
    }
}

