/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.infra.util.regex.RegexUtils;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.single.distsql.statement.rql.ShowSingleTablesStatement;
import org.apache.shardingsphere.single.rule.SingleRule;

public final class ShowSingleTablesExecutor
implements DistSQLQueryExecutor<ShowSingleTablesStatement>,
DistSQLExecutorRuleAware<SingleRule>,
DistSQLExecutorDatabaseAware {
    private ShardingSphereDatabase database;
    private SingleRule rule;

    public Collection<String> getColumnNames(ShowSingleTablesStatement sqlStatement) {
        return new DatabaseTypeRegistry(this.database.getProtocolType()).getDialectDatabaseMetaData().getSchemaOption().isSchemaAvailable() ? Arrays.asList("table_name", "storage_unit_name", "schema_name") : Arrays.asList("table_name", "storage_unit_name");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowSingleTablesStatement sqlStatement, ContextManager contextManager) {
        Collection resultDataNodes = this.getPattern(sqlStatement).map(optional -> this.getDataNodesWithLikePattern(((DataNodeRuleAttribute)this.rule.getAttributes().getAttribute(DataNodeRuleAttribute.class)).getAllDataNodes(), (Pattern)optional)).orElseGet(() -> this.getDataNodes(((DataNodeRuleAttribute)this.rule.getAttributes().getAttribute(DataNodeRuleAttribute.class)).getAllDataNodes()));
        Collection sortedDataNodes = resultDataNodes.stream().sorted(Comparator.comparing(DataNode::getTableName)).collect(Collectors.toList());
        boolean isSchemaAvailable = new DatabaseTypeRegistry(this.database.getProtocolType()).getDialectDatabaseMetaData().getSchemaOption().isSchemaAvailable();
        return sortedDataNodes.stream().map(each -> isSchemaAvailable ? new LocalDataQueryResultRow(new Object[]{each.getTableName(), each.getDataSourceName(), each.getSchemaName()}) : new LocalDataQueryResultRow(new Object[]{each.getTableName(), each.getDataSourceName()})).collect(Collectors.toList());
    }

    private Optional<Pattern> getPattern(ShowSingleTablesStatement sqlStatement) {
        return sqlStatement.getLikePattern().isPresent() ? Optional.of(Pattern.compile(RegexUtils.convertLikePatternToRegex((String)((String)sqlStatement.getLikePattern().get())), 2)) : Optional.empty();
    }

    private Collection<DataNode> getDataNodesWithLikePattern(Map<String, Collection<DataNode>> singleTableNodes, Pattern pattern) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (Map.Entry<String, Collection<DataNode>> entry : singleTableNodes.entrySet()) {
            if (!pattern.matcher(entry.getKey()).matches()) continue;
            result.addAll(entry.getValue());
        }
        return result;
    }

    private Collection<DataNode> getDataNodes(Map<String, Collection<DataNode>> singleTableNodes) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (Collection<DataNode> each : singleTableNodes.values()) {
            result.addAll(each);
        }
        return result;
    }

    public Class<SingleRule> getRuleClass() {
        return SingleRule.class;
    }

    public Class<ShowSingleTablesStatement> getType() {
        return ShowSingleTablesStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(SingleRule rule) {
        this.rule = rule;
    }
}

