/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.bind.PostgreSQLComBindPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.execute.PostgreSQLComExecutePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.parse.PostgreSQLComParsePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLAggregatedCommandPacket
extends PostgreSQLCommandPacket {
    private final List<PostgreSQLCommandPacket> packets;
    private final boolean containsBatchedStatements;
    private final int batchPacketBeginIndex;
    private final int batchPacketEndIndex;

    public PostgreSQLAggregatedCommandPacket(List<PostgreSQLCommandPacket> packets) {
        this.packets = packets;
        String firstStatementId = null;
        String firstPortal = null;
        int parsePacketCount = 0;
        int bindPacketCountForFirstStatement = 0;
        int executePacketCountForFirstStatement = 0;
        int batchPacketBeginIndex = -1;
        int batchPacketEndIndex = -1;
        int index = 0;
        for (PostgreSQLCommandPacket each : packets) {
            if (each instanceof PostgreSQLComParsePacket) {
                if (++parsePacketCount > 1) break;
                if (null == firstStatementId) {
                    firstStatementId = ((PostgreSQLComParsePacket)each).getStatementId();
                } else if (!firstStatementId.equals(((PostgreSQLComParsePacket)each).getStatementId())) break;
            }
            if (each instanceof PostgreSQLComBindPacket) {
                if (-1 == batchPacketBeginIndex) {
                    batchPacketBeginIndex = index;
                }
                if (null == firstStatementId) {
                    firstStatementId = ((PostgreSQLComBindPacket)each).getStatementId();
                } else if (!firstStatementId.equals(((PostgreSQLComBindPacket)each).getStatementId())) break;
                if (null == firstPortal) {
                    firstPortal = ((PostgreSQLComBindPacket)each).getPortal();
                } else if (!firstPortal.equals(((PostgreSQLComBindPacket)each).getPortal())) break;
                ++bindPacketCountForFirstStatement;
            }
            if (each instanceof PostgreSQLComExecutePacket) {
                if (index > batchPacketEndIndex) {
                    batchPacketEndIndex = index;
                }
                if (null == firstPortal) {
                    firstPortal = ((PostgreSQLComExecutePacket)each).getPortal();
                } else if (!firstPortal.equals(((PostgreSQLComExecutePacket)each).getPortal())) break;
                ++executePacketCountForFirstStatement;
            }
            ++index;
        }
        this.batchPacketBeginIndex = batchPacketBeginIndex;
        this.batchPacketEndIndex = batchPacketEndIndex;
        this.containsBatchedStatements = bindPacketCountForFirstStatement == executePacketCountForFirstStatement && bindPacketCountForFirstStatement >= 3;
    }

    @Override
    protected void write(PostgreSQLPacketPayload payload) {
    }

    @Override
    public PostgreSQLIdentifierTag getIdentifier() {
        return () -> '?';
    }

    @Generated
    public List<PostgreSQLCommandPacket> getPackets() {
        return this.packets;
    }

    @Generated
    public boolean isContainsBatchedStatements() {
        return this.containsBatchedStatements;
    }

    @Generated
    public int getBatchPacketBeginIndex() {
        return this.batchPacketBeginIndex;
    }

    @Generated
    public int getBatchPacketEndIndex() {
        return this.batchPacketEndIndex;
    }
}

