/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.extractor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.available.WhereContextAvailable;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertSelectContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.ddl.AlterViewStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.ddl.CreateViewStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.IndexSQLStatementAttribute;

public final class SQLStatementContextExtractor {
    public static Collection<String> getTableNames(ShardingSphereDatabase database, SQLStatementContext sqlStatementContext) {
        Collection<String> tableNames = sqlStatementContext.getTablesContext().getTableNames();
        if (!tableNames.isEmpty()) {
            return tableNames;
        }
        return sqlStatementContext.getSqlStatement().getAttributes().findAttribute(IndexSQLStatementAttribute.class).map(optional -> SQLStatementContextExtractor.getTableNames(database, sqlStatementContext.getSqlStatement().getDatabaseType(), optional.getIndexes())).orElse(Collections.emptyList());
    }

    private static Collection<String> getTableNames(ShardingSphereDatabase database, DatabaseType databaseType, Collection<IndexSegment> indexes) {
        LinkedList<String> result = new LinkedList<String>();
        for (QualifiedTable each : IndexMetaDataUtils.getTableNames((ShardingSphereDatabase)database, (DatabaseType)databaseType, indexes)) {
            result.add(each.getTableName());
        }
        return result;
    }

    public static Collection<SelectStatementContext> getAllSubqueryContexts(SQLStatementContext sqlStatementContext) {
        LinkedList<SelectStatementContext> result = new LinkedList<SelectStatementContext>();
        if (sqlStatementContext instanceof SelectStatementContext) {
            result.addAll(((SelectStatementContext)sqlStatementContext).getSubqueryContexts().values());
            ((SelectStatementContext)sqlStatementContext).getSubqueryContexts().values().forEach(each -> result.addAll(SQLStatementContextExtractor.getAllSubqueryContexts(each)));
            return result;
        }
        if (sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext()) {
            InsertSelectContext insertSelectContext = ((InsertStatementContext)sqlStatementContext).getInsertSelectContext();
            result.add(insertSelectContext.getSelectStatementContext());
            result.addAll(insertSelectContext.getSelectStatementContext().getSubqueryContexts().values());
            insertSelectContext.getSelectStatementContext().getSubqueryContexts().values().forEach(each -> result.addAll(SQLStatementContextExtractor.getAllSubqueryContexts(each)));
            return result;
        }
        if (sqlStatementContext instanceof CreateViewStatementContext) {
            CreateViewStatementContext createViewStatementContext = (CreateViewStatementContext)sqlStatementContext;
            result.add(createViewStatementContext.getSelectStatementContext());
            result.addAll(createViewStatementContext.getSelectStatementContext().getSubqueryContexts().values());
            createViewStatementContext.getSelectStatementContext().getSubqueryContexts().values().forEach(each -> result.addAll(SQLStatementContextExtractor.getAllSubqueryContexts(each)));
            return result;
        }
        if (sqlStatementContext instanceof AlterViewStatementContext && ((AlterViewStatementContext)sqlStatementContext).getSelectStatementContext().isPresent()) {
            AlterViewStatementContext alterViewStatementContext = (AlterViewStatementContext)sqlStatementContext;
            result.add(alterViewStatementContext.getSelectStatementContext().get());
            result.addAll(alterViewStatementContext.getSelectStatementContext().get().getSubqueryContexts().values());
            alterViewStatementContext.getSelectStatementContext().get().getSubqueryContexts().values().forEach(each -> result.addAll(SQLStatementContextExtractor.getAllSubqueryContexts(each)));
            return result;
        }
        return result;
    }

    public static Collection<WhereSegment> getAllWhereSegments(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof WhereContextAvailable)) {
            return Collections.emptySet();
        }
        Collection<SelectStatementContext> allSubqueryContexts = SQLStatementContextExtractor.getAllSubqueryContexts(sqlStatementContext);
        return SQLStatementContextExtractor.getWhereSegments((WhereContextAvailable)((Object)sqlStatementContext), allSubqueryContexts);
    }

    public static Collection<WhereSegment> getWhereSegments(WhereContextAvailable whereContextAvailable, Collection<SelectStatementContext> allSubqueryContexts) {
        LinkedHashMap uniqueWhereSegments = new LinkedHashMap(whereContextAvailable.getWhereSegments().size() + allSubqueryContexts.size(), 1.0f);
        whereContextAvailable.getWhereSegments().forEach(each -> uniqueWhereSegments.put(each.getStartIndex() + each.getStopIndex(), each));
        allSubqueryContexts.forEach(each -> each.getWhereSegments().forEach(where -> uniqueWhereSegments.put(where.getStartIndex() + where.getStopIndex(), where)));
        return new ArrayList<WhereSegment>(uniqueWhereSegments.values());
    }

    public static Collection<ColumnSegment> getColumnSegments(WhereContextAvailable whereContextAvailable, Collection<SelectStatementContext> allSubqueryContexts) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>(whereContextAvailable.getColumnSegments());
        allSubqueryContexts.forEach(each -> result.addAll(each.getColumnSegments()));
        return result;
    }

    public static Collection<BinaryOperationExpression> getJoinConditions(WhereContextAvailable whereContextAvailable, Collection<SelectStatementContext> allSubqueryContexts) {
        LinkedList<BinaryOperationExpression> result = new LinkedList<BinaryOperationExpression>(whereContextAvailable.getJoinConditions());
        allSubqueryContexts.forEach(each -> result.addAll(each.getJoinConditions()));
        return result;
    }

    @Generated
    private SQLStatementContextExtractor() {
    }
}

