/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.engine.update;

import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorAwareSetter;
import org.apache.shardingsphere.distsql.handler.engine.DistSQLConnectionContext;
import org.apache.shardingsphere.distsql.handler.engine.update.AdvancedDistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.DatabaseRuleDefinitionExecuteEngine;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.global.GlobalRuleDefinitionExecuteEngine;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDefinitionExecutor;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDefinitionExecutorFactory;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.global.GlobalRuleDefinitionExecutor;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.global.GlobalRuleDefinitionExecutorFactory;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorRequiredChecker;
import org.apache.shardingsphere.distsql.handler.util.DatabaseNameUtils;
import org.apache.shardingsphere.distsql.statement.DistSQLStatement;
import org.apache.shardingsphere.distsql.statement.type.rdl.rule.RuleDefinitionStatement;
import org.apache.shardingsphere.distsql.statement.type.rdl.rule.database.DatabaseRuleDefinitionStatement;
import org.apache.shardingsphere.distsql.statement.type.rdl.rule.global.GlobalRuleDefinitionStatement;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class DistSQLUpdateExecuteEngine {
    private final DistSQLStatement sqlStatement;
    private final ContextManager contextManager;
    private final String databaseName;
    private final DistSQLConnectionContext distsqlConnectionContext;

    public DistSQLUpdateExecuteEngine(DistSQLStatement sqlStatement, String currentDatabaseName, ContextManager contextManager, DistSQLConnectionContext distsqlConnectionContext) {
        this.sqlStatement = sqlStatement;
        this.contextManager = contextManager;
        this.databaseName = DatabaseNameUtils.getDatabaseName((SQLStatement)sqlStatement, currentDatabaseName);
        this.distsqlConnectionContext = distsqlConnectionContext;
    }

    public void executeUpdate() throws SQLException {
        if (this.sqlStatement instanceof RuleDefinitionStatement) {
            this.executeRuleDefinitionUpdate();
        } else {
            this.executeNormalUpdate();
        }
    }

    private void executeRuleDefinitionUpdate() {
        if (this.sqlStatement instanceof GlobalRuleDefinitionStatement) {
            GlobalRuleDefinitionExecutor globalExecutor = GlobalRuleDefinitionExecutorFactory.newInstance(this.sqlStatement, this.contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData());
            new GlobalRuleDefinitionExecuteEngine((GlobalRuleDefinitionStatement)this.sqlStatement, this.contextManager, globalExecutor).executeUpdate();
            return;
        }
        ShardingSphereDatabase database = this.contextManager.getDatabase(this.databaseName);
        Optional<DatabaseRuleDefinitionExecutor> databaseExecutor = DatabaseRuleDefinitionExecutorFactory.findInstance(this.sqlStatement, database);
        if (databaseExecutor.isPresent()) {
            new DatabaseRuleDefinitionExecuteEngine((DatabaseRuleDefinitionStatement)this.sqlStatement, this.contextManager, database, databaseExecutor.get()).executeUpdate();
        }
    }

    private void executeNormalUpdate() throws SQLException {
        Optional advancedExecutor = TypedSPILoader.findService(AdvancedDistSQLUpdateExecutor.class, this.sqlStatement.getClass());
        DistSQLUpdateExecutor executor = advancedExecutor.isPresent() ? (DistSQLUpdateExecutor)advancedExecutor.get() : (DistSQLUpdateExecutor)TypedSPILoader.getService(DistSQLUpdateExecutor.class, this.sqlStatement.getClass());
        ShardingSphereDatabase database = null == this.databaseName ? null : this.contextManager.getDatabase(this.databaseName);
        new DistSQLExecutorAwareSetter(executor).set(this.contextManager, database, this.distsqlConnectionContext, this.sqlStatement);
        new DistSQLExecutorRequiredChecker(executor).check((SQLStatement)this.sqlStatement, this.contextManager, database);
        executor.executeUpdate(this.sqlStatement, this.contextManager);
    }
}

