/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.engine.query;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorAwareSetter;
import org.apache.shardingsphere.distsql.handler.engine.DistSQLConnectionContext;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.handler.util.DatabaseNameUtils;
import org.apache.shardingsphere.distsql.statement.DistSQLStatement;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class DistSQLQueryExecuteEngine {
    private final DistSQLStatement sqlStatement;
    private final ContextManager contextManager;
    private final DistSQLConnectionContext distsqlConnectionContext;
    private final String databaseName;
    private Collection<String> columnNames;
    private Collection<LocalDataQueryResultRow> rows;

    public DistSQLQueryExecuteEngine(DistSQLStatement sqlStatement, String currentDatabaseName, ContextManager contextManager, DistSQLConnectionContext distsqlConnectionContext) {
        this.sqlStatement = sqlStatement;
        this.contextManager = contextManager;
        this.distsqlConnectionContext = distsqlConnectionContext;
        this.databaseName = DatabaseNameUtils.getDatabaseName((SQLStatement)sqlStatement, currentDatabaseName);
    }

    public void executeQuery() throws SQLException {
        DistSQLQueryExecutor executor = (DistSQLQueryExecutor)TypedSPILoader.getService(DistSQLQueryExecutor.class, this.sqlStatement.getClass());
        try {
            new DistSQLExecutorAwareSetter(executor).set(this.contextManager, null == this.databaseName ? null : this.contextManager.getDatabase(this.databaseName), this.distsqlConnectionContext, this.sqlStatement);
        }
        catch (UnsupportedSQLOperationException ignored) {
            this.columnNames = executor.getColumnNames(this.sqlStatement);
            this.rows = Collections.emptyList();
            return;
        }
        this.columnNames = executor.getColumnNames(this.sqlStatement);
        this.rows = executor.getRows(this.sqlStatement, this.contextManager);
    }

    @Generated
    public Collection<String> getColumnNames() {
        return this.columnNames;
    }

    @Generated
    public Collection<LocalDataQueryResultRow> getRows() {
        return this.rows;
    }
}

