/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.transaction;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class FirebirdTransactionIdGenerator {
    private static final FirebirdTransactionIdGenerator INSTANCE = new FirebirdTransactionIdGenerator();
    private final Map<Integer, AtomicInteger> connectionRegistry = new ConcurrentHashMap<Integer, AtomicInteger>();

    public static FirebirdTransactionIdGenerator getInstance() {
        return INSTANCE;
    }

    public void registerConnection(int connectionId) {
        this.connectionRegistry.put(connectionId, new AtomicInteger());
    }

    public int nextTransactionId(int connectionId) {
        return this.connectionRegistry.get(connectionId).incrementAndGet();
    }

    public void unregisterConnection(int connectionId) {
        this.connectionRegistry.remove(connectionId);
    }
}

