/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.broadcast;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.complex.ShardingCartesianRouteEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.IndexSQLStatementAttribute;

public final class ShardingTableBroadcastRouteEngine
implements ShardingRouteEngine {
    private final ShardingSphereDatabase database;
    private final SQLStatement sqlStatement;
    private final Collection<String> shardingRuleTableNames;

    @Override
    public RouteContext route(ShardingRule shardingRule) {
        RouteContext result = new RouteContext();
        Collection<String> logicTableNames = this.getLogicTableNames();
        if (logicTableNames.isEmpty()) {
            result.getRouteUnits().addAll(this.getBroadcastTableRouteUnits(shardingRule, ""));
            return result;
        }
        if (logicTableNames.size() > 1 && shardingRule.isAllConfigBindingTables(logicTableNames)) {
            result.getRouteUnits().addAll(this.getBindingTableRouteUnits(shardingRule, logicTableNames));
        } else {
            Collection<RouteContext> routeContexts = this.getRouteContexts(shardingRule, logicTableNames);
            RouteContext routeContext = new ShardingCartesianRouteEngine(routeContexts).route(shardingRule);
            result.getOriginalDataNodes().addAll(routeContext.getOriginalDataNodes());
            result.getRouteUnits().addAll(routeContext.getRouteUnits());
        }
        return result;
    }

    private Collection<RouteContext> getRouteContexts(ShardingRule shardingRule, Collection<String> logicTableNames) {
        LinkedList<RouteContext> result = new LinkedList<RouteContext>();
        for (String each : logicTableNames) {
            RouteContext routeContext = new RouteContext();
            if (shardingRule.findShardingTable(each).isPresent()) {
                routeContext.getRouteUnits().addAll(this.getAllRouteUnits(shardingRule, each));
            }
            if (routeContext.getRouteUnits().isEmpty()) continue;
            result.add(routeContext);
        }
        return result;
    }

    private Collection<RouteUnit> getBindingTableRouteUnits(ShardingRule shardingRule, Collection<String> tableNames) {
        String primaryTableName = tableNames.iterator().next();
        LinkedList<RouteUnit> result = new LinkedList<RouteUnit>();
        ShardingTable shardingTable = shardingRule.getShardingTable(primaryTableName);
        for (DataNode each : shardingTable.getActualDataNodes()) {
            result.add(new RouteUnit(new RouteMapper(each.getDataSourceName(), each.getDataSourceName()), this.getBindingTableMappers(shardingRule, each, primaryTableName, tableNames)));
        }
        return result;
    }

    private Collection<RouteMapper> getBindingTableMappers(ShardingRule shardingRule, DataNode dataNode, String primaryTableName, Collection<String> tableNames) {
        LinkedList<RouteMapper> result = new LinkedList<RouteMapper>();
        result.add(new RouteMapper(primaryTableName, dataNode.getTableName()));
        result.addAll(shardingRule.getLogicAndActualTablesFromBindingTable(dataNode.getDataSourceName(), primaryTableName, dataNode.getTableName(), tableNames).entrySet().stream().map(each -> new RouteMapper((String)each.getKey(), (String)each.getValue())).collect(Collectors.toList()));
        return result;
    }

    private Collection<String> getLogicTableNames() {
        if (!this.shardingRuleTableNames.isEmpty()) {
            return this.shardingRuleTableNames;
        }
        return this.sqlStatement.getAttributes().findAttribute(IndexSQLStatementAttribute.class).map(optional -> this.getTableNames(this.database, this.sqlStatement.getDatabaseType(), optional.getIndexes())).orElse(Collections.emptyList());
    }

    private Collection<String> getTableNames(ShardingSphereDatabase database, DatabaseType databaseType, Collection<IndexSegment> indexes) {
        LinkedList<String> result = new LinkedList<String>();
        for (QualifiedTable each : IndexMetaDataUtils.getTableNames((ShardingSphereDatabase)database, (DatabaseType)databaseType, indexes)) {
            result.add(each.getTableName());
        }
        return result;
    }

    private Collection<RouteUnit> getBroadcastTableRouteUnits(ShardingRule shardingRule, String broadcastTableName) {
        LinkedList<RouteUnit> result = new LinkedList<RouteUnit>();
        for (String each : shardingRule.getDataSourceNames()) {
            result.add(new RouteUnit(new RouteMapper(each, each), Collections.singletonList(new RouteMapper(broadcastTableName, broadcastTableName))));
        }
        return result;
    }

    private Collection<RouteUnit> getAllRouteUnits(ShardingRule shardingRule, String logicTableName) {
        LinkedList<RouteUnit> result = new LinkedList<RouteUnit>();
        ShardingTable shardingTable = shardingRule.getShardingTable(logicTableName);
        for (DataNode each : shardingTable.getActualDataNodes()) {
            result.add(new RouteUnit(new RouteMapper(each.getDataSourceName(), each.getDataSourceName()), Collections.singletonList(new RouteMapper(logicTableName, each.getTableName()))));
        }
        return result;
    }

    @Generated
    public ShardingTableBroadcastRouteEngine(ShardingSphereDatabase database, SQLStatement sqlStatement, Collection<String> shardingRuleTableNames) {
        this.database = database;
        this.sqlStatement = sqlStatement;
        this.shardingRuleTableNames = shardingRuleTableNames;
    }
}

