/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.parser.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.distsql.parser.autogen.ShadowDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.ShadowDistSQLStatementParser;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.statement.type.ral.queryable.show.ShowPluginsStatement;
import org.apache.shardingsphere.distsql.statement.type.rql.rule.database.CountRuleStatement;
import org.apache.shardingsphere.shadow.distsql.segment.ShadowAlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.segment.ShadowRuleSegment;
import org.apache.shardingsphere.shadow.distsql.statement.AlterDefaultShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.distsql.statement.AlterShadowRuleStatement;
import org.apache.shardingsphere.shadow.distsql.statement.CreateDefaultShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.distsql.statement.CreateShadowRuleStatement;
import org.apache.shardingsphere.shadow.distsql.statement.DropDefaultShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.distsql.statement.DropShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.distsql.statement.DropShadowRuleStatement;
import org.apache.shardingsphere.shadow.distsql.statement.ShowDefaultShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.distsql.statement.ShowShadowAlgorithmsStatement;
import org.apache.shardingsphere.shadow.distsql.statement.ShowShadowRulesStatement;
import org.apache.shardingsphere.shadow.distsql.statement.ShowShadowTableRulesStatement;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.FromDatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ShadowDistSQLStatementVisitor
extends ShadowDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor<ASTNode> {
    @Override
    public ASTNode visitCreateShadowRule(ShadowDistSQLStatementParser.CreateShadowRuleContext ctx) {
        List<ShadowRuleSegment> shadowRuleSegments = ctx.shadowRuleDefinition().stream().map(arg_0 -> ((ShadowDistSQLStatementVisitor)this).visit(arg_0)).map(ShadowRuleSegment.class::cast).collect(Collectors.toList());
        return new CreateShadowRuleStatement(null != ctx.ifNotExists(), this.autoCreateAlgorithmName(shadowRuleSegments));
    }

    @Override
    public ASTNode visitCreateDefaultShadowAlgorithm(ShadowDistSQLStatementParser.CreateDefaultShadowAlgorithmContext ctx) {
        return new CreateDefaultShadowAlgorithmStatement(null != ctx.ifNotExists(), (ShadowAlgorithmSegment)this.visit((ParseTree)ctx.algorithmDefinition()));
    }

    @Override
    public ASTNode visitAlterDefaultShadowAlgorithm(ShadowDistSQLStatementParser.AlterDefaultShadowAlgorithmContext ctx) {
        return new AlterDefaultShadowAlgorithmStatement((ShadowAlgorithmSegment)this.visit((ParseTree)ctx.algorithmDefinition()));
    }

    @Override
    public ASTNode visitShadowRuleDefinition(ShadowDistSQLStatementParser.ShadowRuleDefinitionContext ctx) {
        Map<String, Collection> shadowAlgorithms = ctx.shadowTableRule().stream().collect(Collectors.toMap(each -> this.getIdentifierValue(each.tableName()), each -> this.visitShadowAlgorithms(each.algorithmDefinition())));
        return new ShadowRuleSegment(this.getIdentifierValue(ctx.ruleName()), this.getIdentifierValue(ctx.source()), this.getIdentifierValue(ctx.shadow()), shadowAlgorithms);
    }

    private Collection<ShadowAlgorithmSegment> visitShadowAlgorithms(List<ShadowDistSQLStatementParser.AlgorithmDefinitionContext> contexts) {
        return contexts.stream().map(arg_0 -> ((ShadowDistSQLStatementVisitor)this).visit(arg_0)).map(ShadowAlgorithmSegment.class::cast).collect(Collectors.toList());
    }

    @Override
    public ASTNode visitShowShadowAlgorithms(ShadowDistSQLStatementParser.ShowShadowAlgorithmsContext ctx) {
        return new ShowShadowAlgorithmsStatement(null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName())));
    }

    @Override
    public ASTNode visitShowDefaultShadowAlgorithm(ShadowDistSQLStatementParser.ShowDefaultShadowAlgorithmContext ctx) {
        return new ShowDefaultShadowAlgorithmStatement(null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName())));
    }

    @Override
    public ASTNode visitAlgorithmDefinition(ShadowDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        AlgorithmSegment segment = new AlgorithmSegment(this.getIdentifierValue(ctx.algorithmTypeName()), this.getProperties(ctx.propertiesDefinition()));
        return new ShadowAlgorithmSegment(null, segment);
    }

    private Properties getProperties(ShadowDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        for (ShadowDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(QuoteCharacter.unwrapAndTrimText((String)each.key.getText()), QuoteCharacter.unwrapAndTrimText((String)each.value.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterShadowRule(ShadowDistSQLStatementParser.AlterShadowRuleContext ctx) {
        List<ShadowRuleSegment> shadowRuleSegments = ctx.shadowRuleDefinition().stream().map(arg_0 -> ((ShadowDistSQLStatementVisitor)this).visit(arg_0)).map(ShadowRuleSegment.class::cast).collect(Collectors.toList());
        return new AlterShadowRuleStatement(this.autoCreateAlgorithmName(shadowRuleSegments));
    }

    @Override
    public ASTNode visitDropShadowRule(ShadowDistSQLStatementParser.DropShadowRuleContext ctx) {
        return new DropShadowRuleStatement(null != ctx.ifExists(), (Collection)ctx.ruleName().stream().map(each -> new IdentifierValue(each.getText()).getValue()).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropShadowAlgorithm(ShadowDistSQLStatementParser.DropShadowAlgorithmContext ctx) {
        return new DropShadowAlgorithmStatement(null != ctx.ifExists(), null == ctx.algorithmName() ? Collections.emptyList() : (Collection)ctx.algorithmName().stream().map(this::getIdentifierValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropDefaultShadowAlgorithm(ShadowDistSQLStatementParser.DropDefaultShadowAlgorithmContext ctx) {
        return new DropDefaultShadowAlgorithmStatement(null != ctx.ifExists());
    }

    @Override
    public ASTNode visitShowShadowRules(ShadowDistSQLStatementParser.ShowShadowRulesContext ctx) {
        String ruleName = null == ctx.shadowRule() ? null : this.getIdentifierValue(ctx.shadowRule().ruleName());
        FromDatabaseSegment fromDatabase = null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
        return new ShowShadowRulesStatement(ruleName, null == ctx.databaseName() ? null : fromDatabase);
    }

    @Override
    public ASTNode visitShowShadowTableRules(ShadowDistSQLStatementParser.ShowShadowTableRulesContext ctx) {
        FromDatabaseSegment fromDatabase = null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
        String tableName = null == ctx.tableRule() ? null : this.getIdentifierValue(ctx.tableRule().tableName());
        return new ShowShadowTableRulesStatement(fromDatabase, tableName);
    }

    private String getIdentifierValue(ParserRuleContext ctx) {
        return null == ctx || ctx.isEmpty() ? null : new IdentifierValue(ctx.getText()).getValue();
    }

    @Override
    public ASTNode visitDatabaseName(ShadowDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitCountShadowRule(ShadowDistSQLStatementParser.CountShadowRuleContext ctx) {
        return new CountRuleStatement(null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName())), "SHADOW");
    }

    private Collection<ShadowRuleSegment> autoCreateAlgorithmName(Collection<ShadowRuleSegment> shadowRuleSegments) {
        LinkedList<ShadowRuleSegment> result = new LinkedList<ShadowRuleSegment>();
        shadowRuleSegments.forEach(each -> this.buildShadowRuleSegment((Collection<ShadowRuleSegment>)result, (ShadowRuleSegment)each));
        return result;
    }

    private void buildShadowRuleSegment(Collection<ShadowRuleSegment> collection, ShadowRuleSegment shadowRuleSegment) {
        LinkedHashMap shadowTableRules = new LinkedHashMap(shadowRuleSegment.getShadowTableRules().size(), 1.0f);
        for (Map.Entry entry : shadowRuleSegment.getShadowTableRules().entrySet()) {
            int index = 0;
            LinkedList<ShadowAlgorithmSegment> shadowAlgorithmSegments = new LinkedList<ShadowAlgorithmSegment>();
            for (ShadowAlgorithmSegment each : (Collection)entry.getValue()) {
                shadowAlgorithmSegments.add(this.buildShadowAlgorithmSegment(shadowRuleSegment.getRuleName(), (String)entry.getKey(), index++, each));
            }
            shadowTableRules.put((String)entry.getKey(), shadowAlgorithmSegments);
        }
        collection.add(new ShadowRuleSegment(shadowRuleSegment.getRuleName(), shadowRuleSegment.getSource(), shadowRuleSegment.getShadow(), shadowTableRules));
    }

    private ShadowAlgorithmSegment buildShadowAlgorithmSegment(String ruleName, String tableName, int index, ShadowAlgorithmSegment shadowAlgorithmSegment) {
        String algorithmName = this.buildAlgorithmName(ruleName, tableName, shadowAlgorithmSegment.getAlgorithmSegment().getName(), index);
        AlgorithmSegment algorithmSegment = new AlgorithmSegment(shadowAlgorithmSegment.getAlgorithmSegment().getName(), shadowAlgorithmSegment.getAlgorithmSegment().getProps());
        return new ShadowAlgorithmSegment(algorithmName, algorithmSegment);
    }

    private String buildAlgorithmName(String ruleName, String tableName, String algorithmType, int index) {
        return String.format("%s_%s_%s_%d", ruleName, tableName, algorithmType, index).toLowerCase();
    }

    @Override
    public ASTNode visitShowShadowAlgorithmPlugins(ShadowDistSQLStatementParser.ShowShadowAlgorithmPluginsContext ctx) {
        return new ShowPluginsStatement("SHADOW_ALGORITHM");
    }
}

