/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.node.storage;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDataSource;
import org.apache.shardingsphere.infra.rule.attribute.datasource.StaticDataSourceRuleAttribute;
import org.apache.shardingsphere.infra.state.datasource.qualified.QualifiedDataSourceState;
import org.apache.shardingsphere.infra.state.datasource.qualified.yaml.YamlQualifiedDataSourceState;
import org.apache.shardingsphere.infra.state.datasource.qualified.yaml.YamlQualifiedDataSourceStateSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.GlobalDataChangedEventHandler;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.global.node.storage.QualifiedDataSourceNodePath;

public final class QualifiedDataSourceChangedHandler
implements GlobalDataChangedEventHandler {
    @Override
    public NodePath getSubscribedNodePath() {
        return new QualifiedDataSourceNodePath((String)null);
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        if (Strings.isNullOrEmpty((String)event.getValue())) {
            return;
        }
        Optional<QualifiedDataSource> qualifiedDataSource = NodePathSearcher.find((String)event.getKey(), (NodePathSearchCriteria)QualifiedDataSourceNodePath.createQualifiedDataSourceSearchCriteria()).map(QualifiedDataSource::new);
        if (!qualifiedDataSource.isPresent()) {
            return;
        }
        QualifiedDataSourceState state = new YamlQualifiedDataSourceStateSwapper().swapToObject((YamlQualifiedDataSourceState)YamlEngine.unmarshal((String)event.getValue(), YamlQualifiedDataSourceState.class));
        this.handleQualifiedDataSourceStateChanged(contextManager.getMetaDataContexts().getMetaData(), qualifiedDataSource.get(), state);
    }

    private void handleQualifiedDataSourceStateChanged(ShardingSphereMetaData metaData, QualifiedDataSource qualifiedDataSource, QualifiedDataSourceState state) {
        ShardingSpherePreconditions.checkState((boolean)metaData.containsDatabase(qualifiedDataSource.getDatabaseName()), () -> new UnknownDatabaseException(qualifiedDataSource.getDatabaseName()));
        metaData.getDatabase(qualifiedDataSource.getDatabaseName()).getRuleMetaData().getAttributes(StaticDataSourceRuleAttribute.class).forEach(each -> each.updateStatus(qualifiedDataSource, state.getState()));
    }
}

