/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.config.type;

import java.util.Arrays;
import java.util.Collection;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.config.GlobalConfigurationChangedHandler;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.global.config.GlobalRuleNodePath;
import org.apache.shardingsphere.mode.node.path.version.VersionNodePath;

public final class GlobalRuleChangedHandler
implements GlobalConfigurationChangedHandler {
    @Override
    public NodePath getSubscribedNodePath() {
        return new GlobalRuleNodePath(null);
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        if (!new VersionNodePath((NodePath)new GlobalRuleNodePath("([\\w-]+)")).isActiveVersionPath(event.getKey())) {
            return;
        }
        String ruleType = NodePathSearcher.get((String)event.getKey(), (NodePathSearchCriteria)GlobalRuleNodePath.createRuleTypeSearchCriteria());
        RuleConfiguration ruleConfig = contextManager.getPersistServiceFacade().getMetaDataFacade().getGlobalRuleService().load(ruleType);
        contextManager.getMetaDataContextManager().getGlobalConfigurationManager().alterGlobalRuleConfiguration(ruleConfig);
    }
}

