/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.sql.insert;

import java.util.Collection;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.context.extractor.SQLStatementContextExtractor;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;

public final class EncryptInsertSelectSupportedChecker
implements SupportedSQLChecker<InsertStatementContext, EncryptRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && ((InsertStatementContext)sqlStatementContext).getSqlStatement().getInsertSelect().isPresent();
    }

    public void check(EncryptRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, InsertStatementContext sqlStatementContext) {
        Collection tableNames = SQLStatementContextExtractor.getTableNames((ShardingSphereDatabase)database, (SQLStatementContext)sqlStatementContext);
        for (String each : tableNames) {
            ShardingSpherePreconditions.checkState((!rule.findEncryptTable(each).isPresent() ? 1 : 0) != 0, () -> new UnsupportedEncryptSQLException("INSERT ... SELECT ..."));
        }
    }
}

