/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;

final class EnumConversions {
    private EnumConversions() {
    }

    static Enum<?> stringToEnum(Object from, Converter converter, Class<?> target) {
        if (target == Enum.class) {
            throw new IllegalArgumentException("Cannot convert String to abstract Enum.class - a concrete enum type is required");
        }
        String enumName = ((String)from).trim();
        if (enumName.isEmpty()) {
            throw new IllegalArgumentException("Cannot convert empty String to enum " + target.getName());
        }
        int maxLength = converter.getOptions().getMaxEnumNameLength();
        if (enumName.length() > maxLength) {
            throw new IllegalArgumentException("Enum name too long (" + enumName.length() + " chars, max " + maxLength + ") for enum " + target.getName());
        }
        return Enum.valueOf(target, enumName);
    }

    static Enum<?> intToEnum(Object from, Converter converter, Class<?> target) {
        Enum[] enumConstants = (Enum[])target.getEnumConstants();
        if (enumConstants == null) {
            throw new IllegalArgumentException("Cannot convert " + from.getClass().getSimpleName() + " to abstract Enum.class - a concrete enum type is required");
        }
        int ordinal = ((Number)from).intValue();
        if (ordinal < 0 || ordinal >= enumConstants.length) {
            throw new IllegalArgumentException(String.format("Invalid ordinal value %d for enum %s. Must be between 0 and %d", ordinal, target.getName(), enumConstants.length - 1));
        }
        return enumConstants[ordinal];
    }

    static Enum<?> numberToEnum(Object from, Converter converter, Class<?> target) {
        int ordinal = converter.convert(from, Integer.TYPE);
        return EnumConversions.intToEnum(ordinal, converter, target);
    }

    static int enumToOrdinal(Object from, Converter converter) {
        return ((Enum)from).ordinal();
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Enum enumInstance = (Enum)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("name", enumInstance.name());
        return target;
    }

    static <T extends Enum<T>> EnumSet<T> toEnumSet(Object from, Class<?> target) {
        if (!target.isEnum()) {
            throw new IllegalArgumentException("target type " + target.getName() + " must be an Enum, which instructs the EnumSet type to create.");
        }
        Class<?> enumClass = target;
        EnumSet<?> enumSet = EnumSet.noneOf(enumClass);
        if (from instanceof Collection) {
            EnumConversions.processElements((Collection)from, enumSet, enumClass);
        } else if (from.getClass().isArray()) {
            EnumConversions.processArrayElements(from, enumSet, enumClass);
        } else {
            throw new IllegalArgumentException("Source must be a Collection or Array, found: " + from.getClass().getName());
        }
        return enumSet;
    }

    private static <T extends Enum<T>> void processArrayElements(Object array, EnumSet<T> enumSet, Class<T> enumClass) {
        int length = ArrayUtilities.getLength(array);
        Enum[] enumConstants = null;
        for (int i = 0; i < length; ++i) {
            Object element = ArrayUtilities.getElement(array, i);
            if (element == null) continue;
            enumConstants = EnumConversions.processElement((Object)element, enumSet, enumClass, enumConstants);
        }
    }

    private static <T extends Enum<T>> void processElements(Collection<?> collection, EnumSet<T> enumSet, Class<T> enumClass) {
        Enum[] enumConstants = null;
        for (Object element : collection) {
            if (element == null) continue;
            enumConstants = EnumConversions.processElement(element, enumSet, enumClass, enumConstants);
        }
    }

    private static <T extends Enum<T>> T[] processElement(Object element, EnumSet<T> enumSet, Class<T> enumClass, T[] enumConstants) {
        if (enumClass.isInstance(element)) {
            enumSet.add((Enum)enumClass.cast(element));
        } else if (element instanceof String) {
            enumSet.add(Enum.valueOf(enumClass, (String)element));
        } else if (element instanceof Number) {
            int ordinal;
            if (enumConstants == null) {
                enumConstants = (Enum[])enumClass.getEnumConstants();
            }
            if ((ordinal = ((Number)element).intValue()) < 0 || ordinal >= enumConstants.length) {
                throw new IllegalArgumentException(String.format("Invalid ordinal value %d for enum %s. Must be between 0 and %d", ordinal, enumClass.getName(), enumConstants.length - 1));
            }
            enumSet.add(enumConstants[ordinal]);
        } else {
            throw new IllegalArgumentException(element.getClass().getName() + " found in source collection/array is not convertible to " + enumClass.getName());
        }
        return enumConstants;
    }
}

