/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.Convention;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class TrackingMap<K, V>
implements Map<K, V> {
    private final Map<K, V> internalMap;
    private final Set<Object> readKeys;
    private final ConcurrentMap<K, V> asConcurrent;
    private final NavigableMap<K, V> asNavigable;
    private final SortedMap<K, V> asSorted;

    public TrackingMap(Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot construct a TrackingMap() with null");
        }
        this.internalMap = map;
        this.asConcurrent = map instanceof ConcurrentMap ? (ConcurrentMap)map : null;
        this.asNavigable = map instanceof NavigableMap ? (NavigableMap)map : null;
        this.asSorted = map instanceof SortedMap ? (SortedMap)map : null;
        this.readKeys = this.asConcurrent != null ? ConcurrentHashMap.newKeySet() : new HashSet(Math.max(16, map.size()));
    }

    private TrackingMap(Map<K, V> map, Set<Object> sharedReadKeys) {
        this.internalMap = map;
        this.readKeys = sharedReadKeys;
        this.asConcurrent = map instanceof ConcurrentMap ? (ConcurrentMap)map : null;
        this.asNavigable = map instanceof NavigableMap ? (NavigableMap)map : null;
        this.asSorted = map instanceof SortedMap ? (SortedMap)map : null;
    }

    @Override
    public V get(Object key) {
        V value = this.internalMap.get(key);
        this.readKeys.add(key);
        return value;
    }

    @Override
    public V put(K key, V value) {
        return this.internalMap.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        boolean containsKey = this.internalMap.containsKey(key);
        this.readKeys.add(key);
        return containsKey;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.internalMap.putAll(m);
    }

    @Override
    public V remove(Object key) {
        this.readKeys.remove(key);
        return this.internalMap.remove(key);
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Map && this.internalMap.equals(other);
    }

    @Override
    public int hashCode() {
        return this.internalMap.hashCode();
    }

    public String toString() {
        return this.internalMap.toString();
    }

    @Override
    public void clear() {
        this.readKeys.clear();
        this.internalMap.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    public Collection<V> values() {
        return this.internalMap.values();
    }

    @Override
    public Set<K> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.internalMap.entrySet();
    }

    public void expungeUnused() {
        this.internalMap.keySet().retainAll(this.readKeys);
        this.readKeys.retainAll(this.internalMap.keySet());
    }

    public void informAdditionalUsage(Collection<K> additional) {
        this.readKeys.addAll(additional);
    }

    public void informAdditionalUsage(TrackingMap<K, V> additional) {
        this.readKeys.addAll(additional.readKeys);
    }

    public Set<Object> keysUsed() {
        return Collections.unmodifiableSet(this.readKeys);
    }

    public Map<K, V> getWrappedMap() {
        return this.internalMap;
    }

    public void replaceContents(Map<K, V> map) {
        Convention.throwIfNull(map, "Cannot replace contents with null");
        this.clear();
        this.putAll(map);
    }

    @Deprecated
    public void setWrappedMap(Map<K, V> map) {
        this.replaceContents(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        if (this.asConcurrent != null) {
            return this.asConcurrent.putIfAbsent(key, value);
        }
        TrackingMap trackingMap = this;
        synchronized (trackingMap) {
            if (!this.internalMap.containsKey(key)) {
                this.internalMap.put(key, value);
                return null;
            }
            return this.internalMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        boolean removed;
        if (this.asConcurrent != null) {
            removed = this.asConcurrent.remove(key, value);
        } else {
            TrackingMap trackingMap = this;
            synchronized (trackingMap) {
                V curValue = this.internalMap.get(key);
                if (Objects.equals(curValue, value)) {
                    this.internalMap.remove(key);
                    removed = true;
                } else {
                    removed = false;
                }
            }
        }
        if (removed) {
            this.readKeys.remove(key);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (this.asConcurrent != null) {
            return this.asConcurrent.replace(key, oldValue, newValue);
        }
        TrackingMap trackingMap = this;
        synchronized (trackingMap) {
            V curValue = this.internalMap.get(key);
            if (Objects.equals(curValue, oldValue)) {
                this.internalMap.put(key, newValue);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        if (this.asConcurrent != null) {
            return this.asConcurrent.replace(key, value);
        }
        TrackingMap trackingMap = this;
        synchronized (trackingMap) {
            if (this.internalMap.containsKey(key)) {
                return this.internalMap.put(key, value);
            }
            return null;
        }
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V result = this.internalMap.computeIfAbsent((K)key, mappingFunction);
        this.readKeys.add(key);
        return result;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        boolean wasPresent = this.internalMap.containsKey(key);
        V result = this.internalMap.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        if (wasPresent) {
            this.readKeys.add(key);
        }
        return result;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V result = this.internalMap.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        this.readKeys.add(key);
        return result;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V result = this.internalMap.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
        this.readKeys.add(key);
        return result;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V result = this.internalMap.getOrDefault(key, defaultValue);
        this.readKeys.add(key);
        return result;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.internalMap.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.internalMap.replaceAll(function);
    }

    public Map.Entry<K, V> lowerEntry(K key) {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry<K, V> entry = this.asNavigable.lowerEntry(key);
        if (entry != null) {
            this.readKeys.add(entry.getKey());
        }
        return entry;
    }

    public K lowerKey(K key) {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        K result = this.asNavigable.lowerKey(key);
        if (result != null) {
            this.readKeys.add(result);
        }
        return result;
    }

    public Map.Entry<K, V> floorEntry(K key) {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry<K, V> entry = this.asNavigable.floorEntry(key);
        if (entry != null) {
            this.readKeys.add(entry.getKey());
        }
        return entry;
    }

    public K floorKey(K key) {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        K result = this.asNavigable.floorKey(key);
        if (result != null) {
            this.readKeys.add(result);
        }
        return result;
    }

    public Map.Entry<K, V> ceilingEntry(K key) {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry<K, V> entry = this.asNavigable.ceilingEntry(key);
        if (entry != null) {
            this.readKeys.add(entry.getKey());
        }
        return entry;
    }

    public K ceilingKey(K key) {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        K result = this.asNavigable.ceilingKey(key);
        if (result != null) {
            this.readKeys.add(result);
        }
        return result;
    }

    public Map.Entry<K, V> higherEntry(K key) {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry<K, V> entry = this.asNavigable.higherEntry(key);
        if (entry != null) {
            this.readKeys.add(entry.getKey());
        }
        return entry;
    }

    public K higherKey(K key) {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        K result = this.asNavigable.higherKey(key);
        if (result != null) {
            this.readKeys.add(result);
        }
        return result;
    }

    public Map.Entry<K, V> firstEntry() {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry<K, V> entry = this.asNavigable.firstEntry();
        if (entry != null) {
            this.readKeys.add(entry.getKey());
        }
        return entry;
    }

    public Map.Entry<K, V> lastEntry() {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry<K, V> entry = this.asNavigable.lastEntry();
        if (entry != null) {
            this.readKeys.add(entry.getKey());
        }
        return entry;
    }

    public Map.Entry<K, V> pollFirstEntry() {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry<K, V> entry = this.asNavigable.pollFirstEntry();
        if (entry != null) {
            this.readKeys.remove(entry.getKey());
        }
        return entry;
    }

    public Map.Entry<K, V> pollLastEntry() {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        Map.Entry<K, V> entry = this.asNavigable.pollLastEntry();
        if (entry != null) {
            this.readKeys.remove(entry.getKey());
        }
        return entry;
    }

    public NavigableSet<K> navigableKeySet() {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        return this.asNavigable.navigableKeySet();
    }

    public NavigableSet<K> descendingKeySet() {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        return this.asNavigable.descendingKeySet();
    }

    public TrackingMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        NavigableMap<K, V> subMap = this.asNavigable.subMap(fromKey, fromInclusive, toKey, toInclusive);
        return new TrackingMap<K, V>(subMap, this.readKeys);
    }

    public TrackingMap<K, V> headMap(K toKey, boolean inclusive) {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        NavigableMap<K, V> headMap = this.asNavigable.headMap(toKey, inclusive);
        return new TrackingMap<K, V>(headMap, this.readKeys);
    }

    public TrackingMap<K, V> tailMap(K fromKey, boolean inclusive) {
        if (this.asNavigable == null) {
            throw new UnsupportedOperationException("Wrapped map does not support NavigableMap operations");
        }
        NavigableMap<K, V> tailMap = this.asNavigable.tailMap(fromKey, inclusive);
        return new TrackingMap<K, V>(tailMap, this.readKeys);
    }

    public Comparator<? super K> comparator() {
        if (this.asSorted == null) {
            throw new UnsupportedOperationException("Wrapped map does not support SortedMap operations");
        }
        return this.asSorted.comparator();
    }

    public TrackingMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    public TrackingMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    public TrackingMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    public K firstKey() {
        if (this.asSorted == null) {
            throw new UnsupportedOperationException("Wrapped map does not support SortedMap operations");
        }
        K result = this.asSorted.firstKey();
        if (result != null) {
            this.readKeys.add(result);
        }
        return result;
    }

    public K lastKey() {
        if (this.asSorted == null) {
            throw new UnsupportedOperationException("Wrapped map does not support SortedMap operations");
        }
        K result = this.asSorted.lastKey();
        if (result != null) {
            this.readKeys.add(result);
        }
        return result;
    }
}

