/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.mysql.visitor.statement.type;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DMLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.engine.mysql.visitor.statement.MySQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.ReturningSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WindowItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WindowSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.IndexHintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.CallStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DoStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.mysql.dml.MySQLHandlerStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dml.MySQLImportStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dml.MySQLLoadDataStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dml.MySQLLoadXMLStatement;

public final class MySQLDMLStatementVisitor
extends MySQLStatementVisitor
implements DMLStatementVisitor {
    public MySQLDMLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitCall(MySQLStatementParser.CallContext ctx) {
        String procedureName = null == ctx.owner() ? ctx.identifier().getText() : ctx.owner().getText() + "." + ctx.identifier().getText();
        List params = ctx.expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        return new CallStatement(this.getDatabaseType(), procedureName, params);
    }

    @Override
    public ASTNode visitDoStatement(MySQLStatementParser.DoStatementContext ctx) {
        return new DoStatement(this.getDatabaseType(), ctx.expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitHandlerStatement(MySQLStatementParser.HandlerStatementContext ctx) {
        return new MySQLHandlerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitImportStatement(MySQLStatementParser.ImportStatementContext ctx) {
        return new MySQLImportStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitLoadStatement(MySQLStatementParser.LoadStatementContext ctx) {
        return null == ctx.loadDataStatement() ? (ASTNode)this.visit((ParseTree)ctx.loadXmlStatement()) : (ASTNode)this.visit((ParseTree)ctx.loadDataStatement());
    }

    @Override
    public ASTNode visitLoadDataStatement(MySQLStatementParser.LoadDataStatementContext ctx) {
        return new MySQLLoadDataStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
    }

    @Override
    public ASTNode visitLoadXmlStatement(MySQLStatementParser.LoadXmlStatementContext ctx) {
        return new MySQLLoadXMLStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
    }

    @Override
    public ASTNode visitIndexHint(MySQLStatementParser.IndexHintContext ctx) {
        LinkedList indexNames = new LinkedList();
        if (null != ctx.indexNameList()) {
            ctx.indexNameList().indexName().forEach(each -> indexNames.add(each.getText()));
        }
        String useType = null != ctx.USE() ? ctx.USE().getText() : (null != ctx.IGNORE() ? ctx.IGNORE().getText() : ctx.FORCE().getText());
        IndexHintSegment result = new IndexHintSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), indexNames, useType, null == ctx.INDEX() ? ctx.KEY().getText() : ctx.INDEX().getText(), this.getOriginalText(ctx));
        if (null != ctx.indexHintClause().FOR()) {
            String hintScope = null != ctx.indexHintClause().JOIN() ? "JOIN" : (null != ctx.indexHintClause().ORDER() ? "ORDER BY" : "GROUP BY");
            result.setHintScope(hintScope);
        }
        return result;
    }

    @Override
    public ASTNode visitWindowClause(MySQLStatementParser.WindowClauseContext ctx) {
        WindowSegment result = new WindowSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        for (MySQLStatementParser.WindowItemContext each : ctx.windowItem()) {
            result.getItemSegments().add((WindowItemSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitWindowItem(MySQLStatementParser.WindowItemContext ctx) {
        WindowItemSegment result = new WindowItemSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        result.setWindowName(new IdentifierValue(ctx.identifier().getText()));
        WindowItemSegment windowItemSegment = (WindowItemSegment)this.visit((ParseTree)ctx.windowSpecification());
        result.setPartitionListSegments(windowItemSegment.getPartitionListSegments());
        result.setOrderBySegment(windowItemSegment.getOrderBySegment());
        result.setFrameClause(windowItemSegment.getFrameClause());
        return result;
    }

    @Override
    public ASTNode visitWindowSpecification(MySQLStatementParser.WindowSpecificationContext ctx) {
        WindowItemSegment result = new WindowItemSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.PARTITION()) {
            result.setPartitionListSegments(this.getExpressions(ctx.expr()));
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBySegment((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        if (null != ctx.frameClause()) {
            result.setFrameClause((ExpressionSegment)new CommonExpressionSegment(ctx.frameClause().start.getStartIndex(), ctx.frameClause().stop.getStopIndex(), ctx.frameClause().getText()));
        }
        if (null != ctx.identifier()) {
            result.setWindowName(new IdentifierValue(ctx.identifier().getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitWindowFunction(MySQLStatementParser.WindowFunctionContext ctx) {
        super.visitWindowFunction(ctx);
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.funcName.getText(), this.getOriginalText(ctx));
        if (null != ctx.NTILE()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr()));
        }
        if (null != ctx.LEAD() || null != ctx.LAG() || null != ctx.FIRST_VALUE() || null != ctx.LAST_VALUE()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        }
        if (null != ctx.NTH_VALUE()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr()));
        }
        result.setWindow((WindowItemSegment)this.visit((ParseTree)ctx.windowingClause()));
        return result;
    }

    @Override
    public ASTNode visitWindowingClause(MySQLStatementParser.WindowingClauseContext ctx) {
        WindowItemSegment result = new WindowItemSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.windowName) {
            result.setWindowName((IdentifierValue)this.visit((ParseTree)ctx.windowName));
        }
        if (null != ctx.windowSpecification()) {
            WindowItemSegment windowItemSegment = (WindowItemSegment)this.visit((ParseTree)ctx.windowSpecification());
            result.setPartitionListSegments(windowItemSegment.getPartitionListSegments());
            result.setOrderBySegment(windowItemSegment.getOrderBySegment());
            result.setFrameClause(windowItemSegment.getFrameClause());
        }
        return result;
    }

    @Override
    public ASTNode visitReturningClause(MySQLStatementParser.ReturningClauseContext ctx) {
        MySQLStatementParser.TargetListContext targetList = ctx.targetList();
        ProjectionsSegment projectionsSegment = new ProjectionsSegment(targetList.getStart().getStartIndex(), targetList.getStop().getStopIndex());
        for (MySQLStatementParser.ProjectionContext projectionContext : targetList.projection()) {
            projectionsSegment.getProjections().add((ProjectionSegment)this.visit((ParseTree)projectionContext));
        }
        return new ReturningSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), projectionsSegment);
    }
}

