/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.state;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class ProxySQLSupportedJudgeEngine {
    private final Collection<Class<? extends SQLStatement>> supportedStandardSQLStatementTypes;
    private final Collection<Class<? extends SQLStatement>> supportedDialectSQLStatementTypes;
    private final Collection<Class<? extends SQLStatement>> unsupportedStandardSQLStatementTypes;
    private final Collection<Class<? extends SQLStatement>> unsupportedDialectSQLStatementTypes;

    public boolean isSupported(SQLStatement sqlStatement) {
        for (Class<? extends SQLStatement> each : this.combineSQLStatementTypes(this.supportedStandardSQLStatementTypes, this.supportedDialectSQLStatementTypes)) {
            if (!each.isAssignableFrom(sqlStatement.getClass())) continue;
            return true;
        }
        for (Class<? extends SQLStatement> each : this.combineSQLStatementTypes(this.unsupportedStandardSQLStatementTypes, this.unsupportedDialectSQLStatementTypes)) {
            if (!each.isAssignableFrom(sqlStatement.getClass())) continue;
            return false;
        }
        return true;
    }

    private Collection<Class<? extends SQLStatement>> combineSQLStatementTypes(Collection<Class<? extends SQLStatement>> standardSQLStatementTypes, Collection<Class<? extends SQLStatement>> dialectSQLStatementTypes) {
        if (dialectSQLStatementTypes.isEmpty()) {
            return standardSQLStatementTypes;
        }
        LinkedList<Class<? extends SQLStatement>> result = new LinkedList<Class<? extends SQLStatement>>(standardSQLStatementTypes);
        result.addAll(dialectSQLStatementTypes);
        return result;
    }

    @Generated
    public ProxySQLSupportedJudgeEngine(Collection<Class<? extends SQLStatement>> supportedStandardSQLStatementTypes, Collection<Class<? extends SQLStatement>> supportedDialectSQLStatementTypes, Collection<Class<? extends SQLStatement>> unsupportedStandardSQLStatementTypes, Collection<Class<? extends SQLStatement>> unsupportedDialectSQLStatementTypes) {
        this.supportedStandardSQLStatementTypes = supportedStandardSQLStatementTypes;
        this.supportedDialectSQLStatementTypes = supportedDialectSQLStatementTypes;
        this.unsupportedStandardSQLStatementTypes = unsupportedStandardSQLStatementTypes;
        this.unsupportedDialectSQLStatementTypes = unsupportedDialectSQLStatementTypes;
    }
}

