/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.tcl.local;

import lombok.Generated;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseProxyConnectorFactory;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.local.type.BeginTransactionProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.local.type.CommitProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.local.type.ReleaseSavepointProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.local.type.RollbackProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.local.type.RollbackSavepointProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.local.type.SetAutoCommitProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.local.type.SetSavepointProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.local.type.SetTransactionProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.enums.OperationScope;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.BeginTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.ReleaseSavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.RollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SetAutoCommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SetTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.StartTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.TCLStatement;

public final class LocalTCLProxyBackendHandlerFactory {
    public static ProxyBackendHandler newInstance(QueryContext queryContext, ConnectionSession connectionSession) {
        TCLStatement sqlStatement = (TCLStatement)queryContext.getSqlStatementContext().getSqlStatement();
        if (sqlStatement instanceof BeginTransactionStatement || sqlStatement instanceof StartTransactionStatement) {
            return new BeginTransactionProxyBackendHandler(sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof SetAutoCommitStatement) {
            return new SetAutoCommitProxyBackendHandler(sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof CommitStatement) {
            return new CommitProxyBackendHandler(sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof RollbackStatement) {
            return ((RollbackStatement)sqlStatement).getSavepointName().isPresent() ? new RollbackSavepointProxyBackendHandler(sqlStatement, connectionSession) : new RollbackProxyBackendHandler(sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof SavepointStatement) {
            return new SetSavepointProxyBackendHandler(sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof ReleaseSavepointStatement) {
            return new ReleaseSavepointProxyBackendHandler(sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof SetTransactionStatement && !((SetTransactionStatement)sqlStatement).isDesiredScope(OperationScope.GLOBAL)) {
            return new SetTransactionProxyBackendHandler((SetTransactionStatement)sqlStatement, connectionSession);
        }
        return DatabaseProxyConnectorFactory.newInstance(queryContext, connectionSession.getDatabaseConnectionManager(), false);
    }

    @Generated
    private LocalTCLProxyBackendHandlerFactory() {
    }
}

