/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.database;

import lombok.Generated;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.database.type.CreateDatabaseProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.database.type.DropDatabaseProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.DropDatabaseStatement;

public final class DatabaseOperateProxyBackendHandlerFactory {
    public static ProxyBackendHandler newInstance(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        return DatabaseOperateProxyBackendHandlerFactory.createProxyBackendHandler(sqlStatement, connectionSession);
    }

    private static ProxyBackendHandler createProxyBackendHandler(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        ContextManager contextManager = ProxyContext.getInstance().getContextManager();
        if (sqlStatement instanceof CreateDatabaseStatement) {
            return new CreateDatabaseProxyBackendHandler((CreateDatabaseStatement)sqlStatement, contextManager);
        }
        if (sqlStatement instanceof DropDatabaseStatement) {
            return new DropDatabaseProxyBackendHandler((DropDatabaseStatement)sqlStatement, contextManager, connectionSession);
        }
        throw new UnsupportedSQLOperationException(sqlStatement.getClass().getName());
    }

    @Generated
    private DatabaseOperateProxyBackendHandlerFactory() {
    }
}

